/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JSlider;
import javax.swing.JTree;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceOutlineUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.ScaleAwareImageWrapperIcon;

public class RadianceIconFactory {
    private static LazyResettableHashMap<Icon> sliderHorizontalIcons = new LazyResettableHashMap("RadianceIconFactory.sliderHorizontalIcon");
    private static LazyResettableHashMap<Icon> sliderRoundIcons = new LazyResettableHashMap("RadianceIconFactory.sliderRoundIcon");
    private static LazyResettableHashMap<Icon> sliderVerticalIcons = new LazyResettableHashMap("RadianceIconFactory.sliderVerticalIcon");
    private static LazyResettableHashMap<RadianceIcon> treeIcons = new LazyResettableHashMap("RadianceIconFactory.treeIcon");
    private static final Map<IconKind, LazyResettableHashMap<ScaleAwareImageWrapperIcon>> titlePaneIcons = RadianceIconFactory.createTitlePaneIcons();

    public static Icon getSliderHorizontalIcon(JSlider slider, int size, boolean isMirrored) {
        ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(RadianceCommonCortex.getScaleFactor((Component)slider), size, isMirrored);
        if (sliderHorizontalIcons.get(key) == null) {
            SliderHorizontalIcon icon = new SliderHorizontalIcon(size, isMirrored);
            sliderHorizontalIcons.put(key, icon);
        }
        return sliderHorizontalIcons.get(key);
    }

    public static Icon getSliderRoundIcon(JSlider slider, int size) {
        ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(RadianceCommonCortex.getScaleFactor((Component)slider), size);
        if (sliderRoundIcons.get(key) == null) {
            SliderRoundIcon icon = new SliderRoundIcon(size);
            sliderRoundIcons.put(key, icon);
        }
        return sliderRoundIcons.get(key);
    }

    public static Icon getSliderVerticalIcon(JSlider slider, int size, boolean isMirrorred) {
        ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(RadianceCommonCortex.getScaleFactor((Component)slider), size, isMirrorred);
        if (sliderVerticalIcons.get(key) == null) {
            SliderVerticalIcon icon = new SliderVerticalIcon(size, isMirrorred);
            sliderVerticalIcons.put(key, icon);
        }
        return sliderVerticalIcons.get(key);
    }

    public static RadianceIcon getTreeIcon(JTree tree, boolean isCollapsed) {
        double scale = RadianceCommonCortex.getScaleFactor((Component)tree);
        int fontSize = RadianceSizeUtils.getComponentFontSize(tree);
        int size = RadianceSizeUtils.getTreeIconSize(fontSize);
        ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, size, isCollapsed);
        if (treeIcons.get(key) == null) {
            TreeIcon icon = new TreeIcon(size, isCollapsed);
            treeIcons.put(key, icon);
        }
        return treeIcons.get(key);
    }

    private static Map<IconKind, LazyResettableHashMap<ScaleAwareImageWrapperIcon>> createTitlePaneIcons() {
        HashMap<IconKind, LazyResettableHashMap<ScaleAwareImageWrapperIcon>> result = new HashMap<IconKind, LazyResettableHashMap<ScaleAwareImageWrapperIcon>>();
        result.put(IconKind.CLOSE, new LazyResettableHashMap("Close title pane icons"));
        result.put(IconKind.MINIMIZE, new LazyResettableHashMap("Minimize title pane icons"));
        result.put(IconKind.MAXIMIZE, new LazyResettableHashMap("Maximize title pane icons"));
        result.put(IconKind.RESTORE, new LazyResettableHashMap("Restore title pane icons"));
        return result;
    }

    public static ScaleAwareImageWrapperIcon getTitlePaneIcon(Component titlePane, IconKind iconKind, RadianceColorScheme scheme) {
        LazyResettableHashMap<ScaleAwareImageWrapperIcon> kindMap = titlePaneIcons.get((Object)iconKind);
        ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(RadianceCommonCortex.getScaleFactor((Component)titlePane), scheme.getDisplayName());
        ScaleAwareImageWrapperIcon result = kindMap.get(key);
        if (result != null) {
            return result;
        }
        switch (iconKind) {
            case CLOSE: {
                result = RadianceImageCreator.getCloseIcon(titlePane, scheme);
                break;
            }
            case MINIMIZE: {
                result = RadianceImageCreator.getMinimizeIcon(titlePane, scheme);
                break;
            }
            case MAXIMIZE: {
                result = RadianceImageCreator.getMaximizeIcon(titlePane, scheme);
                break;
            }
            case RESTORE: {
                result = RadianceImageCreator.getRestoreIcon(titlePane, scheme);
            }
        }
        kindMap.put(key, result);
        return result;
    }

    public static enum IconKind {
        CLOSE,
        MINIMIZE,
        MAXIMIZE,
        RESTORE;

    }

    private static class TreeIcon
    implements RadianceIcon,
    UIResource {
        private static LazyResettableHashMap<ScaleAwareImageWrapperIcon> icons = new LazyResettableHashMap("RadianceIconFactory.TreeIcon");
        private boolean isCollapsed;
        private int size;

        public TreeIcon(int size, boolean isCollapsed) {
            this.isCollapsed = isCollapsed;
            this.size = size;
        }

        public void setDimension(Dimension newDimension) {
            this.size = newDimension.width;
        }

        public boolean supportsColorFilter() {
            return false;
        }

        public void setColorFilter(RadianceIcon.ColorFilter colorFilter) {
            throw new UnsupportedOperationException();
        }

        private static ScaleAwareImageWrapperIcon getIcon(JTree tree, boolean isCollapsed) {
            double scale = RadianceCommonCortex.getScaleFactor((Component)tree);
            ComponentState state = tree == null || tree.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(tree, state);
            RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(tree, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, state);
            RadianceColorScheme markScheme = RadianceColorSchemeUtilities.getColorScheme(tree, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, state);
            int fontSize = RadianceSizeUtils.getComponentFontSize(tree);
            ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, fontSize, fillScheme.getDisplayName(), borderScheme.getDisplayName(), markScheme.getDisplayName(), isCollapsed);
            ScaleAwareImageWrapperIcon result = icons.get(key);
            if (result != null) {
                return result;
            }
            result = new ScaleAwareImageWrapperIcon(RadianceImageCreator.getTreeIcon(tree, fillScheme, borderScheme, markScheme, isCollapsed), scale);
            icons.put(key, result);
            return result;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JTree tree = c instanceof JTree ? (JTree)c : null;
            ScaleAwareImageWrapperIcon iconToDraw = TreeIcon.getIcon(tree, this.isCollapsed);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(x, y);
            iconToDraw.paintIcon(c, g2d, 0, 0);
            g2d.dispose();
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }

    private static class SliderVerticalIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<ScaleAwareImageWrapperIcon> icons = new LazyResettableHashMap("RadianceIconFactory.SliderVerticalIcon");
        private int size;
        private boolean isMirrorred;

        public SliderVerticalIcon(int size, boolean isMirrorred) {
            this.size = size;
            this.isMirrorred = isMirrorred;
        }

        private ScaleAwareImageWrapperIcon getIcon(JSlider slider, StateTransitionTracker stateTransitionTracker) {
            double scale = RadianceCommonCortex.getScaleFactor((Component)slider);
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
            float activeStrength = stateTransitionTracker.getActiveStrength();
            int height = (int)((double)this.size * (2.0 + (double)activeStrength) / 3.0);
            height = Math.min(height, this.size - 2);
            int delta = (this.size - height) / 2 - 1;
            RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(slider);
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(slider);
            RadianceColorScheme baseFillScheme = RadianceColorSchemeUtilities.getColorScheme(slider, currState);
            RadianceColorScheme baseBorderScheme = RadianceColorSchemeUtilities.getColorScheme(slider, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
            ImageHashMapKey baseKey = RadianceCoreUtilities.getScaleAwareHashKey(scale, this.size, height, slider.getComponentOrientation(), baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), this.isMirrorred);
            ScaleAwareImageWrapperIcon baseLayer = icons.get(baseKey);
            if (baseLayer == null) {
                baseLayer = this.getSingleLayer(slider, height, delta, fillPainter, borderPainter, baseFillScheme, baseBorderScheme);
                icons.put(baseKey, baseLayer);
            }
            if (currState.isDisabled() || activeStates.size() == 1) {
                return baseLayer;
            }
            BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, baseLayer.getIconWidth(), baseLayer.getIconHeight());
            Graphics2D g2d = result.createGraphics();
            baseLayer.paintIcon(slider, g2d, 0, 0);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
                RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(slider, activeState);
                RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(slider, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, activeState);
                ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, this.size, height, slider.getComponentOrientation(), fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), this.isMirrorred);
                ScaleAwareImageWrapperIcon layer = icons.get(key);
                if (layer == null) {
                    layer = this.getSingleLayer(slider, height, delta, fillPainter, borderPainter, fillScheme, borderScheme);
                    icons.put(key, layer);
                }
                g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
                layer.paintIcon(slider, g2d, 0, 0);
            }
            g2d.dispose();
            return new ScaleAwareImageWrapperIcon(result, scale);
        }

        private ScaleAwareImageWrapperIcon getSingleLayer(JSlider slider, int height, int delta, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme) {
            double scale = RadianceCommonCortex.getScaleFactor((Component)slider);
            float borderDelta = RadianceSizeUtils.getBorderStrokeWidth(slider) / 2.0f;
            GeneralPath contour = RadianceOutlineUtilities.getTriangleButtonOutline(height, this.size - 1, 2.0f, borderDelta);
            BufferedImage stateImage = RadianceCoreUtilities.getBlankImage(scale, this.size - 1, this.size - 1);
            Graphics2D g2d = stateImage.createGraphics();
            g2d.translate(delta, 0);
            fillPainter.paintContourBackground(g2d, slider, height, this.size, contour, false, fillScheme, true);
            float borderThickness = RadianceSizeUtils.getBorderStrokeWidth(slider);
            GeneralPath contourInner = RadianceOutlineUtilities.getTriangleButtonOutline(height, this.size - 1, 2.0f, borderThickness + borderDelta);
            borderPainter.paintBorder(g2d, slider, height, this.size - 1, contour, contourInner, borderScheme);
            stateImage = this.isMirrorred ? RadianceImageCreator.getRotated(scale, stateImage, 1) : RadianceImageCreator.getRotated(scale, stateImage, 3);
            if (!slider.getComponentOrientation().isLeftToRight()) {
                stateImage = RadianceImageCreator.getRotated(scale, stateImage, 2);
            }
            return new ScaleAwareImageWrapperIcon(stateImage, scale);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)slider.getUI());
            StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
            ScaleAwareImageWrapperIcon iconToDraw = this.getIcon(slider, stateTransitionTracker);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g2d.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.size - 1;
        }

        @Override
        public int getIconHeight() {
            return this.size - 1;
        }
    }

    private static class SliderRoundIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<ScaleAwareImageWrapperIcon> icons = new LazyResettableHashMap("RadianceIconFactory.SliderRoundIcon");
        private int size;

        public SliderRoundIcon(int size) {
            this.size = size;
        }

        private ScaleAwareImageWrapperIcon getIcon(JSlider slider, StateTransitionTracker stateTransitionTracker) {
            double scale = RadianceCommonCortex.getScaleFactor((Component)slider);
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
            float activeStrength = stateTransitionTracker.getActiveStrength();
            float width = (float)this.size * (2.0f + activeStrength) / 3.0f;
            RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(slider);
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(slider);
            RadianceColorScheme baseFillScheme = RadianceColorSchemeUtilities.getColorScheme(slider, currState);
            RadianceColorScheme baseBorderScheme = RadianceColorSchemeUtilities.getColorScheme(slider, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
            ImageHashMapKey baseKey = RadianceCoreUtilities.getScaleAwareHashKey(scale, this.size, Float.valueOf(width), baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName());
            ScaleAwareImageWrapperIcon baseLayer = icons.get(baseKey);
            if (baseLayer == null) {
                baseLayer = this.getSingleLayer(slider, width, fillPainter, borderPainter, baseFillScheme, baseBorderScheme);
                icons.put(baseKey, baseLayer);
            }
            if (currState.isDisabled() || activeStates.size() == 1) {
                return baseLayer;
            }
            BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, baseLayer.getIconWidth(), baseLayer.getIconHeight());
            Graphics2D g2d = result.createGraphics();
            baseLayer.paintIcon(slider, g2d, 0, 0);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
                RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(slider, activeState);
                RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(slider, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, activeState);
                ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, this.size, Float.valueOf(width), fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName());
                ScaleAwareImageWrapperIcon layer = icons.get(key);
                if (layer == null) {
                    layer = this.getSingleLayer(slider, width, fillPainter, borderPainter, fillScheme, borderScheme);
                    icons.put(key, layer);
                }
                g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
                layer.paintIcon(slider, g2d, 0, 0);
            }
            g2d.dispose();
            return new ScaleAwareImageWrapperIcon(result, scale);
        }

        private ScaleAwareImageWrapperIcon getSingleLayer(JSlider slider, float width, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme) {
            double scale = RadianceCommonCortex.getScaleFactor((Component)slider);
            float borderDelta = RadianceSizeUtils.getBorderStrokeWidth(slider) / 2.0f;
            Ellipse2D.Float contour = new Ellipse2D.Float(borderDelta, borderDelta, width - 2.0f * borderDelta - 1.0f, width - 2.0f * borderDelta - 1.0f);
            BufferedImage stateImage = RadianceCoreUtilities.getBlankImage(scale, this.size, this.size);
            Graphics2D g2d = stateImage.createGraphics();
            float delta = ((float)this.size - width) / 2.0f;
            g2d.translate(delta, delta);
            fillPainter.paintContourBackground(g2d, slider, width, this.size, contour, false, fillScheme, true);
            float borderThickness = RadianceSizeUtils.getBorderStrokeWidth(slider);
            Ellipse2D.Float contourInner = new Ellipse2D.Float(borderDelta + borderThickness, borderDelta + borderThickness, width - 2.0f * borderDelta - 2.0f * borderThickness - 1.0f, width - 2.0f * borderDelta - 2.0f * borderThickness - 1.0f);
            borderPainter.paintBorder(g2d, slider, width, this.size, contour, contourInner, borderScheme);
            return new ScaleAwareImageWrapperIcon(stateImage, scale);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)slider.getUI());
            StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
            ScaleAwareImageWrapperIcon iconToDraw = this.getIcon(slider, stateTransitionTracker);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g2d.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    private static class SliderHorizontalIcon
    implements Icon,
    UIResource {
        private static LazyResettableHashMap<ScaleAwareImageWrapperIcon> icons = new LazyResettableHashMap("RadianceIconFactory.SliderHorizontalIcon");
        private int size;
        private boolean isMirrorred;

        public SliderHorizontalIcon(int size, boolean isMirrorred) {
            this.size = size;
            this.isMirrorred = isMirrorred;
        }

        private ScaleAwareImageWrapperIcon getIcon(JSlider slider, StateTransitionTracker stateTransitionTracker) {
            double scale = RadianceCommonCortex.getScaleFactor((Component)slider);
            StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
            Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
            ComponentState currState = stateTransitionTracker.getModelStateInfo().getCurrModelState();
            float activeStrength = stateTransitionTracker.getActiveStrength();
            float width = (float)this.size * (2.0f + activeStrength) / 3.0f;
            RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(slider);
            RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(slider);
            RadianceColorScheme baseFillScheme = RadianceColorSchemeUtilities.getColorScheme(slider, currState);
            RadianceColorScheme baseBorderScheme = RadianceColorSchemeUtilities.getColorScheme(slider, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
            ImageHashMapKey baseKey = RadianceCoreUtilities.getScaleAwareHashKey(scale, this.size, Float.valueOf(width), baseFillScheme.getDisplayName(), baseBorderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), this.isMirrorred);
            ScaleAwareImageWrapperIcon baseLayer = icons.get(baseKey);
            if (baseLayer == null) {
                baseLayer = this.getSingleLayer(slider, width, fillPainter, borderPainter, baseFillScheme, baseBorderScheme);
                icons.put(baseKey, baseLayer);
            }
            if (currState.isDisabled() || activeStates.size() == 1) {
                return baseLayer;
            }
            BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, baseLayer.getIconWidth(), baseLayer.getIconHeight());
            Graphics2D g2d = result.createGraphics();
            baseLayer.paintIcon(slider, g2d, 0, 0);
            for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
                float contribution;
                ComponentState activeState = activeEntry.getKey();
                if (activeState == currState || (contribution = activeEntry.getValue().getContribution()) == 0.0f) continue;
                RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(slider, activeState);
                RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(slider, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, activeState);
                ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, this.size, Float.valueOf(width), fillScheme.getDisplayName(), borderScheme.getDisplayName(), fillPainter.getDisplayName(), borderPainter.getDisplayName(), this.isMirrorred);
                ScaleAwareImageWrapperIcon layer = icons.get(key);
                if (layer == null) {
                    layer = this.getSingleLayer(slider, width, fillPainter, borderPainter, fillScheme, borderScheme);
                    icons.put(key, layer);
                }
                g2d.setComposite(AlphaComposite.SrcOver.derive(contribution));
                layer.paintIcon(slider, g2d, 0, 0);
            }
            g2d.dispose();
            return new ScaleAwareImageWrapperIcon(result, scale);
        }

        private ScaleAwareImageWrapperIcon getSingleLayer(JSlider slider, float width, RadianceFillPainter fillPainter, RadianceBorderPainter borderPainter, RadianceColorScheme fillScheme, RadianceColorScheme borderScheme) {
            double scale = RadianceCommonCortex.getScaleFactor((Component)slider);
            float borderDelta = RadianceSizeUtils.getBorderStrokeWidth(slider) / 2.0f;
            GeneralPath contour = RadianceOutlineUtilities.getTriangleButtonOutline(width, this.size - 1, 2.0f, borderDelta);
            BufferedImage stateImage = RadianceCoreUtilities.getBlankImage(scale, this.size, this.size);
            Graphics2D g2d = stateImage.createGraphics();
            g2d.translate(((float)this.size - width) / 2.0f, 0.0);
            fillPainter.paintContourBackground(g2d, slider, width, this.size, contour, false, fillScheme, true);
            float borderThickness = RadianceSizeUtils.getBorderStrokeWidth(slider);
            GeneralPath contourInner = RadianceOutlineUtilities.getTriangleButtonOutline(width, this.size - 1, 2.0f, borderThickness + borderDelta);
            borderPainter.paintBorder(g2d, slider, width, this.size, contour, contourInner, borderScheme);
            g2d.dispose();
            if (this.isMirrorred) {
                stateImage = RadianceImageCreator.getRotated(scale, stateImage, 2);
            }
            return new ScaleAwareImageWrapperIcon(stateImage, scale);
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!(g instanceof Graphics2D)) {
                return;
            }
            JSlider slider = (JSlider)c;
            TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)slider.getUI());
            StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
            ScaleAwareImageWrapperIcon iconToDraw = this.getIcon(slider, stateTransitionTracker);
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.translate(x, y);
            iconToDraw.paintIcon(c, g, 0, 0);
            g2d.dispose();
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }
}

