/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.plaf.UIResource;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.painter.border.RadianceBorderPainter;
import org.pushingpixels.radiance.theming.api.painter.fill.RadianceFillPainter;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.ScaleAwareImageWrapperIcon;

public class RadioButtonMenuItemIcon
implements Icon,
UIResource {
    private int size;
    private JMenuItem menuItem;
    private static LazyResettableHashMap<ScaleAwareImageWrapperIcon> iconMap = new LazyResettableHashMap("RadioButtonMenuItemIcon");

    public RadioButtonMenuItemIcon(JMenuItem menuItem, int size) {
        this.menuItem = menuItem;
        this.size = size;
    }

    private ScaleAwareImageWrapperIcon getIconToPaint() {
        if (this.menuItem == null) {
            return null;
        }
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)this.menuItem.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        double scale = RadianceCommonCortex.getScaleFactor((Component)this.menuItem);
        int fontSize = RadianceSizeUtils.getComponentFontSize(this.menuItem);
        int checkMarkSize = this.size;
        RadianceFillPainter fillPainter = RadianceCoreUtilities.getFillPainter(this.menuItem);
        RadianceBorderPainter borderPainter = RadianceCoreUtilities.getBorderPainter(this.menuItem);
        ComponentState currState = modelStateInfo.getCurrModelState();
        RadianceColorScheme baseFillColorScheme = RadianceColorSchemeUtilities.getColorScheme(this.menuItem, RadianceThemingSlices.ColorSchemeAssociationKind.MARK_BOX, currState);
        RadianceColorScheme baseMarkColorScheme = RadianceColorSchemeUtilities.getColorScheme(this.menuItem, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, currState);
        RadianceColorScheme baseBorderColorScheme = RadianceColorSchemeUtilities.getColorScheme(this.menuItem, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, currState);
        float visibility = stateTransitionTracker.getFacetStrength(RadianceThemingSlices.ComponentStateFacet.SELECTION);
        float alpha = RadianceColorSchemeUtilities.getAlpha(this.menuItem, currState);
        ImageHashMapKey keyBase = RadianceCoreUtilities.getScaleAwareHashKey(scale, fontSize, checkMarkSize, fillPainter.getDisplayName(), borderPainter.getDisplayName(), baseFillColorScheme.getDisplayName(), baseMarkColorScheme.getDisplayName(), baseBorderColorScheme.getDisplayName(), Float.valueOf(visibility), Float.valueOf(alpha));
        ScaleAwareImageWrapperIcon iconBase = iconMap.get(keyBase);
        if (iconBase == null) {
            iconBase = new ScaleAwareImageWrapperIcon(RadianceImageCreator.getRadioButton(this.menuItem, fillPainter, borderPainter, checkMarkSize, currState, 0, baseFillColorScheme, baseMarkColorScheme, baseBorderColorScheme, visibility, alpha), scale);
            iconMap.put(keyBase, iconBase);
        }
        if (currState.isDisabled() || activeStates.size() == 1) {
            return iconBase;
        }
        BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, iconBase.getIconWidth(), iconBase.getIconHeight());
        Graphics2D g2d = result.createGraphics();
        iconBase.paintIcon(this.menuItem, g2d, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            RadianceColorScheme fillColorScheme = RadianceColorSchemeUtilities.getColorScheme(this.menuItem, RadianceThemingSlices.ColorSchemeAssociationKind.MARK_BOX, activeState);
            RadianceColorScheme markColorScheme = RadianceColorSchemeUtilities.getColorScheme(this.menuItem, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, activeState);
            RadianceColorScheme borderColorScheme = RadianceColorSchemeUtilities.getColorScheme(this.menuItem, RadianceThemingSlices.ColorSchemeAssociationKind.BORDER, activeState);
            ImageHashMapKey keyLayer = RadianceCoreUtilities.getScaleAwareHashKey(scale, fontSize, checkMarkSize, fillPainter.getDisplayName(), borderPainter.getDisplayName(), fillColorScheme.getDisplayName(), markColorScheme.getDisplayName(), borderColorScheme.getDisplayName(), Float.valueOf(visibility), Float.valueOf(alpha));
            ScaleAwareImageWrapperIcon iconLayer = iconMap.get(keyLayer);
            if (iconLayer == null) {
                iconLayer = new ScaleAwareImageWrapperIcon(RadianceImageCreator.getRadioButton(this.menuItem, fillPainter, borderPainter, checkMarkSize, currState, 0, fillColorScheme, markColorScheme, borderColorScheme, visibility, alpha), scale);
                iconMap.put(keyLayer, iconLayer);
            }
            iconLayer.paintIcon(this.menuItem, g2d, 0, 0);
        }
        g2d.dispose();
        return new ScaleAwareImageWrapperIcon(result, scale);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        ScaleAwareImageWrapperIcon iconToDraw = this.getIconToPaint();
        if (iconToDraw != null) {
            iconToDraw.paintIcon(c, g, x, y);
        }
    }

    @Override
    public int getIconWidth() {
        ScaleAwareImageWrapperIcon iconToDraw = this.getIconToPaint();
        return iconToDraw == null ? 0 : iconToDraw.getIconWidth();
    }

    @Override
    public int getIconHeight() {
        ScaleAwareImageWrapperIcon iconToDraw = this.getIconToPaint();
        return iconToDraw == null ? 0 : iconToDraw.getIconHeight();
    }
}

