/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.icon;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.common.api.icon.RadianceIcon;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.ImageHashMapKey;
import org.pushingpixels.radiance.theming.internal.utils.LazyResettableHashMap;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.ScaleAwareImageWrapperIcon;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAware;

@TransitionAware
public class TransitionAwareIcon
implements Icon {
    private JComponent comp;
    private TransitionAwareUIDelegate transitionAwareUIDelegate;
    private Delegate delegate;
    private ColorSchemeAssociationKindDelegate colorSchemeAssociationKindDelegate;
    private String uniqueIconTypeId;
    private static LazyResettableHashMap<RadianceIcon> iconMap = new LazyResettableHashMap("TransitionAwareIcon");
    private int iconWidth;
    private int iconHeight;

    public TransitionAwareIcon(AbstractButton button, Delegate delegate, String uniqueIconTypeId) {
        this(button, button == null ? null : () -> (TransitionAwareUI)((Object)button.getUI()), delegate, null, uniqueIconTypeId);
    }

    public TransitionAwareIcon(JComponent comp, TransitionAwareUIDelegate transitionAwareUIDelegate, Delegate delegate, ColorSchemeAssociationKindDelegate colorSchemeAssociationKindDelegate, String uniqueIconTypeId) {
        this.comp = comp;
        this.transitionAwareUIDelegate = transitionAwareUIDelegate;
        this.delegate = delegate;
        this.colorSchemeAssociationKindDelegate = colorSchemeAssociationKindDelegate;
        this.uniqueIconTypeId = uniqueIconTypeId;
        RadianceIcon markEnabledIcon = this.delegate.getColorSchemeIcon(RadianceColorSchemeUtilities.getColorScheme(comp, RadianceThemingSlices.ColorSchemeAssociationKind.MARK, ComponentState.ENABLED));
        this.iconWidth = markEnabledIcon.getIconWidth();
        this.iconHeight = markEnabledIcon.getIconHeight();
    }

    private synchronized RadianceIcon getIconToPaint() {
        double scale = RadianceCommonCortex.getScaleFactor((Component)this.comp);
        StateTransitionTracker stateTransitionTracker = this.transitionAwareUIDelegate.getTransitionAwareUI().getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateContributionMap();
        ComponentState currState = modelStateInfo.getCurrModelState();
        boolean buttonNeverPainted = RadianceCoreUtilities.isButtonNeverPainted(this.comp);
        if (buttonNeverPainted && currState.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ENABLE)) {
            currState = ComponentState.ENABLED;
        }
        RadianceThemingSlices.ColorSchemeAssociationKind baseAssociationKind = this.colorSchemeAssociationKindDelegate == null ? RadianceThemingSlices.ColorSchemeAssociationKind.MARK : this.colorSchemeAssociationKindDelegate.getColorSchemeAssociationKind(currState);
        RadianceColorScheme baseScheme = RadianceColorSchemeUtilities.getColorScheme(this.comp, baseAssociationKind, currState);
        float baseAlpha = RadianceColorSchemeUtilities.getAlpha(this.comp, currState);
        ImageHashMapKey keyBase = RadianceCoreUtilities.getScaleAwareHashKey(scale, this.uniqueIconTypeId, RadianceSizeUtils.getComponentFontSize(this.comp), baseScheme.getDisplayName(), Float.valueOf(baseAlpha));
        RadianceIcon layerBase = iconMap.get(keyBase);
        if (layerBase == null) {
            RadianceIcon baseFullOpacity = this.delegate.getColorSchemeIcon(baseScheme);
            if (baseAlpha == 1.0f) {
                layerBase = baseFullOpacity;
                iconMap.put(keyBase, layerBase);
            } else {
                BufferedImage baseImage = RadianceCoreUtilities.getBlankImage(scale, baseFullOpacity.getIconWidth(), baseFullOpacity.getIconHeight());
                Graphics2D g2base = baseImage.createGraphics();
                g2base.setComposite(AlphaComposite.SrcOver.derive(baseAlpha));
                baseFullOpacity.paintIcon((Component)this.comp, (Graphics)g2base, 0, 0);
                g2base.dispose();
                layerBase = new ScaleAwareImageWrapperIcon(baseImage, scale);
                iconMap.put(keyBase, layerBase);
            }
        }
        if (currState.isDisabled() || activeStates.size() == 1 || buttonNeverPainted) {
            return layerBase;
        }
        BufferedImage result = RadianceCoreUtilities.getBlankImage(scale, layerBase.getIconWidth(), layerBase.getIconHeight());
        Graphics2D g2d = result.createGraphics();
        layerBase.paintIcon((Component)this.comp, (Graphics)g2d, 0, 0);
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> activeEntry : activeStates.entrySet()) {
            float stateContribution;
            ComponentState activeState = activeEntry.getKey();
            if (activeState == currState || !((stateContribution = activeEntry.getValue().getContribution()) > 0.0f)) continue;
            g2d.setComposite(AlphaComposite.SrcOver.derive(stateContribution));
            RadianceThemingSlices.ColorSchemeAssociationKind associationKind = this.colorSchemeAssociationKindDelegate == null ? RadianceThemingSlices.ColorSchemeAssociationKind.MARK : this.colorSchemeAssociationKindDelegate.getColorSchemeAssociationKind(activeState);
            RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(this.comp, associationKind, activeState);
            float alpha = RadianceColorSchemeUtilities.getAlpha(this.comp, activeState);
            ImageHashMapKey key = RadianceCoreUtilities.getScaleAwareHashKey(scale, this.uniqueIconTypeId, RadianceSizeUtils.getComponentFontSize(this.comp), scheme.getDisplayName(), Float.valueOf(alpha));
            RadianceIcon layer = iconMap.get(key);
            if (layer == null) {
                RadianceIcon fullOpacity = this.delegate.getColorSchemeIcon(scheme);
                if (alpha == 1.0f) {
                    layer = fullOpacity;
                    iconMap.put(key, layer);
                } else {
                    BufferedImage image = RadianceCoreUtilities.getBlankImage(scale, fullOpacity.getIconWidth(), fullOpacity.getIconHeight());
                    Graphics2D g2layer = image.createGraphics();
                    g2layer.setComposite(AlphaComposite.SrcOver.derive(alpha));
                    fullOpacity.paintIcon((Component)this.comp, (Graphics)g2layer, 0, 0);
                    g2layer.dispose();
                    layer = new ScaleAwareImageWrapperIcon(image, scale);
                    iconMap.put(key, layer);
                }
            }
            layer.paintIcon((Component)this.comp, (Graphics)g2d, 0, 0);
        }
        g2d.dispose();
        return new ScaleAwareImageWrapperIcon(result, scale);
    }

    @Override
    public int getIconHeight() {
        return this.iconHeight;
    }

    @Override
    public int getIconWidth() {
        return this.iconWidth;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getIconToPaint().paintIcon(c, g, x, y);
    }

    @FunctionalInterface
    public static interface TransitionAwareUIDelegate {
        public TransitionAwareUI getTransitionAwareUI();
    }

    @FunctionalInterface
    public static interface ColorSchemeAssociationKindDelegate {
        public RadianceThemingSlices.ColorSchemeAssociationKind getColorSchemeAssociationKind(ComponentState var1);
    }

    @FunctionalInterface
    public static interface Delegate {
        public RadianceIcon getColorSchemeIcon(RadianceColorScheme var1);
    }
}

