/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.utils.menu;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.pushingpixels.radiance.theming.api.ComponentState;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.internal.animation.StateTransitionTracker;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.painter.BackgroundPaintingUtils;
import org.pushingpixels.radiance.theming.internal.painter.HighlightPainterUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.menu.MenuUtilities;

public class RadianceMenuBackgroundDelegate {
    public static void paintBackground(Graphics g, JComponent menuItem, int textOffset) {
        if (!menuItem.isShowing()) {
            return;
        }
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BackgroundPaintingUtils.update(graphics, menuItem, false);
        if (textOffset == 0) {
            return;
        }
        if (menuItem.getParent() instanceof JPopupMenu) {
            JPopupMenu parent = (JPopupMenu)menuItem.getParent();
            MenuUtilities.MenuLayoutMetrics popupMetrics = MenuUtilities.getPopupLayoutMetrics(parent, true);
            float fillAlpha = RadianceCoreUtilities.getMenuGutterFillAlpha();
            boolean hasGutterContent = popupMetrics.maxIconWidth > 0 || popupMetrics.maxCheckIconWidth > 0;
            boolean shouldPaintGutter = hasGutterContent;
            if (shouldPaintGutter) {
                graphics.setComposite(WidgetUtilities.getAlphaComposite(menuItem, fillAlpha, g));
                RadianceColorScheme scheme = RadianceColorSchemeUtilities.getColorScheme(menuItem, ComponentState.ENABLED);
                graphics.setColor(scheme.getAccentedBackgroundFillColor());
                if (menuItem.getComponentOrientation().isLeftToRight()) {
                    graphics.fillRect(0, 0, textOffset - 2, menuHeight);
                } else {
                    graphics.fillRect(textOffset - 2, 0, menuWidth, menuHeight);
                }
            }
        }
        graphics.dispose();
    }

    public static void paintHighlights(Graphics g, JMenuItem menuItem, float borderAlpha) {
        Graphics2D graphics = (Graphics2D)g.create();
        TransitionAwareUI transitionAwareUI = (TransitionAwareUI)((Object)menuItem.getUI());
        StateTransitionTracker stateTransitionTracker = transitionAwareUI.getTransitionTracker();
        StateTransitionTracker.ModelStateInfo modelStateInfo = stateTransitionTracker.getModelStateInfo();
        ComponentState currState = modelStateInfo.getCurrModelStateNoSelection();
        if (currState.isDisabled()) {
            return;
        }
        Map<ComponentState, StateTransitionTracker.StateContributionInfo> activeStates = modelStateInfo.getStateNoSelectionContributionMap();
        if (currState == ComponentState.ENABLED && activeStates.size() == 1) {
            return;
        }
        for (Map.Entry<ComponentState, StateTransitionTracker.StateContributionInfo> stateEntry : activeStates.entrySet()) {
            ComponentState activeState = stateEntry.getKey();
            float alpha = RadianceColorSchemeUtilities.getHighlightAlpha(menuItem, activeState) * stateEntry.getValue().getContribution();
            if (alpha == 0.0f) continue;
            RadianceColorScheme fillScheme = RadianceColorSchemeUtilities.getColorScheme(menuItem, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT, activeState);
            RadianceColorScheme borderScheme = RadianceColorSchemeUtilities.getColorScheme(menuItem, RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT_BORDER, activeState);
            graphics.setComposite(WidgetUtilities.getAlphaComposite(menuItem, alpha, g));
            HighlightPainterUtils.paintHighlight(graphics, null, menuItem, new Rectangle(0, 0, menuItem.getWidth(), menuItem.getHeight()), borderAlpha, null, fillScheme, borderScheme);
            graphics.setComposite(WidgetUtilities.getAlphaComposite((Component)menuItem, g));
        }
        graphics.dispose();
    }
}

