/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.widget.menu;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.pushingpixels.radiance.common.api.RadianceCommonCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingCortex;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.internal.animation.TransitionAwareUI;
import org.pushingpixels.radiance.theming.internal.utils.RadianceCoreUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.RadianceSizeUtils;
import org.pushingpixels.radiance.theming.internal.utils.RadianceTitlePane;
import org.pushingpixels.radiance.theming.internal.utils.RadianceWidgetManager;
import org.pushingpixels.radiance.theming.internal.utils.icon.TransitionAwareIcon;

public class MenuSearchWidget
extends RadianceThemingWidget<JMenuBar> {
    private boolean inEvent = false;
    private PropertyChangeListener propertyListener;
    private SearchPanel searchPanel;

    private static boolean toInstallMenuSearch(JMenuBar menuBar) {
        if (!RadianceWidgetManager.getInstance().isAllowed(SwingUtilities.getRootPane(menuBar), RadianceThemingSlices.WidgetType.MENU_SEARCH)) {
            return false;
        }
        if (menuBar instanceof RadianceTitlePane.RadianceMenuBar) {
            return false;
        }
        return MenuSearchWidget.getMenuItemCount(menuBar) > 40;
    }

    private static int getMenuItemCount(JMenuItem menuItem) {
        int result = 1;
        if (menuItem instanceof JMenu) {
            JMenu menu = (JMenu)menuItem;
            for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
                Component child = menu.getMenuComponent(i);
                if (!(child instanceof JMenuItem)) continue;
                result += MenuSearchWidget.getMenuItemCount((JMenuItem)child);
            }
        }
        return result;
    }

    public static int getMenuItemCount(JMenuBar menuBar) {
        int result = 0;
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (menu == null) continue;
            result += MenuSearchWidget.getMenuItemCount(menu);
        }
        return result;
    }

    @Override
    public void installUI() {
        this.searchPanel = new SearchPanel();
        ((JMenuBar)this.jcomp).add((Component)this.searchPanel, ((JMenuBar)this.jcomp).getComponentCount());
        this.searchPanel.setVisible(MenuSearchWidget.toInstallMenuSearch((JMenuBar)this.jcomp));
        ((JMenuBar)this.jcomp).addContainerListener(new ContainerAdapter(){

            @Override
            public void componentAdded(ContainerEvent e) {
                if (!(e.getChild() instanceof JMenu)) {
                    return;
                }
                if (!MenuSearchWidget.this.inEvent) {
                    MenuSearchWidget.this.inEvent = true;
                    Component removed = null;
                    for (int i = 0; i < ((JMenuBar)MenuSearchWidget.this.jcomp).getComponentCount(); ++i) {
                        if (!(((JMenuBar)MenuSearchWidget.this.jcomp).getComponent(i) instanceof SearchPanel)) continue;
                        removed = ((JMenuBar)MenuSearchWidget.this.jcomp).getComponent(i);
                        break;
                    }
                    if (removed != null) {
                        ((JMenuBar)MenuSearchWidget.this.jcomp).remove(removed);
                        ((JMenuBar)MenuSearchWidget.this.jcomp).add(removed, ((JMenuBar)MenuSearchWidget.this.jcomp).getComponentCount());
                        removed.setVisible(MenuSearchWidget.toInstallMenuSearch((JMenuBar)MenuSearchWidget.this.jcomp));
                    }
                    MenuSearchWidget.this.inEvent = false;
                }
            }
        });
        this.searchPanel.applyComponentOrientation(((JMenuBar)this.jcomp).getComponentOrientation());
    }

    @Override
    public void uninstallUI() {
        ((JMenuBar)this.jcomp).remove(this.searchPanel);
        super.uninstallUI();
    }

    @Override
    public void installListeners() {
        super.installListeners();
        this.propertyListener = propertyChangeEvent -> {
            if ("componentOrientation".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(() -> {
                    if (this.searchPanel != null) {
                        this.searchPanel.applyComponentOrientation((ComponentOrientation)propertyChangeEvent.getNewValue());
                    }
                    this.reset();
                });
            }
            if ("locale".equals(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(this::reset);
            }
        };
        ((JMenuBar)this.jcomp).addPropertyChangeListener(this.propertyListener);
    }

    @Override
    public void uninstallListeners() {
        ((JMenuBar)this.jcomp).removePropertyChangeListener(this.propertyListener);
        this.propertyListener = null;
    }

    private void reset() {
        if (this.searchPanel == null) {
            return;
        }
        double scale = RadianceCommonCortex.getScaleFactor((Component)this.searchPanel);
        for (Map.Entry entry : this.searchPanel.resultButtons.entrySet()) {
            int index = (Integer)entry.getKey();
            JButton button = (JButton)entry.getValue();
            button.setIcon(new TransitionAwareIcon(button, () -> (TransitionAwareUI)((Object)button.getUI()), scheme -> RadianceImageCreator.getHexaMarker(scale, index, scheme), state -> state.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) ? RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT : RadianceThemingSlices.ColorSchemeAssociationKind.MARK, "radiance.theming.internal.widget.menusearch." + index));
        }
        this.searchPanel.updateSearchIcon();
        ResourceBundle bundle = RadianceThemingCortex.GlobalScope.getLabelBundle();
        this.searchPanel.searchButton.setToolTipText(bundle.getString("Tooltip.menuSearchButton"));
        this.searchPanel.searchStringField.setToolTipText(bundle.getString("Tooltip.menuSearchField"));
    }

    private class SearchResultsLayout
    implements LayoutManager {
        private SearchPanel searchPanel;

        public SearchResultsLayout(SearchPanel searchPanel) {
            this.searchPanel = searchPanel;
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            if (this.searchPanel.searchButton.isSelected()) {
                return c.getSize();
            }
            int buttonSize = RadianceSizeUtils.getLookupButtonSize();
            return new Dimension(buttonSize, buttonSize);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int buttonSize = RadianceSizeUtils.getLookupButtonSize();
            return new Dimension(buttonSize, buttonSize);
        }

        @Override
        public void layoutContainer(Container c) {
            block5: {
                int width;
                int height;
                block4: {
                    height = c.getHeight();
                    width = c.getWidth();
                    if (!this.searchPanel.searchButton.isVisible()) {
                        return;
                    }
                    boolean leftToRight = ((JMenuBar)MenuSearchWidget.this.jcomp).getComponentOrientation().isLeftToRight();
                    if (!leftToRight) break block4;
                    int x = 2;
                    int sbWidth = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().width;
                    int sbHeight = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().height;
                    this.searchPanel.searchButton.setBounds(x, (height - sbHeight) / 2, sbWidth, sbHeight);
                    x += sbWidth + 4;
                    if (!this.searchPanel.isVisible()) break block5;
                    int tbWidth = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().width;
                    int tbHeight = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().height;
                    tbHeight = Math.min(tbHeight, height - 2);
                    this.searchPanel.searchStringField.setBounds(x, (height - tbHeight) / 2, tbWidth, tbHeight);
                    x += tbWidth + 2;
                    int buttonCount = this.searchPanel.resultButtons.size();
                    for (int i = 1; i <= buttonCount; ++i) {
                        JButton button = (JButton)this.searchPanel.resultButtons.get(i);
                        int bw = button.getPreferredSize().width;
                        int bh = button.getPreferredSize().height;
                        button.setBounds(x, (height - bh) / 2, bw, bh);
                        x += bw + 1;
                    }
                    break block5;
                }
                int x = width - 2;
                int sbWidth = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().width;
                int sbHeight = ((SearchPanel)this.searchPanel).searchButton.getPreferredSize().height;
                this.searchPanel.searchButton.setBounds(x - sbWidth, (height - sbHeight) / 2, sbWidth, sbHeight);
                x -= sbWidth + 4;
                if (this.searchPanel.isVisible()) {
                    int tbWidth = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().width;
                    int tbHeight = ((SearchPanel)this.searchPanel).searchStringField.getPreferredSize().height;
                    tbHeight = Math.min(tbHeight, height - 2);
                    this.searchPanel.searchStringField.setBounds(x - tbWidth, (height - tbHeight) / 2, tbWidth, tbHeight);
                    x -= tbWidth + 2;
                    int buttonCount = this.searchPanel.resultButtons.size();
                    for (int i = 1; i <= buttonCount; ++i) {
                        JButton button = (JButton)this.searchPanel.resultButtons.get(i);
                        int bw = button.getPreferredSize().width;
                        int bh = button.getPreferredSize().height;
                        button.setBounds(x - bw, (height - bh) / 2, bw, bh);
                        x -= bw + 1;
                    }
                }
            }
        }
    }

    private static class SearchResult {
        private MenuElement[] menuElements;

        public SearchResult(JMenuBar menuBar, LinkedList<JMenu> menuPath, JMenuItem menuLeaf) {
            int count = 1;
            if (menuPath != null) {
                count += 2 * menuPath.size();
            }
            if (menuLeaf != null) {
                ++count;
            }
            this.menuElements = new MenuElement[count];
            count = 0;
            this.menuElements[count++] = menuBar;
            if (menuPath != null) {
                for (JMenu menu : menuPath) {
                    this.menuElements[count++] = menu;
                    this.menuElements[count++] = menu.getPopupMenu();
                }
            }
            if (menuLeaf != null) {
                this.menuElements[count] = menuLeaf;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.menuElements != null) {
                String sep = "";
                for (MenuElement menuElem : this.menuElements) {
                    if (!(menuElem instanceof JMenuItem)) continue;
                    sb.append(sep);
                    sep = " -> ";
                    sb.append(((JMenuItem)menuElem).getText());
                }
            }
            return sb.toString();
        }

        public boolean isEnabled() {
            for (MenuElement menuElem : this.menuElements) {
                JMenuItem menuItem;
                if (!(menuElem instanceof JMenuItem) || (menuItem = (JMenuItem)menuElem).isEnabled()) continue;
                return false;
            }
            return true;
        }
    }

    private static class SearchResultListener
    implements ActionListener {
        private SearchResult searchResult;

        public SearchResultListener(SearchResult searchResult) {
            this.searchResult = searchResult;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MenuElement[] menuElements = this.searchResult.menuElements;
            MenuSelectionManager.defaultManager().setSelectedPath(menuElements);
        }
    }

    private class SearchPanel
    extends JPanel {
        private JToggleButton searchButton;
        private JTextField searchStringField;
        private Map<Integer, JButton> resultButtons;

        public SearchPanel() {
            this.setLayout(new SearchResultsLayout(this));
            int buttonDim = RadianceSizeUtils.getLookupButtonSize();
            this.searchButton = new JToggleButton();
            this.updateSearchIcon();
            this.searchButton.setPreferredSize(new Dimension(buttonDim, buttonDim));
            ResourceBundle bundle = RadianceThemingCortex.GlobalScope.getLabelBundle();
            this.searchButton.setToolTipText(bundle.getString("Tooltip.menuSearchButton"));
            this.searchButton.setFocusable(false);
            RadianceCoreUtilities.markButtonAsFlat(this.searchButton);
            this.add(this.searchButton);
            this.searchButton.addActionListener(actionEvent -> SwingUtilities.invokeLater(() -> {
                boolean toShow = this.searchButton.isSelected();
                this.searchStringField.setVisible(toShow);
                this.searchStringField.requestFocus();
                for (JButton resultButton : this.resultButtons.values()) {
                    resultButton.setVisible(toShow);
                }
                this.repaint();
                this.revalidate();
            }));
            this.searchButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if ((e.getModifiersEx() & 0x80) != 0) {
                        SwingUtilities.invokeLater(() -> {
                            SearchPanel.this.removeAll();
                            SearchPanel.this.repaint();
                            ((JMenuBar)MenuSearchWidget.this.jcomp).revalidate();
                        });
                    }
                }
            });
            this.searchStringField = new JTextField();
            this.searchStringField.setColumns(10);
            this.add(this.searchStringField);
            this.searchStringField.setVisible(false);
            this.searchStringField.setToolTipText(bundle.getString("Tooltip.menuSearchField"));
            this.resultButtons = new HashMap<Integer, JButton>();
            this.searchStringField.addActionListener(actionEvent -> {
                for (JButton toRemove : this.resultButtons.values()) {
                    this.remove(toRemove);
                }
                this.resultButtons.clear();
                String searchString = this.searchStringField.getText().toLowerCase();
                if (searchString.trim().length() == 0) {
                    this.repaint();
                    ((JMenuBar)MenuSearchWidget.this.jcomp).revalidate();
                    return;
                }
                LinkedList<SearchResult> searchResults = this.findOccurences(searchString);
                int count = 0;
                double scale = RadianceCommonCortex.getScaleFactor((Component)this);
                for (SearchResult searchResult : searchResults) {
                    if (count == 16) break;
                    JButton resultButton = new JButton();
                    int finalCount = count;
                    resultButton.setIcon(new TransitionAwareIcon(resultButton, () -> (TransitionAwareUI)((Object)resultButton.getUI()), scheme -> RadianceImageCreator.getHexaMarker(scale, finalCount, scheme), state -> state.isFacetActive(RadianceThemingSlices.ComponentStateFacet.ROLLOVER) ? RadianceThemingSlices.ColorSchemeAssociationKind.HIGHLIGHT : RadianceThemingSlices.ColorSchemeAssociationKind.MARK, "radiance.theming.internal.widget.menusearch." + (finalCount + 1)));
                    resultButton.addActionListener(new SearchResultListener(searchResult));
                    resultButton.setEnabled(searchResult.isEnabled());
                    this.add(resultButton);
                    this.resultButtons.put(count + 1, resultButton);
                    resultButton.setToolTipText("<html><body><b>" + searchResult.toString() + "</b><br>" + RadianceThemingCortex.GlobalScope.getLabelBundle().getString("Tooltip.menuSearchTooltip") + "</html>");
                    RadianceCoreUtilities.markButtonAsFlat(resultButton);
                    ++count;
                }
                this.repaint();
                ((JMenuBar)MenuSearchWidget.this.jcomp).revalidate();
            });
        }

        private LinkedList<SearchResult> findOccurences(String searchPattern) {
            LinkedList<SearchResult> result = new LinkedList<SearchResult>();
            LinkedList<JMenu> currentPath = new LinkedList<JMenu>();
            for (int i = 0; i < ((JMenuBar)MenuSearchWidget.this.jcomp).getComponentCount(); ++i) {
                Component component = ((JMenuBar)MenuSearchWidget.this.jcomp).getComponent(i);
                if (!(component instanceof JMenu)) continue;
                JMenu menu = (JMenu)component;
                this.checkMenu(currentPath, menu, searchPattern, result);
            }
            return result;
        }

        private void checkMenu(LinkedList<JMenu> currentPath, JMenuItem menuItem, String searchPattern, LinkedList<SearchResult> matchingResults) {
            String menuItemText = menuItem.getText();
            if (menuItemText.toLowerCase().contains(searchPattern)) {
                matchingResults.addLast(new SearchResult((JMenuBar)MenuSearchWidget.this.jcomp, currentPath, menuItem));
            }
            if (menuItem instanceof JMenu) {
                JMenu menu = (JMenu)menuItem;
                currentPath.addLast(menu);
                for (int i = 0; i < menu.getMenuComponentCount(); ++i) {
                    Component menuComponent = menu.getMenuComponent(i);
                    if (!(menuComponent instanceof JMenuItem)) continue;
                    JMenuItem childItem = (JMenuItem)menuComponent;
                    this.checkMenu(currentPath, childItem, searchPattern, matchingResults);
                }
                currentPath.removeLast();
            }
        }

        @Override
        public void setVisible(boolean aFlag) {
            super.setVisible(aFlag);
            if (aFlag) {
                this.searchStringField.requestFocus();
            }
        }

        private void updateSearchIcon() {
            int dimension = RadianceSizeUtils.getControlFontSize();
            this.searchButton.setIcon(new TransitionAwareIcon(this.searchButton, scheme -> RadianceThemingCortex.GlobalScope.getIconPack().getInspectIcon(dimension, scheme), "radiance.theming.internal.widget.menusearch"));
        }
    }
}

