/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.theming.internal.widget.text;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import org.pushingpixels.radiance.theming.api.RadianceThemingSlices;
import org.pushingpixels.radiance.theming.api.RadianceThemingWidget;
import org.pushingpixels.radiance.theming.api.colorscheme.RadianceColorScheme;
import org.pushingpixels.radiance.theming.api.password.PasswordStrengthChecker;
import org.pushingpixels.radiance.theming.internal.utils.RadianceColorSchemeUtilities;
import org.pushingpixels.radiance.theming.internal.utils.RadianceImageCreator;
import org.pushingpixels.radiance.theming.internal.utils.WidgetUtilities;
import org.pushingpixels.radiance.theming.internal.utils.border.BorderWrapper;

public class PasswordStrengthCheckerWidget
extends RadianceThemingWidget<JPasswordField> {
    private PropertyChangeListener strengthCheckerListener;

    @Override
    public void installListeners() {
        this.strengthCheckerListener = propertyChangeEvent -> {
            if ("radiance.theming.internal.widget.passwordStrengthChecker".equals(propertyChangeEvent.getPropertyName())) {
                Object newValue = propertyChangeEvent.getNewValue();
                Object oldValue = propertyChangeEvent.getOldValue();
                if (newValue instanceof PasswordStrengthChecker && !(oldValue instanceof PasswordStrengthChecker)) {
                    ((JPasswordField)this.jcomp).setBorder(new WrappedBorder(((JPasswordField)this.jcomp).getBorder(), new StrengthCheckedBorder()));
                } else {
                    Border coreBorder = UIManager.getBorder("PasswordField.border");
                    ((JPasswordField)this.jcomp).setBorder(coreBorder);
                    ((JPasswordField)this.jcomp).setToolTipText(null);
                }
            }
        };
        ((JPasswordField)this.jcomp).addPropertyChangeListener(this.strengthCheckerListener);
    }

    @Override
    public void uninstallListeners() {
        ((JPasswordField)this.jcomp).removePropertyChangeListener(this.strengthCheckerListener);
        this.strengthCheckerListener = null;
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        PasswordStrengthChecker checker = WidgetUtilities.getPasswordStrengthChecker((JPasswordField)this.jcomp);
        if (checker != null) {
            ((JPasswordField)this.jcomp).setBorder(new BorderUIResource.CompoundBorderUIResource(((JPasswordField)this.jcomp).getBorder(), new StrengthCheckedBorder()));
        }
    }

    private static class StrengthCheckedBorder
    implements Border {
        private static final int GUTTER_WIDTH = 5;

        private StrengthCheckedBorder() {
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            JPasswordField jpf = (JPasswordField)c;
            if (WidgetUtilities.getPasswordStrengthChecker(jpf) == null) {
                return new Insets(0, 0, 0, 0);
            }
            if (c.getComponentOrientation().isLeftToRight()) {
                return new Insets(0, 0, 0, 5);
            }
            return new Insets(0, 5, 0, 0);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            JPasswordField jpf = (JPasswordField)c;
            PasswordStrengthChecker passwordStrengthChecker = WidgetUtilities.getPasswordStrengthChecker(jpf);
            if (passwordStrengthChecker == null) {
                return;
            }
            RadianceThemingSlices.PasswordStrength strength = passwordStrengthChecker.getStrength(jpf.getPassword());
            if (c.getComponentOrientation().isLeftToRight()) {
                this.paintPasswordStrengthMarker(c, g, x + width - 5, y, 5, height, strength);
            } else {
                this.paintPasswordStrengthMarker(c, g, x, y, 5, height, strength);
            }
            String tooltip = passwordStrengthChecker.getDescription(strength);
            jpf.setToolTipText(tooltip);
        }

        private void paintPasswordStrengthMarker(Component c, Graphics g, int x, int y, int width, int height, RadianceThemingSlices.PasswordStrength pStrength) {
            Graphics2D g2 = (Graphics2D)g.create();
            RadianceColorScheme colorScheme = null;
            if (pStrength == RadianceThemingSlices.PasswordStrength.WEAK) {
                colorScheme = RadianceColorSchemeUtilities.ORANGE;
            }
            if (pStrength == RadianceThemingSlices.PasswordStrength.MEDIUM) {
                colorScheme = RadianceColorSchemeUtilities.YELLOW;
            }
            if (pStrength == RadianceThemingSlices.PasswordStrength.STRONG) {
                colorScheme = RadianceColorSchemeUtilities.GREEN;
            }
            if (colorScheme != null) {
                RadianceImageCreator.paintRectangularBackground(c, g, x, y, width, height, colorScheme, 0.5f, false);
            }
            g2.dispose();
        }
    }

    private static class WrappedBorder
    extends BorderUIResource.CompoundBorderUIResource
    implements BorderWrapper {
        public WrappedBorder(Border outsideBorder, Border insideBorder) {
            super(outsideBorder, insideBorder);
        }

        @Override
        public Border getOriginalBorder() {
            return this.getOutsideBorder();
        }
    }
}

