/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.informix;

import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpanderFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableIndexExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.SchemaExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.informix.exception.InformixExceptionFormatter;
import net.sourceforge.squirrel_sql.plugins.informix.exp.InformixSequenceInodeExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.informix.exp.InformixTableIndexExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.informix.exp.InformixTableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.informix.tab.IndexDetailsTab;
import net.sourceforge.squirrel_sql.plugins.informix.tab.ProcedureSourceTab;
import net.sourceforge.squirrel_sql.plugins.informix.tab.SequenceDetailsTab;
import net.sourceforge.squirrel_sql.plugins.informix.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.informix.tab.TriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.informix.tab.ViewSourceTab;

public class InformixPlugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(InformixPlugin.class);
    private static final ILogger s_log = LoggerController.createLogger(InformixPlugin.class);

    public String getInternalName() {
        return "informix";
    }

    public String getDescriptiveName() {
        return "Informix Plugin";
    }

    public String getVersion() {
        return "0.03";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "Doug Lawry";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        GUIUtils.processOnSwingEventThread(() -> this.updateTreeApi(session.getSessionInternalFrame().getObjectTreeAPI()));
        InformixExceptionFormatter formatter = new InformixExceptionFormatter(session);
        session.setExceptionFormatter((ExceptionFormatter)formatter);
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                InformixPlugin.this.updateTreeApi(objectTreeInternalFrame.getObjectTreeAPI());
            }

            public void objectTreeInSQLTabOpened(ObjectTreePanel objectTreePanel) {
                InformixPlugin.this.updateTreeApi((IObjectTreeAPI)objectTreePanel);
            }
        };
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isInformix((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void updateTreeApi(IObjectTreeAPI objectTreeAPI) {
        objectTreeAPI.addDetailTab(DatabaseObjectType.PROCEDURE, (IObjectTab)new ProcedureSourceTab(i18n.SHOW_PROCEDURE_SOURCE));
        objectTreeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(i18n.SHOW_VIEW_SOURCE));
        objectTreeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.INDEX, (IObjectTab)new IndexDetailsTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new DatabaseObjectInfoTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.SEQUENCE, (IObjectTab)new SequenceDetailsTab());
        objectTreeAPI.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new InformixSequenceInodeExpanderFactory(), DatabaseObjectType.SEQUENCE));
        TableWithChildNodesExpander tableExp = new TableWithChildNodesExpander();
        tableExp.setTableIndexExtractor((ITableIndexExtractor)new InformixTableIndexExtractorImpl());
        tableExp.setTableTriggerExtractor((ITableTriggerExtractor)new InformixTableTriggerExtractorImpl());
        objectTreeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)tableExp);
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        objectTreeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab("The source of the trigger"));
    }

    static interface i18n {
        public static final String SHOW_VIEW_SOURCE = s_stringMgr.getString("InformixPlugin.showViewSource");
        public static final String SHOW_PROCEDURE_SOURCE = s_stringMgr.getString("InformixPlugin.showProcedureSource");
    }
}

