/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.informix.tab;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourcePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BaseSourceTab;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfigFactory;
import net.sourceforge.squirrel_sql.client.util.codereformat.CommentSpec;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public abstract class InformixSourceTab
extends BaseSourceTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(InformixSourceTab.class);
    public static final int VIEW_TYPE = 0;
    public static final int STORED_PROC_TYPE = 1;
    public static final int TRIGGER_TYPE = 2;
    protected int sourceType = 0;
    private static final ILogger s_log = LoggerController.createLogger(InformixSourceTab.class);
    private static CommentSpec[] commentSpecs = new CommentSpec[]{new CommentSpec("/*", "*/"), new CommentSpec("--", "\n")};
    private static CodeReformator formatter = new CodeReformator(CodeReformatorConfigFactory.createConfig((String)";", (CommentSpec[])commentSpecs));

    public InformixSourceTab(String hint) {
        super(hint);
    }

    protected BaseSourcePanel createSourcePanel() {
        return new InformixSourcePanel(this.getSession());
    }

    private final class InformixSourcePanel
    extends BaseSourcePanel {
        InformixSourcePanel(ISession session) {
            super(session);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void load(ISession session, PreparedStatement stmt) {
            this.getTextArea().setText("");
            ResultSet rs = null;
            try {
                rs = stmt.executeQuery();
                StringBuffer buf = new StringBuffer(4096);
                int lastProcId = -1;
                while (rs.next()) {
                    if (InformixSourceTab.this.sourceType == 1) {
                        int tmpProcId = rs.getInt(1);
                        String tmpProcData = rs.getString(2);
                        if (lastProcId != tmpProcId) {
                            if (lastProcId != -1) {
                                buf.append("\n\n");
                            }
                            lastProcId = tmpProcId;
                        }
                        buf.append(tmpProcData);
                    }
                    if (InformixSourceTab.this.sourceType == 2) {
                        String data = rs.getString(1);
                        buf.append(data);
                    }
                    if (InformixSourceTab.this.sourceType != 0) continue;
                    String line = rs.getString(1);
                    buf.append(line);
                }
                String trimmedSource = buf.toString().trim();
                if (InformixSourceTab.this.sourceType == 0) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("View source before formatting: " + trimmedSource));
                    }
                    this.getTextArea().setText(formatter.reformat(trimmedSource));
                } else if (InformixSourceTab.this.sourceType == 2) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug((Object)("Trigger source before formatting: " + trimmedSource));
                    }
                    this.getTextArea().setText(formatter.reformat(trimmedSource));
                } else {
                    this.getTextArea().setText(trimmedSource);
                }
                this.getTextArea().setCaretPosition(0);
            }
            catch (SQLException ex) {
                session.showErrorMessage((Throwable)ex);
            }
            finally {
                SQLUtilities.closeResultSet((ResultSet)rs);
            }
        }
    }
}

