/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xbrz;

import net.sourceforge.xbrz.RotationDegree;

final class BlendInfo {
    byte val;

    BlendInfo() {
    }

    final BlendInfo reset(BlendInfo other, RotationDegree rotDeg) {
        byte b = other.val;
        switch (rotDeg) {
            default: {
                this.val = b;
                break;
            }
            case ROT_90: {
                this.val = (byte)(b << 2 & 0xFF | (b & 0xFF) >> 6);
                break;
            }
            case ROT_180: {
                this.val = (byte)(b << 4 & 0xFF | (b & 0xFF) >> 4);
                break;
            }
            case ROT_270: {
                this.val = (byte)(b << 6 & 0xFF | (b & 0xFF) >> 2);
            }
        }
        return this;
    }

    final boolean blendingNeeded() {
        return this.val != 0;
    }

    final byte getTopR() {
        return (byte)(3 & this.val >> 2);
    }

    final byte getBottomR() {
        return (byte)(3 & this.val >> 4);
    }

    final byte getBottomL() {
        return (byte)(3 & this.val >> 6);
    }

    final void clearAddTopL(byte bt) {
        this.val = bt;
    }

    final void addTopR(byte bt) {
        this.val = (byte)(this.val | bt << 2);
    }

    final void addBottomR(byte bt) {
        this.val = (byte)(this.val | bt << 4);
    }

    static void clearAddTopL(byte[] buf, int i, byte bt) {
        buf[i] = bt;
    }

    static void addTopR(byte[] buf, int i, byte bt) {
        int n = i;
        buf[n] = (byte)(buf[n] | bt << 2);
    }

    static void addBottomL(byte[] buf, int i, byte bt) {
        int n = i;
        buf[n] = (byte)(buf[n] | bt << 6);
    }
}

