/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xbrz;

import net.sourceforge.xbrz.Color;
import net.sourceforge.xbrz.ColorDistanceYCbCr;
import net.sourceforge.xbrz.ColorDistanceYCbCrBuffered;

public interface ColorDistance {
    public double calc(int var1, int var2);

    public static ColorDistance rgb() {
        return (pix1, pix2) -> {
            int r_diff = Color.getRed(pix1) - Color.getRed(pix2);
            int g_diff = Color.getGreen(pix1) - Color.getGreen(pix2);
            int b_diff = Color.getBlue(pix1) - Color.getBlue(pix2);
            return Math.sqrt(r_diff * r_diff + g_diff * g_diff + b_diff * b_diff);
        };
    }

    public static ColorDistance yCbCr(double lumaWeight) {
        return new ColorDistanceYCbCr(lumaWeight);
    }

    public static ColorDistance bufferedYCbCr(int sigBits) {
        return new ColorDistanceYCbCrBuffered(sigBits);
    }

    public static ColorDistance withAlpha(ColorDistance dist) {
        return (pix1, pix2) -> {
            int a1 = Color.getAlpha(pix1);
            int a2 = Color.getAlpha(pix2);
            double d = dist.calc(pix1, pix2);
            return a1 < a2 ? (double)a1 / 255.0 * d + (double)(a2 - a1) : (double)a2 / 255.0 * d + (double)(a1 - a2);
        };
    }
}

