/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xbrz;

import net.sourceforge.xbrz.Color;
import net.sourceforge.xbrz.ColorDistanceYCbCr;

class ColorDistanceYCbCrBuffered
extends ColorDistanceYCbCr {
    private static final int diffSize = 9;
    private final int sigBits;
    private final int adjBits;
    private final float[] diffToDist;

    public ColorDistanceYCbCrBuffered(int sigBits) {
        super(1.0);
        if (sigBits < 2 || sigBits > 8) {
            throw new IllegalArgumentException("Illegal sigBits: " + sigBits);
        }
        this.sigBits = sigBits;
        this.adjBits = 9 - sigBits;
        this.diffToDist = new float[1 << 3 * sigBits];
        int bitMask = (1 << sigBits) - 1;
        int len = this.diffToDist.length;
        for (int i = 0; i < len; ++i) {
            int r_diff = i >> (sigBits << 1) & bitMask;
            int g_diff = i >> sigBits & bitMask;
            int b_diff = i & bitMask;
            r_diff = (r_diff << this.adjBits) - 255 + (1 << this.adjBits - 1);
            g_diff = (g_diff << this.adjBits) - 255 + (1 << this.adjBits - 1);
            b_diff = (b_diff << this.adjBits) - 255 + (1 << this.adjBits - 1);
            double y = 0.2627 * (double)r_diff + 0.6779999999999999 * (double)g_diff + 0.0593 * (double)b_diff;
            double c_b = 0.5315190815350271 * ((double)b_diff - y);
            double c_r = 0.6781500067815001 * ((double)r_diff - y);
            this.diffToDist[i] = (float)Math.sqrt(ColorDistanceYCbCrBuffered.square(y) + ColorDistanceYCbCrBuffered.square(c_b) + ColorDistanceYCbCrBuffered.square(c_r));
        }
    }

    @Override
    public double calc(int pix1, int pix2) {
        int r_diff = Color.getRed(pix1) - Color.getRed(pix2) + 255;
        int g_diff = Color.getGreen(pix1) - Color.getGreen(pix2) + 255;
        int b_diff = Color.getBlue(pix1) - Color.getBlue(pix2) + 255;
        int index = r_diff >> this.adjBits << (this.sigBits << 1) | g_diff >> this.adjBits << this.sigBits | b_diff >> this.adjBits;
        return this.diffToDist[index];
    }
}

