/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xbrz;

import net.sourceforge.xbrz.RotationDegree;

final class MatrixRotation {
    static final int HALF_BYTE = 4;
    private final int N;
    private final int Nsq;
    private final byte[] lookup;

    private MatrixRotation(int N) {
        this.N = N;
        this.Nsq = N * N;
        if (N > 16) {
            throw new IllegalArgumentException("N should be <= 16");
        }
        byte[] lookup = new byte[4 * this.Nsq];
        for (int rotDeg = 0; rotDeg < 4; ++rotDeg) {
            int offset = rotDeg * this.Nsq;
            for (int I = 0; I < N; ++I) {
                for (int J = 0; J < N; ++J) {
                    lookup[offset + I * N + J] = this.calc(rotDeg, (byte)(I << 4 | J));
                }
            }
        }
        this.lookup = lookup;
    }

    static MatrixRotation of(int N) {
        return new MatrixRotation(N);
    }

    private final byte calc(int rotDeg, byte IJ) {
        if (rotDeg == 0) {
            return IJ;
        }
        byte IJ_old = this.calc(rotDeg - 1, IJ);
        int J_old = IJ_old & 0xF;
        int I_old = IJ_old >> 4 & 0xF;
        int rot_I = this.N - 1 - J_old;
        int rot_J = I_old;
        return (byte)(rot_I << 4 | rot_J);
    }

    final byte calc(RotationDegree rotDeg, int I, int J) {
        int offset = rotDeg.ordinal() * this.Nsq;
        return this.lookup[offset + I * this.N + J];
    }
}

