/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xbrz;

import net.sourceforge.xbrz.IntFunction;
import net.sourceforge.xbrz.MatrixRotation;
import net.sourceforge.xbrz.RotationDegree;

final class OutputMatrix {
    private final int N;
    private final int[] out;
    private final int outWidth;
    private int offset;
    private RotationDegree rotDeg = RotationDegree.ROT_0;
    private final MatrixRotation rot;

    OutputMatrix(int N, int[] out, int outWidth) {
        this.N = N;
        this.out = out;
        this.outWidth = outWidth;
        this.rot = MatrixRotation.of(N);
    }

    final void positionY(int y) {
        this.offset = this.N * y * this.outWidth;
    }

    final void incrementX() {
        this.offset += this.N;
    }

    final void rotDeg(RotationDegree deg) {
        this.rotDeg = deg;
    }

    private final int position(int I, int J) {
        byte IJ_old = this.rot.calc(this.rotDeg, I, J);
        int I_old = IJ_old >> 4 & 0xF;
        int J_old = IJ_old & 0xF;
        return this.offset + J_old + I_old * this.outWidth;
    }

    final void set(int I, int J, int val) {
        this.out[this.position((int)I, (int)J)] = val;
    }

    final void set(int I, int J, IntFunction func) {
        int pos = this.position(I, J);
        this.out[pos] = func.apply(this.out[pos]);
    }

    final void fillBlock(int col) {
        this.fillBlock(col, this.N, this.N);
    }

    final void fillBlock(int col, int blockWidth, int blockHeight) {
        int y = 0;
        int trg = y * this.outWidth + this.offset;
        while (y < blockHeight) {
            for (int x = 0; x < blockWidth; ++x) {
                this.out[trg + x] = col;
            }
            ++y;
            trg += this.outWidth;
        }
    }
}

