/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xbrz;

import net.sourceforge.xbrz.OutputMatrix;
import net.sourceforge.xbrz.Scaler2x;
import net.sourceforge.xbrz.Scaler3x;
import net.sourceforge.xbrz.Scaler4x;
import net.sourceforge.xbrz.Scaler5x;
import net.sourceforge.xbrz.Scaler6x;

interface Scaler {
    public int scale();

    public void blendLineShallow(int var1, OutputMatrix var2);

    public void blendLineSteep(int var1, OutputMatrix var2);

    public void blendLineSteepAndShallow(int var1, OutputMatrix var2);

    public void blendLineDiagonal(int var1, OutputMatrix var2);

    public void blendCorner(int var1, OutputMatrix var2);

    public static Scaler forFactor(int factor, boolean withAlpha) {
        switch (factor) {
            case 2: {
                return new Scaler2x(withAlpha);
            }
            case 3: {
                return new Scaler3x(withAlpha);
            }
            case 4: {
                return new Scaler4x(withAlpha);
            }
            case 5: {
                return new Scaler5x(withAlpha);
            }
            case 6: {
                return new Scaler6x(withAlpha);
            }
        }
        throw new IllegalArgumentException("Illegal scaling factor: " + factor);
    }
}

