/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xbrz;

import net.sourceforge.xbrz.BlendInfo;
import net.sourceforge.xbrz.BlendResult;
import net.sourceforge.xbrz.ColorDistance;
import net.sourceforge.xbrz.Kernel_3x3;
import net.sourceforge.xbrz.Kernel_4x4;
import net.sourceforge.xbrz.OutputMatrix;
import net.sourceforge.xbrz.RotationDegree;
import net.sourceforge.xbrz.Scaler;

public class Xbrz {
    private final Scaler scaler;
    private final ScalerCfg cfg;
    private final ColorDistance dist;
    private final boolean withAlpha;
    private final BlendInfo blendPixelInfo = new BlendInfo();

    public Xbrz(int factor) {
        this(factor, true);
    }

    public Xbrz(int factor, boolean withAlpha) {
        this(factor, withAlpha, new ScalerCfg());
    }

    public Xbrz(int factor, boolean withAlpha, ScalerCfg cfg) {
        this(factor, withAlpha, cfg, ColorDistance.yCbCr(cfg.luminanceWeight));
    }

    public Xbrz(int factor, boolean withAlpha, ScalerCfg cfg, ColorDistance colorDistance) {
        this.scaler = Scaler.forFactor(factor, withAlpha);
        this.cfg = cfg;
        this.dist = withAlpha ? ColorDistance.withAlpha(colorDistance) : colorDistance;
        this.withAlpha = withAlpha;
    }

    public int scale() {
        return this.scaler.scale();
    }

    private final double dist(int pix1, int pix2) {
        return this.dist.calc(pix1, pix2);
    }

    private final boolean eq(int pix1, int pix2) {
        return this.dist(pix1, pix2) < this.cfg.equalColorTolerance;
    }

    private void preProcessCorners(Kernel_4x4 ker, BlendResult result) {
        double fk;
        result.reset();
        if (ker.f == ker.g && ker.j == ker.k || ker.f == ker.j && ker.g == ker.k) {
            return;
        }
        double jg = this.dist(ker.i, ker.f) + this.dist(ker.f, ker.c) + this.dist(ker.n, ker.k) + this.dist(ker.k, ker.h) + this.cfg.centerDirectionBias * this.dist(ker.j, ker.g);
        if (jg < (fk = this.dist(ker.e, ker.j) + this.dist(ker.j, ker.o) + this.dist(ker.b, ker.g) + this.dist(ker.g, ker.l) + this.cfg.centerDirectionBias * this.dist(ker.f, ker.k))) {
            boolean dominantGradient;
            boolean bl = dominantGradient = this.cfg.dominantDirectionThreshold * jg < fk;
            if (ker.f != ker.g && ker.f != ker.j) {
                result.blend_f = (byte)(dominantGradient ? 2 : 1);
            }
            if (ker.k != ker.j && ker.k != ker.g) {
                result.blend_k = (byte)(dominantGradient ? 2 : 1);
            }
        } else if (fk < jg) {
            boolean dominantGradient;
            boolean bl = dominantGradient = this.cfg.dominantDirectionThreshold * fk < jg;
            if (ker.j != ker.f && ker.j != ker.k) {
                result.blend_j = (byte)(dominantGradient ? 2 : 1);
            }
            if (ker.g != ker.f && ker.g != ker.k) {
                result.blend_g = (byte)(dominantGradient ? 2 : 1);
            }
        }
    }

    private void blendPixel(RotationDegree rotDeg, Kernel_3x3 ker, OutputMatrix out, BlendInfo blendInfo) {
        BlendInfo blend = this.blendPixelInfo.reset(blendInfo, rotDeg);
        if (blend.getBottomR() >= 1) {
            int px;
            ker.rotDeg(rotDeg);
            out.rotDeg(rotDeg);
            int e = ker.e();
            int f = ker.f();
            int h = ker.h();
            int g = ker.g();
            int c = ker.c();
            int i = ker.i();
            boolean doLineBlend = blend.getBottomR() >= 2 ? true : (blend.getTopR() != 0 && !this.eq(e, g) ? false : (blend.getBottomL() != 0 && !this.eq(e, c) ? false : this.eq(e, i) || !this.eq(g, h) || !this.eq(h, i) || !this.eq(i, f) || !this.eq(f, c)));
            int n = px = this.dist(e, f) <= this.dist(e, h) ? f : h;
            if (doLineBlend) {
                boolean haveSteepLine;
                double hc;
                double fg = this.dist(f, g);
                boolean haveShallowLine = this.cfg.steepDirectionThreshold * fg <= (hc = this.dist(h, c)) && e != g && ker.d() != g;
                boolean bl = haveSteepLine = this.cfg.steepDirectionThreshold * hc <= fg && e != c && ker.b() != c;
                if (haveShallowLine) {
                    if (haveSteepLine) {
                        this.scaler.blendLineSteepAndShallow(px, out);
                    } else {
                        this.scaler.blendLineShallow(px, out);
                    }
                } else if (haveSteepLine) {
                    this.scaler.blendLineSteep(px, out);
                } else {
                    this.scaler.blendLineDiagonal(px, out);
                }
            } else {
                this.scaler.blendCorner(px, out);
            }
        }
    }

    public int[] scaleImage(int[] src, int[] trg, int srcWidth, int srcHeight) {
        int yFirst = 0;
        int yLast = srcHeight;
        if (trg == null) {
            trg = new int[srcWidth * this.scale() * srcHeight * this.scale()];
        }
        byte[] preProcBuf = new byte[srcWidth];
        Kernel_4x4 ker4 = new Kernel_4x4(src, srcWidth, srcHeight, this.withAlpha);
        OutputMatrix out = new OutputMatrix(this.scaler.scale(), trg, srcWidth * this.scaler.scale());
        BlendResult res = new BlendResult();
        ker4.positionY(yFirst - 1);
        this.preProcessCorners(ker4, res);
        BlendInfo.clearAddTopL(preProcBuf, 0, res.blend_k);
        for (int x = 0; x < srcWidth; ++x) {
            ker4.shift();
            ker4.readDhlp(x);
            this.preProcessCorners(ker4, res);
            BlendInfo.addTopR(preProcBuf, x, res.blend_j);
            if (x + 1 >= srcWidth) continue;
            BlendInfo.clearAddTopL(preProcBuf, x + 1, res.blend_k);
        }
        Kernel_3x3 ker3 = new Kernel_3x3(ker4);
        BlendInfo blend_xy = new BlendInfo();
        BlendInfo blend_xy1 = new BlendInfo();
        for (int y = yFirst; y < yLast; ++y) {
            out.positionY(y);
            ker4.positionY(y);
            this.preProcessCorners(ker4, res);
            blend_xy1.clearAddTopL(res.blend_k);
            BlendInfo.addBottomL(preProcBuf, 0, res.blend_g);
            for (int x = 0; x < srcWidth; ++x) {
                ker4.shift();
                ker4.readDhlp(x);
                blend_xy.val = preProcBuf[x];
                this.preProcessCorners(ker4, res);
                blend_xy.addBottomR(res.blend_f);
                blend_xy1.addTopR(res.blend_j);
                preProcBuf[x] = blend_xy1.val;
                if (x + 1 < srcWidth) {
                    blend_xy1.clearAddTopL(res.blend_k);
                    BlendInfo.addBottomL(preProcBuf, x + 1, res.blend_g);
                }
                out.fillBlock(ker4.f);
                if (blend_xy.blendingNeeded()) {
                    this.blendPixel(RotationDegree.ROT_0, ker3, out, blend_xy);
                    this.blendPixel(RotationDegree.ROT_90, ker3, out, blend_xy);
                    this.blendPixel(RotationDegree.ROT_180, ker3, out, blend_xy);
                    this.blendPixel(RotationDegree.ROT_270, ker3, out, blend_xy);
                }
                out.incrementX();
            }
        }
        return trg;
    }

    public static int[] scaleImage(int factor, boolean hasAlpha, int[] src, int[] trg, int srcWidth, int srcHeight) {
        return new Xbrz(factor, hasAlpha).scaleImage(src, trg, srcWidth, srcHeight);
    }

    public static final class ScalerCfg {
        public double luminanceWeight = 1.0;
        public double equalColorTolerance = 30.0;
        public double centerDirectionBias = 4.0;
        public double dominantDirectionThreshold = 3.6;
        public double steepDirectionThreshold = 2.2;
    }
}

