/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xbrz.tool;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sourceforge.xbrz.Xbrz;
import net.sourceforge.xbrz.tool.ImageData;

public final class AwtXbrz {
    private static Map<ScalerKey, Xbrz> scalers = new ConcurrentHashMap<ScalerKey, Xbrz>();

    private AwtXbrz() {
    }

    public static BufferedImage scaleImage(ImageData source, int factor) {
        ImageData target = new ImageData(source, factor);
        Xbrz xbrz = scalers.computeIfAbsent(ScalerKey.valueOf(factor, source.hasAlpha), key -> new Xbrz(key.scale, key.hasAlpha));
        xbrz.scaleImage(source.pixels, target.pixels, source.width, source.height);
        return AwtXbrz.makeImage(target.pixels, target.width, target.height, target.hasAlpha);
    }

    private static BufferedImage makeImage(int[] pixels, int width, int height, boolean hasAlpha) {
        DataBufferInt dataBuffer = new DataBufferInt(pixels, pixels.length);
        DirectColorModel colorModel = new DirectColorModel(hasAlpha ? 32 : 24, 0xFF0000, 65280, 255, hasAlpha ? -16777216 : 0);
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(width, height);
        WritableRaster raster = WritableRaster.createWritableRaster(sampleModel, dataBuffer, null);
        return new BufferedImage(colorModel, raster, false, null);
    }

    public static Image scaleImage(Image source, int factor) {
        ImageData imageData = ImageData.get(source);
        return imageData == null ? source : AwtXbrz.scaleImage(imageData, factor);
    }

    public static Image scaleImage(Image source, int targetWidth, int targetHeight) {
        int factor;
        ImageData imageData = ImageData.get(source);
        if (imageData == null) {
            return source;
        }
        int scaledWidth = imageData.width;
        int scaledHeight = imageData.height;
        for (factor = 1; (scaledWidth < targetWidth || scaledHeight < targetHeight) && factor <= 6; scaledWidth <<= 1, scaledHeight <<= 1, ++factor) {
        }
        return factor == 1 ? source : AwtXbrz.scaleImage(imageData, factor);
    }

    private static final class ScalerKey {
        final int scale;
        final boolean hasAlpha;
        private final int hash;

        private ScalerKey(int scale, boolean hasAlpha) {
            this.scale = scale;
            this.hasAlpha = hasAlpha;
            int prime = 31;
            int hashCode = 1;
            hashCode = 31 * hashCode + (hasAlpha ? 1231 : 1237);
            this.hash = hashCode = 31 * hashCode + scale;
        }

        static ScalerKey valueOf(int scale, boolean hasAlpha) {
            return new ScalerKey(scale, hasAlpha);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ScalerKey) {
                ScalerKey other = (ScalerKey)obj;
                return this.scale == other.scale && this.hasAlpha == other.hasAlpha;
            }
            return false;
        }
    }
}

