/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.xbrz.tool;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;

public final class ImageData {
    public final int width;
    public final int height;
    public final boolean hasAlpha;
    final int[] pixels;

    ImageData(BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.hasAlpha = image.getColorModel().hasAlpha();
        this.pixels = new int[this.width * this.height];
        image.getRGB(0, 0, this.width, this.height, this.pixels, 0, this.width);
    }

    ImageData(PixelGrabber image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.hasAlpha = image.getColorModel().hasAlpha();
        this.pixels = (int[])image.getPixels();
    }

    ImageData(ImageData source, int factor) {
        this.width = source.width * factor;
        this.height = source.height * factor;
        this.hasAlpha = source.hasAlpha;
        this.pixels = new int[this.width * this.height];
    }

    public static ImageData get(Image image) {
        if (image instanceof BufferedImage) {
            return new ImageData((BufferedImage)image);
        }
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            System.err.println("ImageData.get: " + e);
            return null;
        }
        if ((grabber.getStatus() & 0x80) != 0) {
            System.err.println("ImageData.get: fetch aborted or errored");
            return null;
        }
        if ((grabber.getStatus() & 0x10) != 0) {
            return null;
        }
        return new ImageData(grabber);
    }
}

