/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.greenplum.tab;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BasePreparedStatementTab;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class GreenplumExternalTableDetailsTab
extends BasePreparedStatementTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GreenplumExternalTableDetailsTab.class);
    private static ILogger s_log = LoggerController.createLogger(GreenplumExternalTableDetailsTab.class);
    private static final String SQL = "SELECT   nspace.nspname as schema,   class.relname as external_table_name,   auth.rolname as owner,   array_to_string(ARRAY(SELECT att.attname FROM pg_class class LEFT OUTER JOIN pg_attribute att ON (att.attrelid=class.oid) WHERE attstattarget = -1 and relname = ?), ', ') as column_names,   array_to_string(class.relacl, ', ') as permissions,   array_to_string(ext.location, ', ') as file_location,   ext.fmtopts as options,   ext.command as command,   ext.rejectlimit as reject_limit,   ext.rejectlimittype as reject_limit_type,   ext.fmterrtbl as error_table FROM pg_class class   LEFT OUTER JOIN pg_namespace nspace ON (nspace.oid=class.relnamespace)   LEFT OUTER JOIN pg_exttable ext ON (ext.reloid=class.oid)   LEFT OUTER JOIN pg_authid auth ON (auth.oid=class.relowner)   LEFT OUTER JOIN pg_attribute att ON (att.attrelid=class.oid) WHERE  (class.relkind = 'x' OR (class.relkind = 'r' AND class.relstorage = 'x'))   AND nspname = ?   AND class.relname = ? ";

    public GreenplumExternalTableDetailsTab() {
        super(i18n.TITLE, i18n.HINT, true);
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        PreparedStatement pstmt = session.getSQLConnection().prepareStatement(SQL);
        pstmt.setString(1, doi.getSimpleName());
        pstmt.setString(2, doi.getSchemaName());
        pstmt.setString(3, doi.getSimpleName());
        return pstmt;
    }

    private static interface i18n {
        public static final String TITLE = s_stringMgr.getString("ExternalTableDetailsTab.title");
        public static final String HINT = s_stringMgr.getString("ExternalTableDetailsTab.hint");
    }
}

