/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TEncodingFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSynchronousFilteredAudioInputStream;

public class LawEncoder
extends TEncodingFormatConversionProvider {
    static final int ALL = -1;
    static final AudioFormat[] LAW_FORMATS = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.ALAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.ALAW, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.ULAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.ULAW, -1.0f, 8, -1, -1, -1.0f, true)};
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.ULAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.ULAW, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.ALAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.ALAW, -1.0f, 8, -1, -1, -1.0f, true)};
    private static final AudioFormat[] OUTPUT_FORMATS = LAW_FORMATS;
    static final int UNSIGNED8 = 1;
    static final int SIGNED8 = 2;
    static final int BIG_ENDIAN16 = 3;
    static final int LITTLE_ENDIAN16 = 4;
    static final int ALAW8 = 5;
    static final int ULAW8 = 6;

    public LawEncoder() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        if (AudioFormats.matches(sourceFormat, targetFormat)) {
            return sourceStream;
        }
        if (LawEncoder.doMatch(targetFormat.getFrameRate(), sourceFormat.getFrameRate()) && LawEncoder.doMatch(targetFormat.getChannels(), sourceFormat.getChannels()) && LawEncoder.doMatch(targetFormat.getSampleSizeInBits(), 8)) {
            if (targetFormat.getEncoding().equals(AudioFormat.Encoding.ULAW)) {
                return new ToUlawStream(sourceStream);
            }
            if (targetFormat.getEncoding().equals(AudioFormat.Encoding.ALAW)) {
                return new ToAlawStream(sourceStream);
            }
        }
        throw new IllegalArgumentException("format conversion not supported");
    }

    static int getConvertType(AudioFormat af, int unAllowed) {
        int result = 0;
        AudioFormat.Encoding encoding = af.getEncoding();
        boolean bigEndian = af.isBigEndian();
        int ssib = af.getSampleSizeInBits();
        if (encoding.equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (ssib == 16) {
                result = bigEndian ? 3 : 4;
            } else if (ssib == 8) {
                result = 2;
            }
        } else if (encoding.equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            if (ssib == 8) {
                result = 1;
            }
        } else if (encoding.equals(AudioFormat.Encoding.ALAW)) {
            result = 5;
        } else if (encoding.equals(AudioFormat.Encoding.ULAW)) {
            result = 6;
        }
        if (result == unAllowed) {
            result = 0;
        }
        return result;
    }

    private static final AudioFormat createTargetFormat(AudioFormat src, AudioFormat.Encoding dst) {
        return new AudioFormat(dst, src.getSampleRate(), 8, src.getChannels(), src.getChannels(), src.getSampleRate(), false);
    }

    class ToAlawStream
    extends TSynchronousFilteredAudioInputStream {
        private int convertType;

        public ToAlawStream(AudioInputStream sourceStream) {
            super(sourceStream, LawEncoder.createTargetFormat(sourceStream.getFormat(), AudioFormat.Encoding.ALAW));
            this.convertType = LawEncoder.getConvertType(sourceStream.getFormat(), 5);
            if (this.convertType == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
            if (sourceStream.getFormat().getSampleSizeInBits() == 8) {
                this.enableConvertInPlace();
            }
        }

        protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
            int sampleCount = inFrameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.pcm82alaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.pcm82alaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 3: {
                    TConversionTool.pcm162alaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 4: {
                    TConversionTool.pcm162alaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 6: {
                    TConversionTool.ulaw2alaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                }
            }
            return inFrameCount;
        }

        protected void convertInPlace(byte[] buffer, int byteOffset, int frameCount) {
            int sampleCount = frameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.pcm82alaw(buffer, byteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.pcm82alaw(buffer, byteOffset, sampleCount, true);
                    break;
                }
                case 6: {
                    TConversionTool.ulaw2alaw(buffer, byteOffset, sampleCount);
                    break;
                }
                default: {
                    throw new RuntimeException("ToAlawStream: Call to convertInPlace, but it cannot convert in place.");
                }
            }
        }
    }

    class ToUlawStream
    extends TSynchronousFilteredAudioInputStream {
        private int convertType;

        public ToUlawStream(AudioInputStream sourceStream) {
            super(sourceStream, LawEncoder.createTargetFormat(sourceStream.getFormat(), AudioFormat.Encoding.ULAW));
            this.convertType = LawEncoder.getConvertType(sourceStream.getFormat(), 6);
            if (this.convertType == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
            if (sourceStream.getFormat().getSampleSizeInBits() == 8) {
                this.enableConvertInPlace();
            }
        }

        protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
            int sampleCount = inFrameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.pcm82ulaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.pcm82ulaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 3: {
                    TConversionTool.pcm162ulaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, true);
                    break;
                }
                case 4: {
                    TConversionTool.pcm162ulaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount, false);
                    break;
                }
                case 5: {
                    TConversionTool.alaw2ulaw(inBuffer, 0, outBuffer, outByteOffset, sampleCount);
                }
            }
            return inFrameCount;
        }

        protected void convertInPlace(byte[] buffer, int byteOffset, int frameCount) {
            int sampleCount = frameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.pcm82ulaw(buffer, byteOffset, sampleCount, false);
                    break;
                }
                case 2: {
                    TConversionTool.pcm82ulaw(buffer, byteOffset, sampleCount, true);
                    break;
                }
                case 5: {
                    TConversionTool.alaw2ulaw(buffer, byteOffset, sampleCount);
                    break;
                }
                default: {
                    throw new RuntimeException("ToUlawStream: Call to convertInPlace, but it cannot convert in place.");
                }
            }
        }
    }
}

