/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.netezza.tab;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.BasePreparedStatementTab;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SynonymDetailsTab
extends BasePreparedStatementTab {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SynonymDetailsTab.class);
    private static final ILogger s_log = LoggerController.createLogger(SynonymDetailsTab.class);
    private static final String SQL = "SELECT SYNONYM_NAME, refobjname as Referenced_Object, refdatabase as Referenced_Database , refdatabase || '.' || synonym_name as Qualified_Name FROM _v_synonym where synonym_name = ?";

    public SynonymDetailsTab() {
        super(i18n.TITLE, i18n.HINT, true);
    }

    protected PreparedStatement createStatement() throws SQLException {
        ISession session = this.getSession();
        IDatabaseObjectInfo doi = this.getDatabaseObjectInfo();
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"Synonym details SQL: SELECT SYNONYM_NAME, refobjname as Referenced_Object, refdatabase as Referenced_Database , refdatabase || '.' || synonym_name as Qualified_Name FROM _v_synonym where synonym_name = ?");
            s_log.debug((Object)("Synonym name: " + doi.getSimpleName()));
        }
        PreparedStatement pstmt = session.getSQLConnection().prepareStatement(SQL);
        pstmt.setString(1, doi.getSimpleName());
        return pstmt;
    }

    private static interface i18n {
        public static final String TITLE = s_stringMgr.getString("SynonymDetailsTab.title");
        public static final String HINT = s_stringMgr.getString("SynonymDetailsTab.hint");
    }
}

