/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.netezza.tokenizer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryHolder;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.QueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.TokenizerSessPropsInteractions;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class NetezzaQueryTokenizer
extends QueryTokenizer
implements IQueryTokenizer {
    private static final ILogger s_log = LoggerController.createLogger(NetezzaQueryTokenizer.class);
    private static final String PROCEDURE_PATTERN = "^\\s*CREATE\\s+PROCEDURE.*|^\\s*CREATE\\s+OR\\s+REPLACE\\s+PROCEDURE\\s+.*";
    private Pattern procPattern = Pattern.compile("^\\s*CREATE\\s+PROCEDURE.*|^\\s*CREATE\\s+OR\\s+REPLACE\\s+PROCEDURE\\s+.*", 32);
    private IQueryTokenizerPreferenceBean _prefs = null;

    public NetezzaQueryTokenizer(IQueryTokenizerPreferenceBean prefs) {
        super(prefs.getStatementSeparator(), prefs.getLineComment(), prefs.isRemoveMultiLineComments(), prefs.isRemoveLineComments());
        this._prefs = prefs;
    }

    public void setScriptToTokenize(String script) {
        super.setScriptToTokenize(script);
        this.breakApartNewLines();
        this.joinFragments(this.procPattern, false);
        this._queryIterator = this._queries.iterator();
    }

    protected void setFactory() {
        this._tokenizerFactory = () -> new NetezzaQueryTokenizer(this._prefs);
    }

    private void breakApartNewLines() {
        ArrayList<QueryHolder> tmp = new ArrayList<QueryHolder>();
        String procSep = this._prefs.getProcedureSeparator();
        Iterator iter = this._queries.iterator();
        while (iter.hasNext()) {
            String next = ((QueryHolder)iter.next()).getQuery();
            if (next.startsWith(procSep)) {
                tmp.add(new QueryHolder(procSep));
                String[] parts = next.split(procSep + "\\n+");
                for (int i = 0; i < parts.length; ++i) {
                    if ("".equals(parts[i]) || procSep.equals(parts[i])) continue;
                    tmp.add(new QueryHolder(parts[i]));
                }
                continue;
            }
            if (next.endsWith(procSep)) {
                String chopped = StringUtilities.chop((String)next);
                tmp.add(new QueryHolder(chopped));
                tmp.add(new QueryHolder(procSep));
                continue;
            }
            tmp.add(new QueryHolder(next));
        }
        this._queries = tmp;
    }

    private void joinFragments(Pattern pattern, boolean skipStraySep) {
        boolean inMultiSQLStatement = false;
        StringBuffer collector = null;
        ArrayList<QueryHolder> tmp = new ArrayList<QueryHolder>();
        String procSep = this._prefs.getProcedureSeparator();
        String stmtSep = this._prefs.getStatementSeparator();
        Iterator iter = this._queries.iterator();
        while (iter.hasNext()) {
            String next = ((QueryHolder)iter.next()).getQuery();
            if (pattern.matcher(next.toUpperCase()).matches()) {
                inMultiSQLStatement = true;
                collector = new StringBuffer(next);
                collector.append(stmtSep);
                continue;
            }
            if (next.startsWith(procSep)) {
                inMultiSQLStatement = false;
                if (collector != null) {
                    collector.append(procSep);
                    collector.append(stmtSep);
                    tmp.add(new QueryHolder(collector.toString()));
                    collector = null;
                    continue;
                }
                if (skipStraySep) {
                    if (!s_log.isDebugEnabled()) continue;
                    s_log.debug((Object)("Detected stray procedure separator(" + procSep + "). Skipping"));
                    continue;
                }
                tmp.add(new QueryHolder(next));
                continue;
            }
            if (inMultiSQLStatement) {
                collector.append(next);
                collector.append(stmtSep);
                continue;
            }
            tmp.add(new QueryHolder(next));
        }
        this._queries = tmp;
    }

    public TokenizerSessPropsInteractions getTokenizerSessPropsInteractions() {
        if (this._prefs.isInstallCustomQueryTokenizer()) {
            TokenizerSessPropsInteractions ret = new TokenizerSessPropsInteractions();
            ret.setTokenizerDefinesRemoveMultiLineComment(true);
            ret.setTokenizerDefinesRemoveLineComment(true);
            ret.setTokenizerDefinesStartOfLineComment(true);
            ret.setTokenizerDefinesStatementSeparator(true);
            return ret;
        }
        return super.getTokenizerSessPropsInteractions();
    }
}

