/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.multisource;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.db.encryption.AliasPasswordHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.plugins.multisource.MultiSourcePlugin;

public class MultiAliasChooser
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MultiAliasChooser.class);
    private ExtractStatusWrapper _statusWrapper;
    private JComboBox _aliasCbx;
    private JTextField _nameTxt;
    private JTextField _schemaTxt;
    private ArrayList<SQLAlias> _aliasList;
    private SQLAlias _selectedAlias;
    private SQLAlias _lastAdded;
    private String _sourceName;
    private IApplication _app;
    private ISession _session;
    private JTextField _tablesIncTxt;
    private JTextField _tablesExcTxt;
    private JTextField _catalogIncTxt;
    private Color _progressColor;
    private boolean _extractInProgress = false;
    private Timer _timer;
    private JLabel _nameLbl;
    private JLabel _catelogLbl;
    private JLabel _schemaLbl;
    private JLabel _tablesIncLbl;
    private JLabel _tablesExcLbl;
    private JLabel _messagesLbl;
    private JLabel _progressLbl;
    private JPanel _progressPanel;
    private JProgressBar _progressBar;
    private JPanel _progressMessagePanel;
    private JLabel _countLbl;
    private JLabel _lastMessageLbl;
    private JLabel _messageLbl;
    private JComboBox _statsCbx;
    private JTextArea txtMessages;
    private JButton btnExit;
    private JButton btnAdd;
    private boolean extractInProgress = false;
    private static int fieldSize = 55;

    public MultiAliasChooser(IApplication app, ISession session, ArrayList<SQLAlias> aliasList) {
        super((Frame)null, s_stringMgr.getString("MultiAliasChooser.title"), true);
        this.setSize(600, 461);
        this._aliasList = aliasList;
        this._app = app;
        this._session = session;
        this.createUserInterface();
    }

    public SQLAlias showDialog() {
        this.setVisible(true);
        return this._lastAdded;
    }

    private void createUserInterface() {
        FlowLayout flowLayout2 = new FlowLayout();
        flowLayout2.setAlignment(0);
        GridLayout gridLayout = new GridLayout(7, 1);
        gridLayout.setHgap(5);
        Font labelFont = new Font("DialogInput", 1, 12);
        Font textFont = new Font("SansSerif", 0, 11);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(2, 0, 1, 0);
        gridBagConstraints2.gridy = 3;
        gridBagConstraints2.ipadx = 700;
        gridBagConstraints2.ipady = 250;
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.gridx = 0;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.insets = new Insets(2, 0, 5, 0);
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 10;
        gridBagConstraints1.ipady = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.gridx = 0;
        JPanel mainPanel = new JPanel();
        GridBagLayout gbl_mainPanel = new GridBagLayout();
        gbl_mainPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0};
        gbl_mainPanel.columnWeights = new double[]{1.0};
        gbl_mainPanel.rowHeights = new int[]{0, 0, 48, 0};
        mainPanel.setLayout(gbl_mainPanel);
        JPanel addPanel = new JPanel();
        addPanel.setBorder(BorderFactory.createEtchedBorder(0));
        addPanel.setLayout(new BoxLayout(addPanel, 0));
        JPanel rightAddPanel = new JPanel();
        JPanel tmp = new JPanel();
        tmp.setLayout(null);
        this._nameLbl = new JLabel(s_stringMgr.getString("MultiAliasChooser.name"));
        this._nameLbl.setBounds(12, 6, 100, 17);
        this._nameLbl.setFont(labelFont);
        tmp.add(this._nameLbl);
        rightAddPanel.setLayout(gridLayout);
        this._nameTxt = new JTextField(fieldSize);
        this._nameTxt.setBounds(130, 5, 444, 19);
        this._nameTxt.setFont(textFont);
        tmp.add(this._nameTxt);
        rightAddPanel.add(tmp);
        tmp = new JPanel();
        tmp.setLayout(null);
        this._catelogLbl = new JLabel(s_stringMgr.getString("MultiAliasChooser.catalog"));
        this._catelogLbl.setBounds(12, 6, 84, 17);
        this._catelogLbl.setFont(labelFont);
        tmp.add(this._catelogLbl);
        this._catalogIncTxt = new JTextField(fieldSize);
        this._catalogIncTxt.setBounds(130, 5, 444, 19);
        this._catalogIncTxt.setFont(textFont);
        tmp.add(this._catalogIncTxt);
        rightAddPanel.add(tmp);
        tmp = new JPanel();
        tmp.setLayout(null);
        this._schemaLbl = new JLabel(s_stringMgr.getString("MultiAliasChooser.schema"));
        this._schemaLbl.setBounds(12, 6, 84, 17);
        this._schemaLbl.setFont(labelFont);
        tmp.add(this._schemaLbl);
        this._schemaTxt = new JTextField(fieldSize);
        this._schemaTxt.setBounds(130, 5, 444, 19);
        this._schemaTxt.setFont(textFont);
        tmp.add(this._schemaTxt);
        rightAddPanel.add(tmp);
        tmp = new JPanel();
        tmp.setLayout(null);
        this._tablesIncLbl = new JLabel(s_stringMgr.getString("MultiAliasChooser.tableInclude"));
        this._tablesIncLbl.setBounds(12, 6, 125, 17);
        this._tablesIncLbl.setFont(labelFont);
        tmp.add(this._tablesIncLbl);
        this._tablesIncTxt = new JTextField(fieldSize);
        this._tablesIncTxt.setBounds(130, 5, 444, 19);
        this._tablesIncTxt.setFont(textFont);
        this._tablesIncTxt.setText("%");
        tmp.add(this._tablesIncTxt);
        rightAddPanel.add(tmp);
        tmp = new JPanel();
        tmp.setLayout(null);
        this._tablesExcLbl = new JLabel(s_stringMgr.getString("MultiAliasChooser.tableExclude"));
        this._tablesExcLbl.setBounds(12, 6, 125, 17);
        this._tablesExcLbl.setFont(labelFont);
        tmp.add(this._tablesExcLbl);
        this._tablesExcTxt = new JTextField(fieldSize);
        this._tablesExcTxt.setBounds(130, 5, 444, 19);
        this._tablesExcTxt.setFont(textFont);
        this._tablesExcTxt.setText(".*\\$.*");
        tmp.add(this._tablesExcTxt);
        rightAddPanel.add(tmp);
        tmp = new JPanel();
        tmp.setLayout(null);
        JLabel tlbl = new JLabel(s_stringMgr.getString("MultiAliasChooser.stats"));
        tlbl.setBounds(12, 6, 125, 17);
        tlbl.setFont(labelFont);
        tmp.add(tlbl);
        this._statsCbx = new JComboBox();
        this._statsCbx.setLocation(130, 3);
        this._statsCbx.setSize(100, 19);
        this._statsCbx.setModel(new DefaultComboBoxModel<String>(new String[]{"None", "Row Counts", "All"}));
        this._statsCbx.setSelectedIndex(1);
        tmp.add(this._statsCbx);
        rightAddPanel.add(tmp);
        addPanel.add(rightAddPanel);
        JPanel messagePanel = new JPanel();
        messagePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        messagePanel.setLayout(new BoxLayout(messagePanel, 1));
        this.txtMessages = new JTextArea(60, 10);
        this.txtMessages.setText("");
        JScrollPane scrollPane = new JScrollPane(this.txtMessages);
        scrollPane.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        messagePanel.add(scrollPane);
        this._messagesLbl = new JLabel(s_stringMgr.getString("MultiAliasChooser.messages"));
        scrollPane.setColumnHeaderView(this._messagesLbl);
        GridBagConstraints gridBagConstraints21 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 15, 2, new Insets(0, 0, 5, 0), 185, 79);
        gridBagConstraints21.ipady = 0;
        gridBagConstraints21.gridwidth = 1;
        gridBagConstraints21.anchor = 11;
        JPanel sourcePanel = new JPanel();
        sourcePanel.setLayout(new BorderLayout(3, 3));
        sourcePanel.setBorder(BorderFactory.createEtchedBorder(0));
        this._aliasCbx = new JComboBox<Object>(this._aliasList.toArray());
        this._aliasCbx.setMaximumRowCount(5);
        this._aliasCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MultiAliasChooser.this._sourceName = StringUtilities.javaNormalize((String)((SQLAlias)MultiAliasChooser.this._aliasCbx.getSelectedItem()).getName());
                MultiAliasChooser.this._nameTxt.setText(MultiAliasChooser.this._sourceName);
            }
        });
        this._sourceName = StringUtilities.javaNormalize((String)((SQLAlias)this._aliasCbx.getSelectedItem()).getName());
        this._nameTxt.setText(this._sourceName);
        JPanel sourcePanelLower = new JPanel(new BorderLayout(5, 5));
        sourcePanel.add(sourcePanelLower);
        sourcePanel.add((Component)new JLabel(s_stringMgr.getString("MultiAliasChooser.prompt")), "North");
        sourcePanelLower.add((Component)this._aliasCbx, "Center");
        this.btnExit = new JButton(s_stringMgr.getString("MultiAliasChooser.cancel"));
        this.btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultiAliasChooser.this.dispose();
            }
        });
        sourcePanelLower.add((Component)this.btnExit, "East");
        mainPanel.add((Component)sourcePanel, gridBagConstraints21);
        mainPanel.add((Component)addPanel, gridBagConstraints1);
        this._progressPanel = new JPanel();
        GridBagConstraints gbc__progressPanel = new GridBagConstraints();
        gbc__progressPanel.insets = new Insets(0, 0, 5, 0);
        gbc__progressPanel.fill = 1;
        gbc__progressPanel.gridx = 0;
        gbc__progressPanel.gridy = 2;
        mainPanel.add((Component)this._progressPanel, gbc__progressPanel);
        this._progressPanel.setLayout(new GridLayout(2, 1, 0, 0));
        this._progressMessagePanel = new JPanel();
        this._progressPanel.add(this._progressMessagePanel);
        GridBagLayout gbl__progressMessagePanel = new GridBagLayout();
        gbl__progressMessagePanel.columnWidths = new int[]{10, 42, 1, 50, 0};
        gbl__progressMessagePanel.rowHeights = new int[]{20, 0};
        gbl__progressMessagePanel.columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gbl__progressMessagePanel.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        this._progressMessagePanel.setLayout(gbl__progressMessagePanel);
        this._progressLbl = new JLabel(s_stringMgr.getString("MultiAliasChooser.progress"));
        this._progressLbl.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints gbc__progressLbl = new GridBagConstraints();
        gbc__progressLbl.anchor = 17;
        gbc__progressLbl.insets = new Insets(0, 0, 0, 5);
        gbc__progressLbl.gridx = 0;
        gbc__progressLbl.gridy = 0;
        this._progressMessagePanel.add((Component)this._progressLbl, gbc__progressLbl);
        this._countLbl = new JLabel("");
        GridBagConstraints gbc__countLbl = new GridBagConstraints();
        gbc__countLbl.anchor = 18;
        gbc__countLbl.insets = new Insets(0, 0, 0, 5);
        gbc__countLbl.gridx = 1;
        gbc__countLbl.gridy = 0;
        this._progressMessagePanel.add((Component)this._countLbl, gbc__countLbl);
        this._lastMessageLbl = new JLabel(" ");
        this._lastMessageLbl.setFont(new Font("Tahoma", 1, 12));
        GridBagConstraints gbc__lastMessageLbl = new GridBagConstraints();
        gbc__lastMessageLbl.anchor = 18;
        gbc__lastMessageLbl.insets = new Insets(0, 0, 0, 5);
        gbc__lastMessageLbl.gridx = 2;
        gbc__lastMessageLbl.gridy = 0;
        this._progressMessagePanel.add((Component)this._lastMessageLbl, gbc__lastMessageLbl);
        this._messageLbl = new JLabel("");
        this._messageLbl.setHorizontalAlignment(2);
        GridBagConstraints gbc__messageLbl = new GridBagConstraints();
        gbc__messageLbl.anchor = 18;
        gbc__messageLbl.gridx = 3;
        gbc__messageLbl.gridy = 0;
        this._progressMessagePanel.add((Component)this._messageLbl, gbc__messageLbl);
        this._progressBar = new JProgressBar();
        this._progressBar.setForeground(Color.GREEN);
        this._progressPanel.add(this._progressBar);
        mainPanel.add((Component)messagePanel, gridBagConstraints2);
        addPanel.setFont(new Font("Dialog", 2, 12));
        rightAddPanel.setFont(new Font("Dialog", 2, 12));
        this.btnAdd = new JButton(s_stringMgr.getString("MultiAliasChooser.ok"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (MultiAliasChooser.this._nameTxt.getText().length() == 0) {
                    return;
                }
                MultiAliasChooser.this.executeAddSource();
            }
        });
        rightAddPanel.add(this.btnAdd);
        this.setContentPane(mainPanel);
        GUIUtils.centerWithinParent((Window)this);
    }

    private boolean executeAddSource() {
        SQLAlias alias;
        this._selectedAlias = alias = (SQLAlias)this._aliasCbx.getSelectedItem();
        this._sourceName = this._nameTxt.getText();
        if (this._sourceName.contains(" ")) {
            Dialogs.showOk((Component)this._nameTxt.getParent().getParent(), (String)"Source name cannot contain spaces.");
            return false;
        }
        String schemaName = this._schemaTxt.getText();
        if (schemaName.trim().equals("")) {
            schemaName = null;
        }
        try {
            Object schema = MultiSourcePlugin.getSchema(this._session.getSQLConnection().getConnection());
            Method getDBMethod = schema.getClass().getMethod("getDB", String.class);
            Object result = getDBMethod.invoke(schema, this._sourceName);
            if (result != null) {
                Dialogs.showOk((Component)this._nameTxt.getParent().getParent(), (String)"Source name already exists in virtualization.  Select a different name.");
                return false;
            }
            ExtractSourceThread th = new ExtractSourceThread("");
            th.start();
        }
        catch (Exception e) {
            Dialogs.showOk((Component)this._nameTxt.getParent().getParent(), (String)("Error during extraction: " + e));
            return false;
        }
        this._lastAdded = this._selectedAlias;
        return true;
    }

    private class ExtractSourceThread
    extends Thread {
        private String password;

        public ExtractSourceThread(String password) {
            this.password = password;
        }

        @Override
        public void run() {
            block14: {
                if (MultiAliasChooser.this.extractInProgress) {
                    return;
                }
                if (MultiAliasChooser.this._progressColor != null) {
                    MultiAliasChooser.this._progressBar.setStringPainted(true);
                    MultiAliasChooser.this._progressBar.setForeground(MultiAliasChooser.this._progressColor);
                    MultiAliasChooser.this._progressBar.setString("");
                }
                MultiAliasChooser.this.extractInProgress = true;
                MultiAliasChooser.this.setCursor(Cursor.getPredefinedCursor(3));
                MultiAliasChooser.this._progressBar.setForeground(Color.GREEN);
                SQLAlias alias = (SQLAlias)MultiAliasChooser.this._aliasCbx.getSelectedItem();
                IIdentifier driverID = alias.getDriverIdentifier();
                ISQLDriver driver = MultiAliasChooser.this._app.getAliasesAndDriversManager().getDriver(driverID);
                String driverName = driver.getDriverClassName();
                String url = alias.getUrl();
                String userName = alias.getUserName();
                this.password = AliasPasswordHandler.getPassword((SQLAlias)alias);
                String dbName = MultiAliasChooser.this._nameTxt.getText();
                String schemaName = MultiAliasChooser.this._schemaTxt.getText();
                String tableInc = MultiAliasChooser.this._tablesIncTxt.getText();
                String tableExc = MultiAliasChooser.this._tablesExcTxt.getText();
                String catalogInc = MultiAliasChooser.this._catalogIncTxt.getText();
                if (catalogInc.trim().equals("")) {
                    catalogInc = null;
                }
                int statsType = MultiAliasChooser.this._statsCbx.getSelectedIndex();
                if (dbName.equals("")) {
                    dbName = null;
                }
                if (schemaName.equals("")) {
                    schemaName = null;
                }
                try {
                    MultiAliasChooser.this._statusWrapper = new ExtractStatusWrapper();
                    MultiAliasChooser.this._timer = new Timer(100, new RefreshAction());
                    MultiAliasChooser.this._timer.start();
                    ClassLoader loader = MultiAliasChooser.this._session.getSQLConnection().getConnection().getClass().getClassLoader();
                    Class<?> extractStatusClass = Class.forName("com.unityjdbc.sourcebuilder.ExtractStatus", true, loader);
                    Class<?> extractThreadClass = Class.forName("com.unityjdbc.sourcebuilder.ExtractThread", true, loader);
                    Constructor<?>[] allConstructors = extractThreadClass.getDeclaredConstructors();
                    Constructor<?> threadConstructor = null;
                    for (Constructor<?> ctor : allConstructors) {
                        Class<?>[] pType = ctor.getParameterTypes();
                        if (pType.length <= 0 || !pType[0].equals(extractStatusClass)) continue;
                        threadConstructor = ctor;
                        break;
                    }
                    Object extractThread = null;
                    if (threadConstructor == null) break block14;
                    Method meth = extractThreadClass.getMethod("start", new Class[0]);
                    extractThread = threadConstructor.newInstance(MultiAliasChooser.this._statusWrapper.getStatus(), driverName, url, userName, this.password, dbName, schemaName, tableInc, tableExc, catalogInc, statsType);
                    meth.invoke(extractThread, new Object[0]);
                    while (!MultiAliasChooser.this._statusWrapper.isComplete()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!MultiAliasChooser.this._statusWrapper.hasError()) {
                        Method getDatabase = extractThreadClass.getMethod("getDatabase", new Class[0]);
                        Object asd = getDatabase.invoke(extractThread, new Object[0]);
                        Object schema = MultiSourcePlugin.getSchema(MultiAliasChooser.this._session.getSQLConnection().getConnection());
                        Method addSourceMethod = schema.getClass().getMethod("addDatabase", asd.getClass());
                        addSourceMethod.invoke(schema, asd);
                        try {
                            MultiSourcePlugin.updateSession(MultiAliasChooser.this._session);
                        }
                        catch (RuntimeException e) {
                            MultiAliasChooser.this._progressColor = MultiAliasChooser.this._progressBar.getForeground();
                            MultiAliasChooser.this._progressBar.setStringPainted(true);
                            MultiAliasChooser.this._progressBar.setForeground(Color.red);
                            MultiAliasChooser.this._progressBar.setString("");
                            MultiAliasChooser.this._messageLbl.setText(s_stringMgr.getString("MultiAliasChooser.saveFailed"));
                        }
                        MultiSourcePlugin.refreshTree(MultiAliasChooser.this._session);
                    }
                    MultiAliasChooser.this.extractInProgress = false;
                    MultiAliasChooser.this.setCursor(null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class RefreshAction
    implements ActionListener {
        private int lastMessageOutput = 0;

        private RefreshAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            try {
                MultiAliasChooser.this._progressBar.setMaximum(MultiAliasChooser.this._statusWrapper.getTotalTables());
                MultiAliasChooser.this._progressBar.setValue(MultiAliasChooser.this._statusWrapper.getProcessedTables());
                MultiAliasChooser.this._countLbl.setText(MultiAliasChooser.this._statusWrapper.getProcessedTables() + " of " + MultiAliasChooser.this._statusWrapper.getTotalTables());
                int maxLabelSize = 110;
                ArrayList<String> messages = MultiAliasChooser.this._statusWrapper.getMessages();
                if (messages != null && messages.size() > 0) {
                    String st = MultiAliasChooser.this._statusWrapper.getLastMessage();
                    MultiAliasChooser.this._messageLbl.setText(st.substring(0, Math.min(maxLabelSize, st.length())));
                }
                while (this.lastMessageOutput < messages.size()) {
                    MultiAliasChooser.this.txtMessages.append(messages.get(this.lastMessageOutput) + "\n");
                    ++this.lastMessageOutput;
                }
                String error = MultiAliasChooser.this._statusWrapper.getError();
                if (error != null) {
                    MultiAliasChooser.this._messageLbl.setText(error.substring(0, Math.min(maxLabelSize, error.length())));
                    MultiAliasChooser.this._progressBar.setForeground(Color.RED);
                }
                if (MultiAliasChooser.this._statusWrapper.isComplete()) {
                    MultiAliasChooser.this._timer.stop();
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class ExtractStatusWrapper {
        private Object extractStatus;
        private Class<?> extractStatusClass;

        public ExtractStatusWrapper() throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
            ClassLoader loader = MultiAliasChooser.this._session.getSQLConnection().getConnection().getClass().getClassLoader();
            this.extractStatusClass = Class.forName("com.unityjdbc.sourcebuilder.ExtractStatus", true, loader);
            this.extractStatus = this.extractStatusClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }

        public Object getStatus() {
            return this.extractStatus;
        }

        public boolean isComplete() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Method meth = this.extractStatusClass.getMethod("isComplete", new Class[0]);
            return (Boolean)meth.invoke(this.extractStatus, new Object[0]);
        }

        public boolean hasError() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Method meth = this.extractStatusClass.getMethod("hasError", new Class[0]);
            return (Boolean)meth.invoke(this.extractStatus, new Object[0]);
        }

        public int getTotalTables() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Method meth = this.extractStatusClass.getMethod("getTotalTables", new Class[0]);
            return (Integer)meth.invoke(this.extractStatus, new Object[0]);
        }

        public int getProcessedTables() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Method meth = this.extractStatusClass.getMethod("getProcessedTables", new Class[0]);
            return (Integer)meth.invoke(this.extractStatus, new Object[0]);
        }

        public ArrayList<String> getMessages() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Method meth = this.extractStatusClass.getMethod("getMessages", new Class[0]);
            return (ArrayList)meth.invoke(this.extractStatus, new Object[0]);
        }

        public String getLastMessage() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Method meth = this.extractStatusClass.getMethod("getLastMessage", new Class[0]);
            return (String)meth.invoke(this.extractStatus, new Object[0]);
        }

        public String getError() throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Method meth = this.extractStatusClass.getMethod("getError", new Class[0]);
            return (String)meth.invoke(this.extractStatus, new Object[0]);
        }
    }
}

