/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.multisource;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.resources.IResources;
import net.sourceforge.squirrel_sql.fw.resources.Resources;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.plugins.multisource.MultiSourcePlugin;

public class MultiRemoveSourceAction
extends SquirrelAction {
    private ISession _session;

    public MultiRemoveSourceAction(IApplication app, Resources rsrc, ISession session) {
        super(app, (IResources)rsrc);
        this._session = session;
    }

    public void actionPerformed(ActionEvent evt) {
        try {
            SessionInternalFrame sessMainFrm = this._session.getSessionInternalFrame();
            IObjectTreeAPI otree = sessMainFrm.getObjectTreeAPI();
            IDatabaseObjectInfo[] dbObjs = otree.getSelectedDatabaseObjects();
            if (dbObjs.length > 0) {
                DatabaseObjectInfo di = (DatabaseObjectInfo)dbObjs[0];
                String sourceName = di.getSimpleName();
                Connection con = this._session.getSQLConnection().getConnection();
                Object gs = MultiSourcePlugin.getSchema(con);
                this.removeSource(sourceName, gs);
                otree.removeNodes(otree.getSelectedNodes());
                MultiSourcePlugin.updateSession(this._session);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void removeSource(String sourceName, Object gs) {
        Class<?> cls = gs.getClass();
        try {
            Method meth = cls.getMethod("removeDatabase", String.class);
            meth.invoke(gs, sourceName);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

