/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.derby;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.sql.Driver;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginQueryTokenizerPreferencesManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginGlobalPreferencesTab;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginQueryTokenizerPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreePanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.sqltab.AdditionalSQLTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.sql.querytokenizer.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.derby.exp.DerbyTableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.derby.prefs.DerbyPluginPreferencesPanel;
import net.sourceforge.squirrel_sql.plugins.derby.prefs.DerbyPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.derby.tab.ProcedureSourceTab;
import net.sourceforge.squirrel_sql.plugins.derby.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.derby.tab.TriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.derby.tab.ViewSourceTab;
import net.sourceforge.squirrel_sql.plugins.derby.tokenizer.DerbyQueryTokenizer;
import net.sourceforge.squirrel_sql.plugins.derby.types.DerbyClobDataTypeComponentFactory;

public class DerbyPlugin
extends DefaultSessionPlugin {
    private static final String UNKNOWN_DBNAME = "<unknown>";
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DerbyPlugin.class);
    private static final ILogger s_log = LoggerController.createLogger(DerbyPlugin.class);
    private IObjectTreeAPI _treeAPI;
    private PluginQueryTokenizerPreferencesManager _prefsManager = null;
    private Map<String, List<WeakReference<ISession>>> _embeddedSessions = new HashMap<String, List<WeakReference<ISession>>>();
    private volatile ISQLDriver _embeddedDriver;
    private volatile boolean _appShuttingDown;

    public String getInternalName() {
        return "derby";
    }

    public String getDescriptiveName() {
        return "Derby Plugin";
    }

    public String getVersion() {
        return "0.13";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "Alex Pivovarov";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void load(IApplication app) throws PluginException {
        super.load(app);
        app.addApplicationListener(() -> {
            this._appShuttingDown = true;
        });
        String derbySystemHome = System.getProperty("derby.system.home", "");
        if (derbySystemHome.isEmpty()) {
            try {
                derbySystemHome = this.getPluginUserSettingsFolder().getAbsolutePath();
                System.setProperty("derby.system.home", derbySystemHome);
                s_log.info((Object)("derby.system.home set to: " + derbySystemHome));
            }
            catch (IOException e) {
                s_log.warn((Object)"Could not initialize derby.system.home", (Throwable)e);
            }
        }
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        DerbyPluginPreferencesPanel _prefsPanel = new DerbyPluginPreferencesPanel(this._prefsManager);
        PluginGlobalPreferencesTab tab = new PluginGlobalPreferencesTab((PluginQueryTokenizerPreferencesPanel)_prefsPanel);
        tab.setHint(i18n.PREFS_HINT);
        tab.setTitle(i18n.PREFS_TITLE);
        return new IGlobalPreferencesPanel[]{tab};
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        this._app.getSessionManager().addSessionListener((ISessionListener)new SessionListener());
        this._prefsManager = new PluginQueryTokenizerPreferencesManager();
        this._prefsManager.initialize((IPlugin)this, (IQueryTokenizerPreferenceBean)new DerbyPreferenceBean());
        DerbyPreferenceBean prefBean = (DerbyPreferenceBean)this._prefsManager.getPreferences();
        if (prefBean.isReadClobsFully()) {
            Main.getApplication().getDataTypeComponentFactoryRegistry().registerDataTypeFactory((IDataTypeComponentFactory)new DerbyClobDataTypeComponentFactory());
        }
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(ISession session) {
        if (!this.isPluginSession(session)) {
            return null;
        }
        DerbyPreferenceBean prefBean = (DerbyPreferenceBean)this._prefsManager.getPreferences();
        if (prefBean.isInstallCustomQueryTokenizer()) {
            DerbyQueryTokenizer tokenizer = new DerbyQueryTokenizer(prefBean.getStatementSeparator(), prefBean.getLineComment(), prefBean.isRemoveMultiLineComments(), prefBean.isRemoveLineComments());
            session.setQueryTokenizer((IQueryTokenizer)tokenizer);
        }
        GUIUtils.processOnSwingEventThread(() -> this.updateTreeApi(session.getSessionInternalFrame().getObjectTreeAPI()));
        if (DerbyPlugin.isEmbeddedDerby(session)) {
            this._embeddedSessions.computeIfAbsent(DerbyPlugin.getDatabaseName(session), k -> new ArrayList()).add(new WeakReference<ISession>(session));
            this._embeddedDriver = session.getDriver();
        }
        return new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
            }

            public void additionalSQLTabOpened(AdditionalSQLTab additionalSQLTab) {
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
                DerbyPlugin.this.updateTreeApi(objectTreeInternalFrame.getObjectTreeAPI());
            }

            public void objectTreeInSQLTabOpened(ObjectTreePanel objectTreePanel) {
                DerbyPlugin.this.updateTreeApi((IObjectTreeAPI)objectTreePanel);
            }
        };
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isDerby((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void updateTreeApi(IObjectTreeAPI objectTreeAPI) {
        DerbyPreferenceBean prefBean = (DerbyPreferenceBean)this._prefsManager.getPreferences();
        this._treeAPI = objectTreeAPI;
        this._treeAPI.addDetailTab(DatabaseObjectType.PROCEDURE, (IObjectTab)new ProcedureSourceTab(i18n.SHOW_PROCEDURE_SOURCE, prefBean.getStatementSeparator()));
        this._treeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(i18n.SHOW_VIEW_SOURCE));
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        TableWithChildNodesExpander trigExp = new TableWithChildNodesExpander();
        trigExp.setTableTriggerExtractor((ITableTriggerExtractor)new DerbyTableTriggerExtractorImpl());
        this._treeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)trigExp);
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab("The source of the trigger"));
    }

    private boolean shouldDrop(String dbName) {
        if (this._appShuttingDown) {
            return true;
        }
        int option = JOptionPane.showOptionDialog(null, MessageFormat.format(i18n.DROP_DB_QUESTION, dbName.replaceFirst("^memory:", "")), i18n.EMBEDDED_DERBY_TITLE, 0, 3, null, new Object[]{i18n.DROP_OPTION, i18n.KEEP_OPTION}, i18n.KEEP_OPTION);
        return option == 0;
    }

    private boolean flushEmbeddedSessions() {
        if (this._embeddedSessions.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<String, List<WeakReference<ISession>>>> iter = this._embeddedSessions.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, List<WeakReference<ISession>>> entry = iter.next();
            if (!this.flushEmbeddedSessions(entry.getValue())) continue;
            String dbName = entry.getKey();
            if (dbName.startsWith("memory:")) {
                if (!this.shouldDrop(dbName)) continue;
                this.shutdownEmbeddedDerby(dbName, true);
                iter.remove();
                continue;
            }
            if (dbName.equals(UNKNOWN_DBNAME)) continue;
            this.shutdownEmbeddedDerby(dbName);
            iter.remove();
        }
        return this._embeddedSessions.isEmpty();
    }

    private boolean flushEmbeddedSessions(List<WeakReference<ISession>> list) {
        if (list.isEmpty()) {
            return false;
        }
        Iterator<WeakReference<ISession>> iter = list.iterator();
        while (iter.hasNext()) {
            ISession session = (ISession)iter.next().get();
            if (session != null && !session.isClosed()) continue;
            iter.remove();
        }
        return list.isEmpty();
    }

    static boolean isEmbeddedDerby(ISession session) {
        return session.getDriver().getDriverClassName().startsWith("org.apache.derby.jdbc.EmbeddedDriver");
    }

    private static String getDatabaseName(ISession session) {
        try {
            String jdbcURL = session.getMetaData().getURL();
            int semIdx = jdbcURL.indexOf(59);
            return semIdx > 0 ? jdbcURL.substring("jdbc:derby:".length(), semIdx) : jdbcURL.substring("jdbc:derby:".length());
        }
        catch (SQLException e) {
            s_log.warn((Object)"Could not determine Embedded Derby database name", (Throwable)e);
            return UNKNOWN_DBNAME;
        }
    }

    private void shutdownEmbeddedDerby() {
        this.shutdownEmbeddedDerby("");
    }

    private void shutdownEmbeddedDerby(String dbName) {
        this.shutdownEmbeddedDerby(dbName, false);
    }

    private void shutdownEmbeddedDerby(String dbName, boolean drop) {
        try {
            ISQLDriver iSqlDr = this._embeddedDriver;
            if (this._embeddedDriver == null) {
                s_log.warn((Object)"shutdownEmbeddedDerby: driver reference is null");
                return;
            }
            IIdentifier drId = iSqlDr.getIdentifier();
            SQLDriverManager sqlDrMan = this._app.getSQLDriverManager();
            Driver jdbcDr = sqlDrMan.getJDBCDriver(drId);
            try {
                jdbcDr.connect("jdbc:derby:" + dbName + ";" + (drop ? "drop" : "shutdown") + "=true", new Properties());
            }
            catch (SQLException e) {
                if (Arrays.asList("08006", "XJ015").contains(e.getSQLState())) {
                    this._app.getMessageHandler().showMessage(e.getMessage());
                }
                this._app.getMessageHandler().showErrorMessage((Throwable)e);
            }
            if (dbName.isEmpty()) {
                sqlDrMan.registerSQLDriver(iSqlDr);
                this._embeddedDriver = null;
            }
        }
        catch (Exception e) {
            s_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private class SessionListener
    extends SessionAdapter {
        private SessionListener() {
        }

        public void sessionClosed(SessionEvent evt) {
            if (DerbyPlugin.this.flushEmbeddedSessions()) {
                DerbyPlugin.this.shutdownEmbeddedDerby();
            }
        }
    }

    static interface i18n {
        public static final String SHOW_VIEW_SOURCE = s_stringMgr.getString("DerbyPlugin.showViewSource");
        public static final String SHOW_PROCEDURE_SOURCE = s_stringMgr.getString("DerbyPlugin.showProcedureSource");
        public static final String PREFS_TITLE = s_stringMgr.getString("DerbyPlugin.prefsTitle");
        public static final String PREFS_HINT = s_stringMgr.getString("DerbyPlugin.prefsHint");
        public static final String EMBEDDED_DERBY_TITLE = s_stringMgr.getString("DerbyPlugin.embeddedDerby.title");
        public static final String DROP_DB_QUESTION = s_stringMgr.getString("DerbyPlugin.embeddedDerby.inMemoryDropQuestion");
        public static final String DROP_OPTION = s_stringMgr.getString("DerbyPlugin.embeddedDerby.inMemoryDropOption");
        public static final String KEEP_OPTION = s_stringMgr.getString("DerbyPlugin.embeddedDerby.inMemoryKeepOption");
    }
}

