/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.derby.types;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BaseKeyTextHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.EmptyWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.whereClause.IsNullWhereClausePart;
import net.sourceforge.squirrel_sql.fw.datasetviewer.celldatapopup.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.plugins.derby.types.DerbyClobDescriptor;

public class DerbyClobDataTypeComponent
extends BaseDataTypeComponent
implements IDataTypeComponent {
    private boolean _isNullable;
    private IRestorableTextComponent _textComponent;
    private IOUtilities ioUtils = new IOUtilitiesImpl();

    public String getClassName() {
        return "net.sourceforge.squirrel_sql.plugins.derby.types.DerbyClobDescriptor";
    }

    public static boolean getReadCompleteClob() {
        return true;
    }

    public static void setReadCompleteClob(boolean val) {
    }

    public boolean areEqual(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 != null) {
            return ((DerbyClobDescriptor)obj1).equals((DerbyClobDescriptor)obj2);
        }
        return ((DerbyClobDescriptor)obj2).equals((DerbyClobDescriptor)obj1);
    }

    public String renderObject(Object value) {
        return DefaultColumnRenderer.renderObject((Object)value);
    }

    public boolean isEditableInCell(Object originalValue) {
        DerbyClobDescriptor cdesc = (DerbyClobDescriptor)originalValue;
        return cdesc == null || cdesc.getData() == null || cdesc.getData().indexOf(10) <= -1;
    }

    public boolean needToReRead(Object originalValue) {
        return false;
    }

    public void setColumnDisplayDefinition(ColumnDisplayDefinition def) {
        super.setColumnDisplayDefinition(def);
        this._isNullable = def.isNullable();
    }

    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        DerbyClobDescriptor cdesc;
        if (value.equals("<null>")) {
            return null;
        }
        if (originalValue == null) {
            cdesc = new DerbyClobDescriptor(value);
        } else {
            cdesc = (DerbyClobDescriptor)originalValue;
            cdesc = new DerbyClobDescriptor(value);
        }
        return cdesc;
    }

    public boolean useBinaryEditingPanel() {
        return false;
    }

    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    protected KeyListener getKeyListener(IRestorableTextComponent component) {
        return new KeyTextHandler();
    }

    public JTextField getJTextField(final JTable table) {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener((KeyListener)((Object)new KeyTextHandler()));
        ((RestorableJTextField)this._textComponent).addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((Component)((RestorableJTextField)DerbyClobDataTypeComponent.this._textComponent), evt, table);
                    CellDataPopup.showDialog((JTable)table, (ColumnDisplayDefinition)DerbyClobDataTypeComponent.this._colDef, (MouseEvent)tableEvt, (boolean)true);
                }
            }
        });
        return (JTextField)this._textComponent;
    }

    public JTextArea getJTextArea(Object value, ColumnDisplayDefinition colDef) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(DefaultColumnRenderer.renderObject((Object)value));
        ((RestorableJTextArea)this._textComponent).addKeyListener((KeyListener)((Object)new KeyTextHandler()));
        return (RestorableJTextArea)this._textComponent;
    }

    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        return DerbyClobDataTypeComponent.staticReadResultSet(rs, index);
    }

    public static Object staticReadResultSet(ResultSet rs, int index) throws SQLException {
        Clob clob = rs.getClob(index);
        if (rs.wasNull()) {
            return null;
        }
        String clobData = clob.getSubString(1L, (int)clob.length());
        return new DerbyClobDescriptor(clobData);
    }

    public IWhereClausePart getWhereClauseValue(Object value, ISQLDatabaseMetaData md) {
        if (value == null || ((DerbyClobDescriptor)value).getData() == null) {
            return new IsNullWhereClausePart(this._colDef);
        }
        return new EmptyWhereClausePart();
    }

    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null || ((DerbyClobDescriptor)value).getData() == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            DerbyClobDescriptor cdesc = (DerbyClobDescriptor)value;
            pstmt.setCharacterStream(position, (Reader)new StringReader(cdesc.getData()), cdesc.getData().length());
        }
    }

    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return null;
    }

    public boolean canDoFileIO() {
        return true;
    }

    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = null;
        try {
            outWriter = new OutputStreamWriter(outStream);
            StringBuffer messageBuffer = new StringBuffer();
            this.validateAndConvertInPopup(text, null, messageBuffer);
            if (messageBuffer.length() > 0) {
                throw new IOException(new String(messageBuffer));
            }
            outWriter.write(text);
            outWriter.flush();
        }
        finally {
            this.ioUtils.closeWriter((Writer)outWriter);
        }
    }

    private class KeyTextHandler
    extends BaseKeyTextHandler {
        private KeyTextHandler() {
        }

        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)DerbyClobDataTypeComponent.this._textComponent;
            String text = _theComponent.getText();
            if (DerbyClobDataTypeComponent.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DerbyClobDataTypeComponent.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DerbyClobDataTypeComponent.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DerbyClobDataTypeComponent.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else {
                this.handleNotNullableField(text, c, e, DerbyClobDataTypeComponent.this._textComponent);
            }
        }
    }
}

