/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.radiance.common.api;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterGraphics;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.pushingpixels.radiance.common.api.font.FontPolicy;
import org.pushingpixels.radiance.common.api.font.FontSet;
import org.pushingpixels.radiance.common.internal.contrib.intellij.JBHiDPIScaledImage;
import org.pushingpixels.radiance.common.internal.contrib.intellij.UIUtil;
import org.pushingpixels.radiance.common.internal.contrib.jgoodies.looks.LookUtils;
import org.pushingpixels.radiance.common.internal.font.DefaultGnomeFontPolicy;
import org.pushingpixels.radiance.common.internal.font.DefaultKDEFontPolicy;
import org.pushingpixels.radiance.common.internal.font.DefaultMacFontPolicy;
import org.pushingpixels.radiance.common.internal.font.FontPolicies;
import org.pushingpixels.radiance.common.internal.font.FontSets;
import org.pushingpixels.radiance.common.internal.font.RadianceFontSet;
import org.pushingpixels.radiance.common.internal.font.ScaledFontSet;

public class RadianceCommonCortex {
    private static final String PROP_DESKTOPHINTS = "awt.font.desktophints";
    private static Platform platform;
    private static Map<String, Map> desktopHintsCache;

    private RadianceCommonCortex() {
    }

    public static synchronized Platform getPlatform() {
        if (platform != null) {
            return platform;
        }
        if (LookUtils.IS_OS_WINDOWS) {
            platform = Platform.WINDOWS;
            return platform;
        }
        if (LookUtils.IS_OS_MAC) {
            platform = Platform.MACOS;
            return platform;
        }
        try {
            if (DefaultKDEFontPolicy.isKDERunning()) {
                platform = Platform.KDE;
                return platform;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            PrivilegedAction<String> desktopAction = () -> System.getProperty("sun.desktop");
            String desktop = AccessController.doPrivileged(desktopAction);
            if ("gnome".equals(desktop)) {
                platform = Platform.GNOME;
                return platform;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        platform = Platform.DEFAULT;
        return platform;
    }

    public static FontPolicy getDefaultFontPolicy() {
        FontPolicy defaultPolicy;
        Platform platform = RadianceCommonCortex.getPlatform();
        switch (platform) {
            case MACOS: {
                defaultPolicy = new DefaultMacFontPolicy();
                break;
            }
            case KDE: {
                defaultPolicy = new DefaultKDEFontPolicy();
                break;
            }
            case GNOME: {
                defaultPolicy = new DefaultGnomeFontPolicy();
                break;
            }
            case WINDOWS: {
                defaultPolicy = FontPolicies.getDefaultWindowsPolicy();
                break;
            }
            default: {
                defaultPolicy = FontPolicies.getDefaultPlasticPolicy();
            }
        }
        return () -> new RadianceFontSet(defaultPolicy.getFontSet());
    }

    public static FontPolicy getScaledFontPolicy(float scaleFactor) {
        FontSet defaultFontSet = RadianceCommonCortex.getDefaultFontPolicy().getFontSet();
        return () -> new ScaledFontSet(defaultFontSet, scaleFactor);
    }

    public static BufferedImage createThumbnail(double scale, BufferedImage image, int requestedThumbWidth) {
        float ratio = (float)image.getWidth() / (float)image.getHeight();
        int width = image.getWidth();
        BufferedImage thumb = image;
        do {
            if ((width /= 2) < requestedThumbWidth) {
                width = requestedThumbWidth;
            }
            BufferedImage temp = RadianceCommonCortex.getBlankScaledImage(scale, width, (int)((float)width / ratio));
            Graphics2D g2 = temp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.drawImage(thumb, 0, 0, (int)((double)temp.getWidth() / scale), (int)((double)temp.getHeight() / scale), null);
            g2.dispose();
            thumb = temp;
        } while (width != requestedThumbWidth);
        return thumb;
    }

    public static void installDesktopHints(Graphics2D g2, Font font) {
        boolean isDefaultMojaveFont;
        boolean bl = isDefaultMojaveFont = RadianceCommonCortex.getPlatform() == Platform.MACOS && LookUtils.IS_OS_MAC_MOJAVE_OR_LATER && g2.getDeviceConfiguration().getDevice().getType() == 0 && font instanceof FontSets.DefaultUIResourceFont;
        if (isDefaultMojaveFont) {
            return;
        }
        Map desktopHints = RadianceCommonCortex.desktopHints(g2);
        if (desktopHints != null && !desktopHints.isEmpty()) {
            g2.addRenderingHints(desktopHints);
        }
    }

    public static void clearDesktopHints(Graphics2D g2, Font font) {
        GraphicsDevice device = g2.getDeviceConfiguration().getDevice();
        String deviceId = device.getIDstring();
        desktopHintsCache.remove(deviceId);
    }

    private static Map desktopHints(Graphics2D g2) {
        if (RadianceCommonCortex.isPrinting(g2)) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsDevice device = g2.getDeviceConfiguration().getDevice();
        String deviceId = device.getIDstring();
        String key = deviceId;
        if (!desktopHintsCache.containsKey(key)) {
            Object aaHint;
            HashMap desktopHints = (HashMap)toolkit.getDesktopProperty("awt.font.desktophints." + deviceId);
            if (desktopHints == null) {
                desktopHints = (Map)toolkit.getDesktopProperty(PROP_DESKTOPHINTS);
            }
            if (desktopHints != null && ((aaHint = desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING)) == RenderingHints.VALUE_TEXT_ANTIALIAS_OFF || aaHint == RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT)) {
                desktopHints = null;
            }
            if (desktopHints == null) {
                desktopHints = new HashMap();
            }
            desktopHintsCache.put(key, desktopHints);
        }
        return desktopHintsCache.get(key);
    }

    private static boolean isPrinting(Graphics g) {
        return g instanceof PrintGraphics || g instanceof PrinterGraphics;
    }

    public static double getScaleFactor(Component component) {
        if (component == null || component.getGraphicsConfiguration() == null) {
            return UIUtil.getScaleFactor();
        }
        AffineTransform transform = component.getGraphicsConfiguration().getDevice().getDefaultConfiguration().getDefaultTransform();
        return Math.max(transform.getScaleX(), transform.getScaleY());
    }

    public static BufferedImage getBlankScaledImage(double scale, int width, int height) {
        if (scale > 1.0) {
            return JBHiDPIScaledImage.createScaled(scale, width, height, 2);
        }
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        return c.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage getBlankUnscaledImage(int width, int height) {
        if (UIUtil.getScaleFactor() > 1.0) {
            return JBHiDPIScaledImage.createUnscaled(width, height, 2);
        }
        GraphicsEnvironment e = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice d = e.getDefaultScreenDevice();
        GraphicsConfiguration c = d.getDefaultConfiguration();
        return c.createCompatibleImage(width, height, 3);
    }

    public static void drawImageWithScale(Graphics g, double scaleFactor, Image img, int x, int y) {
        if (img instanceof JBHiDPIScaledImage) {
            g.drawImage(img, x, y, (int)((double)img.getWidth(null) / scaleFactor), (int)((double)img.getHeight(null) / scaleFactor), null);
        } else {
            g.drawImage(img, x, y, img.getWidth(null), img.getHeight(null), null);
        }
    }

    public static void drawImageWithScale(Graphics g, double scaleFactor, Image img, int x, int y, int width, int height, int offsetX, int offsetY) {
        if (img instanceof JBHiDPIScaledImage) {
            g.drawImage(img, x, y, x + width, y + height, x + (int)((double)offsetX * scaleFactor), y + (int)((double)offsetY * scaleFactor), x + (int)((double)(offsetX + width) * scaleFactor), y + (int)((double)(offsetY + height) * scaleFactor), null);
        } else {
            g.drawImage(img, x, y, x + width, y + height, x + offsetX, y + offsetY, x + offsetX + width, y + offsetY + height, null);
        }
    }

    static {
        desktopHintsCache = new HashMap<String, Map>();
    }

    public static enum Platform {
        MACOS,
        GNOME,
        KDE,
        WINDOWS,
        DEFAULT;

    }
}

