/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import org.apache.commons.lang3.StringUtils;

public class DBUtil {
    public static String[] getAlterSQLForColumnChange(TableColumnInfo from, TableColumnInfo to, HibernateDialect dialect, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String defaultSQL;
        List<String> typeSQL;
        String commentSQL;
        String[] nullSQL;
        ArrayList<String> result = new ArrayList<String>();
        String nameSQL = DBUtil.getColumnNameAlterSQL(from, to, dialect, qualifier, prefs);
        if (nameSQL != null) {
            result.add(nameSQL);
        }
        if ((nullSQL = DBUtil.getNullAlterSQL(from, to, dialect, qualifier, prefs)) != null) {
            result.addAll(Arrays.asList(nullSQL));
        }
        if ((commentSQL = DBUtil.getCommentAlterSQL(from, to, dialect, qualifier, prefs)) != null) {
            result.add(commentSQL);
        }
        if ((typeSQL = DBUtil.getTypeAlterSQL(from, to, dialect, qualifier, prefs)) != null) {
            result.addAll(typeSQL);
        }
        if ((defaultSQL = DBUtil.getAlterSQLForColumnDefault(from, to, dialect, qualifier, prefs)) != null) {
            result.add(defaultSQL);
        }
        return result.toArray(new String[result.size()]);
    }

    public static List<String> getTypeAlterSQL(TableColumnInfo from, TableColumnInfo to, HibernateDialect dialect, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        if (from.getDataType() == to.getDataType() && from.getColumnSize() == to.getColumnSize()) {
            return null;
        }
        return dialect.getColumnTypeAlterSQL(from, to, qualifier, prefs);
    }

    public static String getColumnNameAlterSQL(TableColumnInfo from, TableColumnInfo to, HibernateDialect dialect, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        if (from.getColumnName().equals(to.getColumnName())) {
            return null;
        }
        return dialect.getColumnNameAlterSQL(from, to, qualifier, prefs);
    }

    public static String[] getNullAlterSQL(TableColumnInfo from, TableColumnInfo to, HibernateDialect dialect, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        if (from.isNullable().equalsIgnoreCase(to.isNullable())) {
            return null;
        }
        return dialect.getColumnNullableAlterSQL(to, qualifier, prefs);
    }

    public static String getCommentAlterSQL(TableColumnInfo from, TableColumnInfo to, HibernateDialect dialect, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String oldComment = from.getRemarks();
        String newComment = to.getRemarks();
        if (!dialect.supportsColumnComment()) {
            return null;
        }
        if (oldComment == null && newComment == null) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)oldComment) && StringUtils.isEmpty((CharSequence)newComment)) {
            return null;
        }
        if (oldComment == null || !oldComment.equals(newComment)) {
            return dialect.getColumnCommentAlterSQL(to, qualifier, prefs);
        }
        return null;
    }

    public static String getAlterSQLForColumnDefault(TableColumnInfo from, TableColumnInfo to, HibernateDialect dialect, DatabaseObjectQualifier qualifier, SqlGenerationPreferences prefs) {
        String oldDefault = from.getDefaultValue();
        String newDefault = to.getDefaultValue();
        if (oldDefault == null) {
            oldDefault = "";
        }
        if (newDefault == null) {
            newDefault = "";
        }
        if (!oldDefault.equals(newDefault)) {
            if (!dialect.supportsAlterColumnDefault()) {
                throw new UnsupportedOperationException(dialect.getDisplayName() + " doesn't support column default value alterations");
            }
            return dialect.getColumnDefaultAlterSQL(to, qualifier, prefs);
        }
        return null;
    }
}

