/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import net.sourceforge.squirrel_sql.client.gui.db.IDisposableDialog;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.SqlGenerationPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.ErrorDialog;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.SQLResultListener;
import net.sourceforge.squirrel_sql.plugins.refactoring.prefs.RefactoringPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.refactoring.prefs.RefactoringPreferencesManager;

public abstract class AbstractRefactoringCommand
implements ICommand {
    private static final ILogger s_log = LoggerController.createLogger(AbstractRefactoringCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AbstractRefactoringCommand.class);
    protected final ISession _session;
    protected final IDatabaseObjectInfo[] _info;
    protected HibernateDialect _dialect;
    protected final SqlGenerationPreferences _sqlPrefs;
    protected final DatabaseObjectQualifier _qualifier;

    public AbstractRefactoringCommand(ISession session, IDatabaseObjectInfo[] info) {
        if (session == null) {
            throw new IllegalArgumentException("ISession cannot be null");
        }
        if (info == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo[] cannot be null");
        }
        if (info[0] == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo[0] cannot be null.  Must have at least one object selected to be refactored");
        }
        this._session = session;
        this._info = info;
        this._qualifier = new DatabaseObjectQualifier(info[0].getCatalogName(), info[0].getSchemaName());
        RefactoringPreferenceBean prefsBean = RefactoringPreferencesManager.getPreferences();
        this._sqlPrefs = new SqlGenerationPreferences();
        if (prefsBean != null) {
            this._sqlPrefs.setQualifyTableNames(prefsBean.isQualifyTableNames());
            this._sqlPrefs.setQuoteIdentifiers(prefsBean.isQuoteIdentifiers());
        } else {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"RefactoringPreferencesManager.getPreferences returned null.  Unable to get user preferences");
            }
            this._sqlPrefs.setQualifyTableNames(false);
            this._sqlPrefs.setQuoteIdentifiers(false);
        }
        this._sqlPrefs.setSqlStatementSeparator(this._session.getQueryTokenizer().getSQLStatementSeparator());
    }

    public void execute() {
        try {
            ISQLDatabaseMetaData md = this._session.getMetaData();
            this._dialect = DialectFactory.getDialect((ISQLDatabaseMetaData)md);
            if (this.isRefactoringSupportedForDialect(this._dialect)) {
                this.onExecute();
            } else {
                String dialectName = DialectFactory.getDialectType((ISQLDatabaseMetaData)md).name();
                this._session.showErrorMessage(s_stringMgr.getString("AbstractRefactoringCommand.unsupportedRefactoringMsg", new Object[]{dialectName}));
            }
        }
        catch (UserCancelledOperationException e) {
            this._session.showErrorMessage(i18n.DIALECT_SELECTION_CANCELLED);
        }
        catch (Exception e) {
            this._session.showErrorMessage((Throwable)e);
            s_log.error((Object)("Unexpected exception on execution: " + e.getMessage()), (Throwable)e);
        }
    }

    protected abstract boolean isRefactoringSupportedForDialect(HibernateDialect var1);

    protected abstract void onExecute() throws Exception;

    protected abstract String[] generateSQLStatements() throws Exception;

    protected void getSQLStatements(final SQLResultListener listener) {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                try {
                    listener.finished(AbstractRefactoringCommand.this.generateSQLStatements());
                }
                catch (UserCancelledOperationException ucoe) {
                    AbstractRefactoringCommand.this._session.showErrorMessage(i18n.DIALECT_SELECTION_CANCELLED);
                }
                catch (Exception e) {
                    AbstractRefactoringCommand.this._session.showErrorMessage((Throwable)e);
                    s_log.error((Object)("Unexpected exception on sql generation: " + e.getMessage()), (Throwable)e);
                }
            }
        });
    }

    protected abstract void executeScript(String var1);

    private String createExecutableScriptFromStatements(String[] stmts, boolean stripComments) {
        StringBuilder result = new StringBuilder();
        String seperator = this._sqlPrefs.getSqlStatementSeparator();
        for (String stmt : stmts) {
            boolean isComment = stmt.startsWith("--");
            if (stripComments && isComment) continue;
            result.append(stmt);
            if (isComment) {
                result.append("\n");
                continue;
            }
            if (!seperator.equals(";")) {
                result.append("\n");
            }
            result.append(seperator).append("\n\n");
        }
        return result.toString();
    }

    protected class ExecuteListener
    implements ActionListener,
    SQLResultListener {
        protected ExecuteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractRefactoringCommand.this.getSQLStatements(this);
        }

        @Override
        public void finished(String[] stmts) {
            if (stmts == null || stmts.length == 0) {
                AbstractRefactoringCommand.this._session.showMessage(i18n.NO_CHANGES);
                return;
            }
            String script = AbstractRefactoringCommand.this.createExecutableScriptFromStatements(stmts, true);
            AbstractRefactoringCommand.this.executeScript(script);
        }
    }

    protected class EditSQLListener
    implements ActionListener,
    SQLResultListener {
        private final IDisposableDialog _parentDialog;

        public EditSQLListener(IDisposableDialog parentDialog) {
            this._parentDialog = parentDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractRefactoringCommand.this.getSQLStatements(this);
        }

        @Override
        public void finished(String[] stmts) {
            if (stmts == null || stmts.length == 0) {
                AbstractRefactoringCommand.this._session.showMessage(i18n.NO_CHANGES);
                return;
            }
            final String script = AbstractRefactoringCommand.this.createExecutableScriptFromStatements(stmts, false);
            GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    EditSQLListener.this.onFinished(script);
                }
            });
        }

        private void onFinished(String script) {
            String current;
            if (this._parentDialog != null) {
                this._parentDialog.dispose();
            }
            Object viewableScript = (current = AbstractRefactoringCommand.this._session.getSQLPanelAPIOfActiveSessionWindow().getEntireSQLScript()).isEmpty() || current.endsWith("\n") ? script : "\n" + script;
            AbstractRefactoringCommand.this._session.getSQLPanelAPIOfActiveSessionWindow().appendSQLScript((String)viewableScript, true);
            AbstractRefactoringCommand.this._session.selectMainTab(1);
        }
    }

    protected class ShowSQLListener
    implements ActionListener,
    SQLResultListener {
        private final String _dialogTitle;
        private final JDialog _parentDialog;

        public ShowSQLListener(String dialogTitle, IDisposableDialog parentDialog) {
            this._dialogTitle = dialogTitle;
            this._parentDialog = (JDialog)parentDialog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractRefactoringCommand.this.getSQLStatements(this);
        }

        @Override
        public void finished(String[] stmts) {
            if (stmts == null || stmts.length == 0) {
                AbstractRefactoringCommand.this._session.showMessage(i18n.NO_CHANGES);
                return;
            }
            final String script = AbstractRefactoringCommand.this.createExecutableScriptFromStatements(stmts, false);
            GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ErrorDialog showSQLDialog = ShowSQLListener.this._parentDialog != null ? new ErrorDialog((Dialog)ShowSQLListener.this._parentDialog, script) : new ErrorDialog((Frame)AbstractRefactoringCommand.this._session.getApplication().getMainFrame(), script);
                    showSQLDialog.setTitle(ShowSQLListener.this._dialogTitle);
                    showSQLDialog.setVisible(true);
                }
            });
        }
    }

    static interface i18n {
        public static final String NO_CHANGES = s_stringMgr.getString("AbstractRefactoringCommand.noChanges");
        public static final String DIALECT_SELECTION_CANCELLED = s_stringMgr.getString("AbstractRefactoringCommand.dialectSelectionCancelled");
        public static final String UNSUPPORTED_TYPE_TITLE = s_stringMgr.getString("AbstractRefactoringCommand.unsupportedTypeTitle");
    }
}

