/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.gui.db.ColumnDetailDialog;
import net.sourceforge.squirrel_sql.client.gui.db.IDisposableDialog;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.HibernateException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.CommandExecHandler;

public class AddColumnCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(AddColumnCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddColumnCommand.class);
    protected ColumnDetailDialog customDialog;

    public AddColumnCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() {
        this.showCustomDialog();
    }

    @Override
    protected String[] generateSQLStatements() throws Exception {
        TableColumnInfo info = this.customDialog.getColumnInfo();
        String[] result = null;
        DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(info.getCatalogName(), info.getSchemaName());
        try {
            result = this._dialect.getAddColumnSQL(info, qualifier, this._sqlPrefs);
        }
        catch (HibernateException e1) {
            String dataType = this.customDialog.getSelectedTypeName();
            JOptionPane.showMessageDialog((Component)this.customDialog, s_stringMgr.getString("AbstractRefactoringCommand.unsupportedTypeMsg", new Object[]{this._dialect.getDisplayName(), dataType}), AbstractRefactoringCommand.i18n.UNSUPPORTED_TYPE_TITLE, 0);
        }
        catch (UnsupportedOperationException e2) {
            this._session.showMessage(s_stringMgr.getString("AddColumnCommand.unsupportedOperationMsg", new Object[]{this._dialect.getDisplayName()}));
        }
        return result;
    }

    @Override
    protected void executeScript(String script) {
        CommandExecHandler handler = new CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AddColumnCommand.this.customDialog.setVisible(false);
                AddColumnCommand.this.customDialog.dispose();
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialect) {
        return true;
    }

    private void showCustomDialog() {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AddColumnCommand.this.customDialog = new ColumnDetailDialog(0);
                        AddColumnCommand.this.customDialog.setTableName(AddColumnCommand.this._info[0].getQualifiedName());
                        AddColumnCommand.this.customDialog.setSelectedDialect(AddColumnCommand.this._dialect.getDisplayName());
                        AddColumnCommand.this.customDialog.addExecuteListener((ActionListener)new AddColumnExecuteListener());
                        AddColumnCommand.this.customDialog.addEditSQLListener((ActionListener)new AbstractRefactoringCommand.EditSQLListener((IDisposableDialog)AddColumnCommand.this.customDialog));
                        AddColumnCommand.this.customDialog.addShowSQLListener((ActionListener)new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, (IDisposableDialog)AddColumnCommand.this.customDialog));
                        AddColumnCommand.this.customDialog.addDialectListListener((ItemListener)new DialectListListener());
                        AddColumnCommand.this.customDialog.setLocationRelativeTo((Component)SessionUtils.getOwningFrame((ISession)AddColumnCommand.this._session));
                        AddColumnCommand.this.customDialog.setVisible(true);
                    }
                });
            }
        });
    }

    private class DialectListListener
    implements ItemListener {
        private DialectListListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            AddColumnCommand.this._dialect = DialectFactory.getDialect((String)AddColumnCommand.this.customDialog.getSelectedDBName());
        }
    }

    private class AddColumnExecuteListener
    extends AbstractRefactoringCommand.ExecuteListener {
        private AddColumnExecuteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String columnName = AddColumnCommand.this.customDialog.getColumnInfo().getColumnName();
            try {
                if (!this.isColumnNameUnique(columnName)) {
                    String message = s_stringMgr.getString("AddColumnCommand.columnAlreadyExistsMsg", new Object[]{AddColumnCommand.this.customDialog.getTableName(), columnName});
                    JOptionPane.showMessageDialog((Component)AddColumnCommand.this.customDialog, message, i18n.COLUMN_ALREADY_EXISTS_TITLE, 0);
                } else {
                    super.actionPerformed(e);
                }
            }
            catch (SQLException ex) {
                AddColumnCommand.this._session.showErrorMessage((Throwable)ex);
                s_log.error((Object)("Unexpected exception - " + ex.getMessage()), (Throwable)ex);
            }
        }

        private boolean isColumnNameUnique(String columnName) throws SQLException {
            TableColumnInfo[] columnInfos;
            boolean result = true;
            ISQLDatabaseMetaData md = AddColumnCommand.this._session.getMetaData();
            for (TableColumnInfo columnInfo : columnInfos = md.getColumnInfo((ITableInfo)AddColumnCommand.this._info[0])) {
                String existingColumnName = columnInfo.getColumnName();
                if (!columnName.equalsIgnoreCase(existingColumnName)) continue;
                result = false;
                break;
            }
            return result;
        }
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = s_stringMgr.getString("AddColumnCommand.sqlDialogTitle");
        public static final String COLUMN_ALREADY_EXISTS_TITLE = s_stringMgr.getString("AddColumnCommand.columnAlreadyExistsTitle");
    }
}

