/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.sql.SQLException;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.CommandExecHandler;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AddIndexDialog;

public class AddIndexCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(AddIndexCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddIndexCommand.class);
    protected AddIndexDialog customDialog;

    public AddIndexCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            return;
        }
        this.showCustomDialog();
    }

    @Override
    protected String[] generateSQLStatements() throws Exception {
        DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(this._info[0].getCatalogName(), this._info[0].getSchemaName());
        String result = this._dialect.getCreateIndexSQL(this.customDialog.getIndexName(), this._info[0].getSimpleName(), this.customDialog.getAccessMethod(), this.customDialog.getIndexColumns(), this.customDialog.isUniqueSet(), this.customDialog.getTablespaceText(), this.customDialog.getConstraints(), qualifier, this._sqlPrefs);
        return new String[]{result};
    }

    @Override
    protected void executeScript(String script) {
        CommandExecHandler handler = new CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AddIndexCommand.this.customDialog.setVisible(false);
                        AddIndexCommand.this.customDialog.dispose();
                        AddIndexCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return dialectExt.supportsCreateIndex();
    }

    private void showCustomDialog() throws SQLException {
        ITableInfo selectedTable = (ITableInfo)this._info[0];
        TableColumnInfo[] tableColumnInfos = this._session.getMetaData().getColumnInfo(selectedTable);
        TreeSet<String> localColumns = new TreeSet<String>();
        for (TableColumnInfo columns : tableColumnInfos) {
            localColumns.add(columns.getColumnName());
        }
        this.customDialog = new AddIndexDialog(localColumns.toArray(new String[0]));
        if (this._dialect.supportsAccessMethods()) {
            this.customDialog.setAccessMethods(true, this._dialect.getIndexAccessMethodsTypes());
        }
        if (this._dialect.supportsTablespace()) {
            this.customDialog.enableTablespaceField(true);
        }
        this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
        this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(this.customDialog));
        this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, this.customDialog));
        this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)this._session));
        this.customDialog.setVisible(true);
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = s_stringMgr.getString("AddIndexCommand.sqlDialogTitle");
    }
}

