/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.NoAutoCommitCommandExecHandler;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AddLookupTableDialog;

public class AddLookupTableCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(AddLookupTableCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddLookupTableCommand.class);
    protected AddLookupTableDialog _customDialog;

    public AddLookupTableCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            return;
        }
        this.showCustomDialog();
    }

    @Override
    protected String[] generateSQLStatements() throws Exception {
        TableColumnInfo pk;
        ArrayList<String> results = new ArrayList<String>();
        ISQLDatabaseMetaData md = this._session.getMetaData();
        String catalog = this._info[0].getCatalogName();
        String schema = this._info[0].getSchemaName();
        String lookupTableName = this._customDialog.getLookupTableName();
        String lookupPrimaryKey = this._customDialog.getLookupPrimaryKey();
        TableColumnInfo sourceColumn = null;
        for (TableColumnInfo info : md.getColumnInfo((ITableInfo)this._info[0])) {
            if (!info.getColumnName().equals(this._customDialog.getSourceColumn())) continue;
            sourceColumn = info;
            break;
        }
        if (sourceColumn == null) {
            throw new IllegalStateException("The selected source column was not found.");
        }
        String sourceTableName = sourceColumn.getTableName();
        String sourceColumnName = sourceColumn.getColumnName();
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        ArrayList<TableColumnInfo> primaryKeys = new ArrayList<TableColumnInfo>();
        if (this._customDialog.getMode() == 1) {
            pk = new TableColumnInfo(catalog, schema, lookupTableName, lookupPrimaryKey, sourceColumn.getDataType(), sourceColumn.getTypeName(), sourceColumn.getColumnSize(), sourceColumn.getDecimalDigits(), sourceColumn.getRadix(), sourceColumn.isNullAllowed(), sourceColumn.getRemarks(), sourceColumn.getDefaultValue(), sourceColumn.getOctetLength(), 1, sourceColumn.isNullable(), null, md);
            columns.add(pk);
            primaryKeys.add(pk);
        } else if (this._customDialog.getMode() == 2) {
            pk = new TableColumnInfo(catalog, schema, lookupTableName, lookupPrimaryKey, 4, JDBCTypeMapper.getJdbcTypeName((int)4), 0, 0, 0, 0, null, null, 0, 1, "NO", null, md);
            TableColumnInfo second = new TableColumnInfo(catalog, schema, lookupTableName, this._customDialog.getLookupSecondColumn(), sourceColumn.getDataType(), sourceColumn.getTypeName(), sourceColumn.getColumnSize(), sourceColumn.getDecimalDigits(), sourceColumn.getRadix(), 0, sourceColumn.getRemarks(), sourceColumn.getDefaultValue(), sourceColumn.getOctetLength(), 2, "NO", null, md);
            columns.add(pk);
            columns.add(second);
            primaryKeys.add(pk);
        }
        results.add(this._dialect.getCreateTableSQL(lookupTableName, columns, primaryKeys, this._sqlPrefs, this._qualifier));
        if (this._customDialog.getMode() == 1) {
            ArrayList<String> insertColumns = new ArrayList<String>();
            insertColumns.add(lookupPrimaryKey);
            String dataQuery = this.getDataQuery(schema, sourceTableName, sourceColumnName);
            results.add(this._dialect.getInsertIntoSQL(lookupTableName, insertColumns, dataQuery, this._qualifier, this._sqlPrefs));
            String constraintName = this._customDialog.getForeignKeyName();
            ArrayList<String[]> refs = new ArrayList<String[]>();
            refs.add(new String[]{sourceColumnName, lookupPrimaryKey});
            String[] fkSQLs = this._dialect.getAddForeignKeyConstraintSQL(sourceTableName, lookupTableName, constraintName, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), false, null, refs, "NO ACTION", "NO ACTION", this._qualifier, this._sqlPrefs);
            results.addAll(Arrays.asList(fkSQLs));
        } else if (this._customDialog.getMode() == 2) {
            String[] addColumnResults;
            String dataQuery = this.getDataQuery(schema, sourceTableName, sourceColumnName);
            List<String> data = this.executeStringQuery(dataQuery);
            ArrayList<String> insertColumns = new ArrayList<String>();
            insertColumns.add(lookupPrimaryKey);
            insertColumns.add(this._customDialog.getLookupSecondColumn());
            for (int i = 0; i < data.size(); ++i) {
                String valuesPart = " VALUES ( " + i + ", '" + data.get(i) + "' )";
                results.add(this._dialect.getInsertIntoSQL(lookupTableName, insertColumns, valuesPart, this._qualifier, this._sqlPrefs));
            }
            TableColumnInfo tempColumn = new TableColumnInfo(catalog, schema, sourceTableName, sourceColumnName + "_temp", sourceColumn.getDataType(), sourceColumn.getTypeName(), sourceColumn.getColumnSize(), sourceColumn.getDecimalDigits(), sourceColumn.getRadix(), sourceColumn.isNullAllowed(), sourceColumn.getRemarks(), sourceColumn.getDefaultValue(), sourceColumn.getOctetLength(), sourceColumn.getOrdinalPosition(), sourceColumn.isNullable(), null, md);
            results.add(this._dialect.getColumnNameAlterSQL(sourceColumn, tempColumn, this._qualifier, this._sqlPrefs));
            TableColumnInfo newColumn = new TableColumnInfo(catalog, schema, sourceTableName, sourceColumnName, 4, JDBCTypeMapper.getJdbcTypeName((int)4), 0, 0, 0, 1, sourceColumn.getRemarks(), null, 0, sourceColumn.getOrdinalPosition(), "YES", null, md);
            for (String addColumnResult : addColumnResults = this._dialect.getAddColumnSQL(newColumn, this._qualifier, this._sqlPrefs)) {
                results.add(addColumnResult);
            }
            String constraintName = this._customDialog.getForeignKeyName();
            ArrayList<String[]> refs = new ArrayList<String[]>();
            refs.add(new String[]{sourceColumnName, lookupPrimaryKey});
            String[] fkSQLs = this._dialect.getAddForeignKeyConstraintSQL(sourceTableName, lookupTableName, constraintName, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), false, null, refs, "NO ACTION", "NO ACTION", this._qualifier, this._sqlPrefs);
            results.addAll(Arrays.asList(fkSQLs));
            for (int i = 0; i < data.size(); ++i) {
                results.addAll(Arrays.asList(this._dialect.getUpdateSQL(sourceTableName, new String[]{sourceColumnName}, new String[]{String.valueOf(i)}, null, new String[]{sourceColumnName + "_temp"}, new String[]{"'" + data.get(i) + "'"}, this._qualifier, this._sqlPrefs)));
            }
            if (sourceColumn.isNullAllowed() == 0) {
                TableColumnInfo newColumnNotNull = new TableColumnInfo(catalog, schema, sourceTableName, newColumn.getColumnName(), newColumn.getDataType(), newColumn.getTypeName(), newColumn.getColumnSize(), newColumn.getDecimalDigits(), newColumn.getRadix(), 0, newColumn.getRemarks(), newColumn.getDefaultValue(), newColumn.getOctetLength(), newColumn.getOrdinalPosition(), "NO", null, md);
                results.addAll(Arrays.asList(this._dialect.getColumnNullableAlterSQL(newColumnNotNull, this._qualifier, this._sqlPrefs)));
            }
            Object dropStmt = this._dialect.getColumnDropSQL(sourceTableName, sourceColumnName + "_temp", this._qualifier, this._sqlPrefs);
            if (this._customDialog.getDropCascade()) {
                dropStmt = (String)dropStmt + " CASCADE";
            }
            results.add((String)dropStmt);
        }
        return results.toArray(new String[results.size()]);
    }

    @Override
    protected void executeScript(String script) {
        try {
            NoAutoCommitCommandExecHandler handler = new NoAutoCommitCommandExecHandler(this._session);
            SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
            executer.run();
            this._session.getApplication().getThreadPool().addTask(new Runnable(){

                @Override
                public void run() {
                    GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AddLookupTableCommand.this._customDialog.setVisible(false);
                            AddLookupTableCommand.this._customDialog.dispose();
                            AddLookupTableCommand.this._session.getSchemaInfo().reloadAll();
                        }
                    });
                }
            });
        }
        catch (SQLException e) {
            this._session.showErrorMessage((Throwable)e);
            s_log.error((Object)("Unexpected exception " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialect) {
        boolean result = true;
        result = result && dialect.supportsCreateTable();
        result = result && dialect.supportsInsertInto();
        result = result && dialect.supportsAddForeignKeyConstraint();
        result = result && dialect.supportsRenameColumn();
        result = result && dialect.supportsAddColumn();
        result = result && dialect.supportsUpdate();
        result = result && dialect.supportsAlterColumnNull();
        result = result && dialect.supportsDropColumn();
        return result;
    }

    private void showCustomDialog() throws SQLException {
        ISQLDatabaseMetaData md = this._session.getMetaData();
        ITableInfo selectedTable = (ITableInfo)this._info[0];
        TableColumnInfo[] tableColumnInfos = md.getColumnInfo(selectedTable);
        ForeignKeyInfo[] exportedKeys = md.getExportedKeysInfo(selectedTable);
        ForeignKeyInfo[] importedKeys = md.getImportedKeysInfo(selectedTable);
        this._customDialog = new AddLookupTableDialog(selectedTable.getSimpleName(), this.getColumnNames(tableColumnInfos, exportedKeys, importedKeys));
        this._customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
        this._customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(this._customDialog));
        this._customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, this._customDialog));
        this._customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)this._session));
        this._customDialog.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> executeStringQuery(String sql) {
        ArrayList<String> result = new ArrayList<String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this._session.getSQLConnection().createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String value = rs.getString(1);
                if (rs.wasNull()) continue;
                result.add(value);
            }
        }
        catch (SQLException e) {
            try {
                s_log.error((Object)("executeStringQuery: unexpected exception while executing query ( " + sql + " ): " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement((Statement)stmt);
                throw throwable;
            }
            SQLUtilities.closeResultSet((ResultSet)rs);
            SQLUtilities.closeStatement((Statement)stmt);
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)stmt);
        return result;
    }

    private String[] getColumnNames(TableColumnInfo[] infos, ForeignKeyInfo[] exportedKeys, ForeignKeyInfo[] importedKeys) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (TableColumnInfo tableColumnInfo : infos) {
            columnNames.add(tableColumnInfo.getColumnName());
        }
        for (TableColumnInfo tableColumnInfo : exportedKeys) {
            columnNames.remove(tableColumnInfo.getPrimaryKeyColumnName());
        }
        for (TableColumnInfo tableColumnInfo : importedKeys) {
            columnNames.remove(tableColumnInfo.getForeignKeyColumnName());
        }
        return columnNames.toArray(new String[0]);
    }

    private String getDataQuery(String schema, String table, String column) {
        StringBuilder result = new StringBuilder();
        result.append("SELECT DISTINCT \"").append(column).append("\" FROM ");
        if (this._sqlPrefs.isQualifyTableNames()) {
            result.append("\"").append(schema).append("\".\"").append(table).append("\"");
        } else {
            result.append(table);
        }
        return result.toString();
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = s_stringMgr.getString("AddLookupTableCommand.sqlDialogTitle");
    }
}

