/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.gui.db.ColumnListDialog;
import net.sourceforge.squirrel_sql.client.gui.db.IDisposableDialog;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.CommandExecHandler;

public class DropColumnCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(DropColumnCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropColumnCommand.class);
    protected ColumnListDialog customDialog;

    public DropColumnCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            s_log.error((Object)("onExecute: _info[0] isn't an instance of ITableInfo: class=" + this._info[0].getClass().getName()));
            return;
        }
        ITableInfo ti = (ITableInfo)this._info[0];
        TableColumnInfo[] columns = this._session.getSQLConnection().getSQLMetaData().getColumnInfo(ti);
        if (columns.length < 2) {
            this._session.showErrorMessage(i18n.SINGLE_COLUMN_MESSAGE);
        } else {
            this.showCustomDialog();
        }
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        TableColumnInfo[] columns = this.customDialog.getSelectedColumnList();
        String[] result = new String[columns.length];
        try {
            String tableName = this._info[0].getSimpleName();
            for (int i = 0; i < columns.length; ++i) {
                TableColumnInfo info = columns[i];
                String columnName = info.getColumnName();
                result[i] = this._dialect.getColumnDropSQL(tableName, columnName, this._qualifier, this._sqlPrefs);
            }
        }
        catch (UnsupportedOperationException e2) {
            this._session.showMessage(s_stringMgr.getString("RemoveColumnCommand.unsupportedOperationMsg", new Object[]{this._dialect.getDisplayName()}));
        }
        return result;
    }

    @Override
    protected void executeScript(String script) {
        CommandExecHandler handler = new CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropColumnCommand.this.customDialog.setVisible(false);
                        DropColumnCommand.this.customDialog.dispose();
                        DropColumnCommand.this._session.getSchemaInfo().reload(DropColumnCommand.this._info[0]);
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialect) {
        return dialect.supportsDropColumn();
    }

    private void showCustomDialog() throws SQLException {
        ITableInfo ti = (ITableInfo)this._info[0];
        TableColumnInfo[] columns = this._session.getMetaData().getColumnInfo(ti);
        this.customDialog = new ColumnListDialog(columns, 0);
        this.customDialog.setMultiSelection();
        this.customDialog.setTableName(ti.getQualifiedName());
        this.customDialog.addColumnSelectionListener((ActionListener)new AbstractRefactoringCommand.ExecuteListener());
        this.customDialog.addEditSQLListener((ActionListener)new AbstractRefactoringCommand.EditSQLListener((IDisposableDialog)this.customDialog));
        this.customDialog.addShowSQLListener((ActionListener)new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, (IDisposableDialog)this.customDialog));
        this.customDialog.setLocationRelativeTo((Component)SessionUtils.getOwningFrame((ISession)this._session));
        this.customDialog.setVisible(true);
    }

    static interface i18n {
        public static final String SINGLE_COLUMN_MESSAGE = s_stringMgr.getString("RemoveColumnAction.singleColumnMessage");
        public static final String SHOWSQL_DIALOG_TITLE = s_stringMgr.getString("RemoveColumnCommand.sqlDialogTitle");
    }
}

