/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IndexInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.CommandExecHandler;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.DefaultDropDialog;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.DefaultListDialog;

public class DropIndexTableCommand
extends AbstractRefactoringCommand {
    private final ILogger s_log = LoggerController.createLogger(DropIndexTableCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropIndexTableCommand.class);
    protected DefaultDropDialog customDialog;
    private IndexInfo[] _dropIndexInfo;
    private DefaultListDialog listDialog;
    private String _tableName = null;

    public DropIndexTableCommand(ISession session, IDatabaseObjectInfo[] dbInfo) {
        super(session, dbInfo);
    }

    @Override
    protected void onExecute() throws SQLException {
        if (this._info[0].getDatabaseObjectType() == DatabaseObjectType.INDEX) {
            this._tableName = ((IndexInfo)this._info[0]).getTableName();
            this._dropIndexInfo = new IndexInfo[this._info.length];
            for (int i = 0; i < this._info.length; ++i) {
                this._dropIndexInfo[i] = (IndexInfo)this._info[i];
            }
            this.showCustomDialog();
            return;
        }
        ITableInfo ti = (ITableInfo)this._info[0];
        this._tableName = ti.getSimpleName();
        this._dropIndexInfo = this._session.getSQLConnection().getSQLMetaData().getIndexInfo(ti).toArray(new IndexInfo[0]);
        if (this._dropIndexInfo.length == 1) {
            this.showCustomDialog();
        } else {
            if (this.listDialog == null) {
                this.listDialog = new DefaultListDialog((IDatabaseObjectInfo[])this._dropIndexInfo, this._tableName, 3);
                this.listDialog.addColumnSelectionListener(new ColumnListSelectionActionListener());
                this.listDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)this._session));
            }
            this.listDialog.setVisible(true);
        }
    }

    protected void showCustomDialog() {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropIndexTableCommand.this.customDialog = new DefaultDropDialog((IDatabaseObjectInfo[])DropIndexTableCommand.this._dropIndexInfo, 3, SessionUtils.getOwningFrame((ISession)DropIndexTableCommand.this._session));
                        DropIndexTableCommand.this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
                        DropIndexTableCommand.this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(DropIndexTableCommand.this.customDialog));
                        DropIndexTableCommand.this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, DropIndexTableCommand.this.customDialog));
                        DropIndexTableCommand.this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)DropIndexTableCommand.this._session));
                        DropIndexTableCommand.this.customDialog.setVisible(true);
                    }
                });
            }
        });
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        ArrayList<String> result = new ArrayList<String>();
        if (this._dialect.supportsDropIndex()) {
            for (IndexInfo iInfo : this._dropIndexInfo) {
                DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(iInfo.getCatalogName(), iInfo.getSchemaName());
                result.add(this._dialect.getDropIndexSQL(this._tableName, iInfo.getSimpleName(), this.customDialog.isCascadeSelected(), qualifier, this._sqlPrefs));
            }
        } else {
            this._session.showMessage(s_stringMgr.getString("DropIndexCommand.unsupportedOperationMsg", new Object[]{this._dialect.getDisplayName()}));
        }
        return result.toArray(new String[0]);
    }

    @Override
    protected void executeScript(String script) {
        CommandExecHandler handler = new CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropIndexTableCommand.this.customDialog.setVisible(false);
                        DropIndexTableCommand.this.customDialog.dispose();
                        DropIndexTableCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return dialectExt.supportsDropIndex();
    }

    private class ColumnListSelectionActionListener
    implements ActionListener {
        private ColumnListSelectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DropIndexTableCommand.this.listDialog == null) {
                System.err.println("dialog was null");
                return;
            }
            DropIndexTableCommand.this.listDialog.dispose();
            DropIndexTableCommand.this._dropIndexInfo = DropIndexTableCommand.this.listDialog.getSelectedItems().toArray(new IndexInfo[0]);
            DropIndexTableCommand.this.showCustomDialog();
        }
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = s_stringMgr.getString("DropIndexCommand.sqlDialogTitle");
    }
}

