/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.gui.db.ColumnListDialog;
import net.sourceforge.squirrel_sql.client.gui.db.IDisposableDialog;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.PrimaryKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.CommandExecHandler;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.DropColumnCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.PrimaryKeyCommandUtility;

public class DropPrimaryKeyCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(DropColumnCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropPrimaryKeyCommand.class);
    protected ColumnListDialog customDialog;

    public DropPrimaryKeyCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            return;
        }
        ITableInfo ti = (ITableInfo)this._info[0];
        PrimaryKeyCommandUtility pkcUtil = new PrimaryKeyCommandUtility(this._session, this._info);
        if (!pkcUtil.tableHasPrimaryKey()) {
            this._session.showErrorMessage(s_stringMgr.getString("DropPrimaryKeyCommand.noKeyToDrop", new Object[]{ti.getSimpleName()}));
        } else {
            this.showCustomDialog();
        }
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        try {
            String result = this._dialect.getDropPrimaryKeySQL(this.customDialog.getPrimaryKeyName(), this.customDialog.getTableName(), this._qualifier, this._sqlPrefs);
            return new String[]{result};
        }
        catch (UnsupportedOperationException e2) {
            this._session.showMessage(s_stringMgr.getString("DropPrimaryKeyCommand.unsupportedOperationMsg", new Object[]{this._dialect.getDisplayName()}));
            return new String[0];
        }
    }

    @Override
    protected void executeScript(String script) {
        CommandExecHandler handler = new CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropPrimaryKeyCommand.this.customDialog.setVisible(false);
                        DropPrimaryKeyCommand.this.customDialog.dispose();
                        DropPrimaryKeyCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return true;
    }

    private void showCustomDialog() throws SQLException {
        ITableInfo ti = (ITableInfo)this._info[0];
        TableColumnInfo[] columns = this.getPkTableColumns(ti);
        this.customDialog = new ColumnListDialog(columns, 3);
        this.customDialog.addColumnSelectionListener((ActionListener)new AbstractRefactoringCommand.ExecuteListener());
        this.customDialog.addEditSQLListener((ActionListener)new AbstractRefactoringCommand.EditSQLListener((IDisposableDialog)this.customDialog));
        this.customDialog.addShowSQLListener((ActionListener)new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, (IDisposableDialog)this.customDialog));
        this.customDialog.setLocationRelativeTo((Component)SessionUtils.getOwningFrame((ISession)this._session));
        this.customDialog.setMultiSelection();
        this.customDialog.setTableName(ti.getSimpleName());
        SQLDatabaseMetaData md = this._session.getSQLConnection().getSQLMetaData();
        PrimaryKeyInfo[] infos = md.getPrimaryKey(ti);
        String pkName = infos[0].getSimpleName();
        this.customDialog.setPrimaryKeyName(pkName);
        this.customDialog.setVisible(true);
    }

    private TableColumnInfo[] getPkTableColumns(ITableInfo ti) throws SQLException {
        ArrayList<TableColumnInfo> result = new ArrayList<TableColumnInfo>();
        PrimaryKeyInfo[] pkCols = this._session.getMetaData().getPrimaryKey(ti);
        TableColumnInfo[] colInfos = this._session.getMetaData().getColumnInfo(ti);
        for (PrimaryKeyInfo pkInfo : pkCols) {
            String pkColName = pkInfo.getQualifiedColumnName();
            for (TableColumnInfo colInfo : colInfos) {
                if (!colInfo.getSimpleName().equals(pkColName)) continue;
                result.add(colInfo);
            }
        }
        return result.toArray(new TableColumnInfo[result.size()]);
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = s_stringMgr.getString("DropPrimaryKeyCommand.sqlDialogTitle");
    }
}

