/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.CommandExecHandler;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.DefaultDropDialog;

public class DropSequenceCommand
extends AbstractRefactoringCommand {
    private final ILogger s_log = LoggerController.createLogger(DropSequenceCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropSequenceCommand.class);
    protected DefaultDropDialog customDialog;

    public DropSequenceCommand(ISession session, IDatabaseObjectInfo[] dbInfo) {
        super(session, dbInfo);
    }

    @Override
    protected void onExecute() {
        this.showCustomDialog();
    }

    protected void showCustomDialog() {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropSequenceCommand.this.customDialog = new DefaultDropDialog(DropSequenceCommand.this._info, 4, SessionUtils.getOwningFrame((ISession)DropSequenceCommand.this._session));
                        DropSequenceCommand.this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
                        DropSequenceCommand.this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(DropSequenceCommand.this.customDialog));
                        DropSequenceCommand.this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, DropSequenceCommand.this.customDialog));
                        DropSequenceCommand.this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)DropSequenceCommand.this._session));
                        DropSequenceCommand.this.customDialog.setVisible(true);
                    }
                });
            }
        });
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        ArrayList<String> result = new ArrayList<String>();
        if (this._dialect.supportsDropSequence()) {
            for (IDatabaseObjectInfo dbo : this._info) {
                DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(dbo.getCatalogName(), dbo.getSchemaName());
                result.add(this._dialect.getDropSequenceSQL(dbo.getSimpleName(), this.customDialog.isCascadeSelected(), qualifier, this._sqlPrefs));
            }
        } else {
            this._session.showMessage(s_stringMgr.getString("DropSequenceCommand.unsupportedOperationMsg", new Object[]{this._dialect.getDisplayName()}));
        }
        return result.toArray(new String[0]);
    }

    @Override
    protected void executeScript(String script) {
        CommandExecHandler handler = new CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropSequenceCommand.this.customDialog.setVisible(false);
                        DropSequenceCommand.this.customDialog.dispose();
                        DropSequenceCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return dialectExt.supportsDropSequence();
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = s_stringMgr.getString("DropSequenceCommand.sqlDialogTitle");
    }
}

