/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IndexInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.CommandExecHandler;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.DefaultDropDialog;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.DefaultListDialog;

public class DropUniqueConstraintCommand
extends AbstractRefactoringCommand {
    private final ILogger s_log = LoggerController.createLogger(DropUniqueConstraintCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropUniqueConstraintCommand.class);
    protected DefaultDropDialog customDialog;
    private IndexInfo[] _dropIndexInfo;
    private DefaultListDialog listDialog;

    public DropUniqueConstraintCommand(ISession session, IDatabaseObjectInfo[] dbInfo) {
        super(session, dbInfo);
    }

    @Override
    protected void onExecute() throws SQLException {
        ITableInfo ti = (ITableInfo)this._info[0];
        List indexes = this._session.getSQLConnection().getSQLMetaData().getIndexInfo(ti);
        ArrayList<IndexInfo> uniqueIndexes = new ArrayList<IndexInfo>();
        for (IndexInfo index : indexes) {
            if (index.isNonUnique()) continue;
            uniqueIndexes.add(index);
        }
        if (uniqueIndexes.size() == 0) {
            this._session.showErrorMessage(s_stringMgr.getString("DropUniqueConstraintCommand.noUniqueConstraintonTable", new Object[]{ti.getSimpleName()}));
        } else if (uniqueIndexes.size() == 1) {
            this._dropIndexInfo = new IndexInfo[]{(IndexInfo)uniqueIndexes.get(0)};
            this.showCustomDialog();
        } else {
            this.listDialog = new DefaultListDialog((IDatabaseObjectInfo[])indexes.toArray(new IndexInfo[0]), ti.getSimpleName(), 4);
            this.listDialog.addColumnSelectionListener(new ColumnListSelectionActionListener());
            this.listDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)this._session));
            this.listDialog.setVisible(true);
        }
    }

    protected void showCustomDialog() {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropUniqueConstraintCommand.this.customDialog = new DefaultDropDialog((IDatabaseObjectInfo[])DropUniqueConstraintCommand.this._dropIndexInfo, 6, SessionUtils.getOwningFrame((ISession)DropUniqueConstraintCommand.this._session));
                        DropUniqueConstraintCommand.this.customDialog.setCascadeVisible(false);
                        DropUniqueConstraintCommand.this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
                        DropUniqueConstraintCommand.this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(DropUniqueConstraintCommand.this.customDialog));
                        DropUniqueConstraintCommand.this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, DropUniqueConstraintCommand.this.customDialog));
                        DropUniqueConstraintCommand.this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)DropUniqueConstraintCommand.this._session));
                        DropUniqueConstraintCommand.this.customDialog.setVisible(true);
                    }
                });
            }
        });
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        ArrayList<String> result = new ArrayList<String>();
        for (IndexInfo iInfo : this._dropIndexInfo) {
            DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(iInfo.getCatalogName(), iInfo.getSchemaName());
            result.add(this._dialect.getDropConstraintSQL(iInfo.getTableName(), iInfo.getSimpleName(), qualifier, this._sqlPrefs));
        }
        return result.toArray(new String[0]);
    }

    @Override
    protected void executeScript(String script) {
        CommandExecHandler handler = new CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DropUniqueConstraintCommand.this.customDialog.setVisible(false);
                        DropUniqueConstraintCommand.this.customDialog.dispose();
                        DropUniqueConstraintCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return dialectExt.supportsDropConstraint();
    }

    private class ColumnListSelectionActionListener
    implements ActionListener {
        private ColumnListSelectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DropUniqueConstraintCommand.this.listDialog == null) {
                return;
            }
            DropUniqueConstraintCommand.this.listDialog.dispose();
            DropUniqueConstraintCommand.this._dropIndexInfo = DropUniqueConstraintCommand.this.listDialog.getSelectedItems().toArray(new IndexInfo[0]);
            DropUniqueConstraintCommand.this.showCustomDialog();
        }
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = s_stringMgr.getString("DropUniqueConstraintCommand.sqlDialogTitle");
    }
}

