/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.client.session.schemainfo.CaseInsensitiveString;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.CommandExecHandler;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.IMergeTableDialog;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.IMergeTableDialogFactory;

public class MergeTableCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(MergeTableCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MergeTableCommand.class);
    protected IMergeTableDialog customDialog;
    protected IMergeTableDialogFactory dialogFactory = null;
    protected HashMap<String, TableColumnInfo[]> _allTables;

    public MergeTableCommand(ISession session, IDatabaseObjectInfo[] info, IMergeTableDialogFactory dialogFactory) {
        super(session, info);
        this.dialogFactory = dialogFactory;
    }

    @Override
    protected void onExecute() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            return;
        }
        this.showCustomDialog();
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException, SQLException {
        ArrayList<String> results = new ArrayList<String>();
        ISQLDatabaseMetaData md = this._session.getMetaData();
        String catalog = this._info[0].getCatalogName();
        String schema = this._info[0].getSchemaName();
        DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(catalog, schema);
        String destinationTable = this._info[0].getSimpleName();
        String sourceTable = this.customDialog.getReferencedTable();
        TableColumnInfo[] mergedTableColumnInfos = this._allTables.get(sourceTable);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("MergedTable = " + sourceTable));
            s_log.debug((Object)("Is Null " + (mergedTableColumnInfos == null)));
            this.logDialogInfo();
        }
        if (mergedTableColumnInfos != null) {
            for (TableColumnInfo mc : mergedTableColumnInfos) {
                CaseInsensitiveString cistr = new CaseInsensitiveString(mc.getColumnName());
                if (!this.customDialog.getMergeColumns().contains(cistr)) continue;
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("Schema: " + mc.getSchemaName()));
                }
                TableColumnInfo columnInNewTable = new TableColumnInfo(mc.getCatalogName(), mc.getSchemaName(), destinationTable, mc.getColumnName(), mc.getDataType(), JDBCTypeMapper.getJdbcTypeName((int)mc.getDataType()), mc.getColumnSize(), mc.getDecimalDigits(), mc.getRadix(), mc.isNullAllowed(), mc.getRemarks(), mc.getDefaultValue(), mc.getOctetLength(), mc.getOrdinalPosition(), "YES", null, md);
                String[] statements = this._dialect.getAddColumnSQL(columnInNewTable, qualifier, this._sqlPrefs);
                results.addAll(Arrays.asList(statements));
            }
        }
        if (this.customDialog.isMergeData()) {
            List<String> updateResults = null;
            updateResults = this._dialect.supportsCorrelatedSubQuery() ? this.getCorrelatedSubqueryUpdateSqls(qualifier, destinationTable, sourceTable) : this.getSimpleUpdateSqls(qualifier, destinationTable, sourceTable);
            results.addAll(updateResults);
        }
        return results.toArray(new String[0]);
    }

    private List<String> getCorrelatedSubqueryUpdateSqls(DatabaseObjectQualifier qualifier, String destinationTable, String sourceTable) {
        Vector<String> mergeCols = this.customDialog.getMergeColumns();
        String[] mergeColumns = new String[mergeCols.size()];
        for (int i = 0; i < mergeCols.size(); ++i) {
            mergeColumns[i] = mergeCols.elementAt(i);
        }
        Vector<String[]> whereDataColumns = this.customDialog.getWhereDataColumns();
        String[] whereColumns = new String[whereDataColumns.size()];
        String[] whereValues = new String[whereDataColumns.size()];
        for (int i = 0; i < whereDataColumns.size(); ++i) {
            String[] whereDataColumn = whereDataColumns.elementAt(i);
            whereColumns[i] = whereDataColumn[0];
            whereValues[i] = whereDataColumn[1];
        }
        String[] result = this._dialect.getUpdateSQL(destinationTable, mergeColumns, null, new String[]{sourceTable}, whereColumns, whereValues, qualifier, this._sqlPrefs);
        return Arrays.asList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSimpleUpdateSqls(DatabaseObjectQualifier qualifier, String table, String mergedTable) {
        ArrayList<String> updateResults;
        block13: {
            updateResults = new ArrayList<String>();
            StringBuilder columnNamesSelectStmt = new StringBuilder();
            for (String string : this.customDialog.getMergeColumns()) {
                columnNamesSelectStmt.append(this.quoteColumnName(string));
                columnNamesSelectStmt.append(", ");
            }
            columnNamesSelectStmt.delete(columnNamesSelectStmt.length() - 2, columnNamesSelectStmt.length());
            StringBuilder columnIDSelect = new StringBuilder();
            for (String[] whereRow : this.customDialog.getWhereDataColumns()) {
                columnIDSelect.append(this.quoteColumnName(whereRow[1]));
                columnIDSelect.append(", ");
            }
            columnIDSelect.delete(columnIDSelect.length() - 2, columnIDSelect.length());
            String[] stringArray = this.customDialog.getMergeColumns().toArray(new String[this.customDialog.getMergeColumns().size()]);
            String qualifiedTableName = this._dialect.getQualifiedIdentifier(mergedTable, qualifier, this._sqlPrefs);
            StringBuilder dataQueryBuilder = new StringBuilder();
            dataQueryBuilder.append("SELECT ");
            dataQueryBuilder.append(columnNamesSelectStmt.toString());
            dataQueryBuilder.append(", ").append(columnIDSelect.toString());
            dataQueryBuilder.append(" FROM ");
            dataQueryBuilder.append(qualifiedTableName);
            String dataQuery = dataQueryBuilder.toString();
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = this._session.getSQLConnection().createStatement();
                if (s_log.isDebugEnabled()) {
                    s_log.debug((Object)("generateSQLStatements - running dataQuery: " + dataQuery));
                }
                rs = stmt.executeQuery(dataQuery);
                ArrayList<String> whereColumns = new ArrayList<String>();
                ArrayList<String> whereValues = new ArrayList<String>();
                while (rs.next()) {
                    String[] updateSqls;
                    ArrayList<String> rowColumns = new ArrayList<String>();
                    ArrayList<CallSite> rowData = new ArrayList<CallSite>();
                    for (int i = 1; i <= this.customDialog.getMergeColumns().size(); ++i) {
                        String value = rs.getString(i);
                        if (rs.wasNull()) continue;
                        rowColumns.add(stringArray[i - 1]);
                        rowData.add((CallSite)((Object)("'" + value + "'")));
                    }
                    if (this.customDialog.getWhereDataColumns().size() > 0) {
                        whereColumns = new ArrayList();
                        whereValues = new ArrayList();
                        int count = 0;
                        for (String[] whereRow : this.customDialog.getWhereDataColumns()) {
                            StringBuilder whereColumn = new StringBuilder();
                            StringBuilder whereValue = new StringBuilder();
                            whereColumn.append(table).append(".").append(whereRow[0]);
                            whereValue.append("'").append(rs.getString(this.customDialog.getMergeColumns().size() + ++count)).append("'");
                            whereColumns.add(whereColumn.toString());
                            whereValues.add(whereValue.toString());
                        }
                    }
                    for (String sql : updateSqls = this._dialect.getUpdateSQL(table, rowColumns.toArray(new String[rowColumns.size()]), rowData.toArray(new String[rowData.size()]), new String[]{mergedTable}, whereColumns.toArray(new String[whereColumns.size()]), whereValues.toArray(new String[whereValues.size()]), qualifier, this._sqlPrefs)) {
                        updateResults.add(sql);
                    }
                    rowData.clear();
                }
                SQLUtilities.closeResultSet((ResultSet)rs);
            }
            catch (SQLException e) {
                s_log.error((Object)("generateSQLStatements: Unexpected exception: " + e.getMessage()), (Throwable)e);
                break block13;
            }
            finally {
                SQLUtilities.closeResultSet(rs);
                SQLUtilities.closeStatement((Statement)stmt);
            }
            SQLUtilities.closeStatement((Statement)stmt);
        }
        return updateResults;
    }

    private String quoteColumnName(String columnName) {
        StringBuilder result = new StringBuilder();
        if (this._sqlPrefs.isQuoteIdentifiers()) {
            result.append("\"");
            result.append(columnName);
            result.append("\"");
        } else {
            result.append(columnName);
        }
        return result.toString();
    }

    @Override
    protected void executeScript(String script) {
        CommandExecHandler handler = new CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MergeTableCommand.this.customDialog.setVisible(false);
                        MergeTableCommand.this.customDialog.dispose();
                        MergeTableCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialect) {
        boolean result = true;
        result = result && dialect.supportsUpdate();
        result = result && dialect.supportsAddColumn();
        return result;
    }

    private void showCustomDialog() throws SQLException {
        ITableInfo selectedTable = (ITableInfo)this._info[0];
        ITableInfo[] tables = this._session.getSchemaInfo().getITableInfos(selectedTable.getCatalogName(), selectedTable.getSchemaName());
        TableColumnInfo[] tableColumnInfos = this._session.getMetaData().getColumnInfo(selectedTable);
        this._allTables = new HashMap();
        for (ITableInfo table : tables) {
            TableColumnInfo[] columns = this.safeGetColumns(table);
            if (table.getDatabaseObjectType() != DatabaseObjectType.TABLE || table == selectedTable || columns == null) continue;
            this._allTables.put(table.getSimpleName(), columns);
        }
        this.customDialog = this.dialogFactory.createDialog(selectedTable.getSimpleName(), tableColumnInfos, this._allTables);
        this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
        this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(this.customDialog));
        this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, this.customDialog));
        this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)this._session));
        this.customDialog.setVisible(true);
    }

    private TableColumnInfo[] safeGetColumns(ITableInfo table) {
        TableColumnInfo[] result;
        block2: {
            result = null;
            try {
                result = this._session.getMetaData().getColumnInfo(table);
            }
            catch (SQLException e) {
                if (!s_log.isInfoEnabled()) break block2;
                s_log.info((Object)("safeGetColumns: unable to get columns for table " + table.getSimpleName() + ": " + e.getMessage()), (Throwable)e);
            }
        }
        return result;
    }

    private void logDialogInfo() {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("getReferencedTable: " + this.customDialog.getReferencedTable()));
            s_log.debug((Object)"getWhereDataColumns: ");
            for (Object[] objectArray : this.customDialog.getWhereDataColumns()) {
                s_log.debug((Object)("whereDataColumns Array: " + Arrays.toString(objectArray)));
            }
            for (String string : this.customDialog.getMergeColumns()) {
                s_log.debug((Object)("mergeColumn: " + string));
            }
        }
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = s_stringMgr.getString("MergeTableCommand.sqlDialogTitle");
    }
}

