/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import net.sourceforge.squirrel_sql.client.gui.db.ColumnDetailDialog;
import net.sourceforge.squirrel_sql.client.gui.db.ColumnListDialog;
import net.sourceforge.squirrel_sql.client.gui.db.IDisposableDialog;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.fromhibernate3_2_4_sp1.HibernateException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.DBUtil;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.CommandExecHandler;

public class ModifyColumnCommand
extends AbstractRefactoringCommand {
    private static final ILogger s_log = LoggerController.createLogger(ModifyColumnCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ModifyColumnCommand.class);
    private ColumnListDialog listDialog = null;
    protected ColumnDetailDialog customDialog;
    private TableColumnInfo columnToModify = null;

    public ModifyColumnCommand(ISession session, IDatabaseObjectInfo[] info) {
        super(session, info);
    }

    @Override
    protected void onExecute() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            s_log.error((Object)("onExecute: _info[0] isn't an instance of ITableInfo: class=" + this._info[0].getClass().getName()));
            return;
        }
        ITableInfo ti = (ITableInfo)this._info[0];
        TableColumnInfo[] columns = this._session.getSQLConnection().getSQLMetaData().getColumnInfo(ti);
        if (columns.length == 1) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Table has exactly one column, so presenting the modify column dialog");
            }
            this.columnToModify = columns[0];
            this.showCustomDialog();
        } else {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Table has exactly " + columns.length + " columns, so presenting the column list selection dialog"));
            }
            this.listDialog = new ColumnListDialog(columns, 1);
            this.listDialog.setTableName(ti.getQualifiedName());
            this.listDialog.setSingleSelection();
            this.listDialog.addColumnSelectionListener((ActionListener)new ColumnListSelectionActionListener());
            this.listDialog.setLocationRelativeTo((Component)SessionUtils.getOwningFrame((ISession)this._session));
            this.listDialog.setVisible(true);
        }
    }

    @Override
    protected String[] generateSQLStatements() {
        String[] result = null;
        TableColumnInfo to = this.customDialog.getColumnInfo();
        String dbName = this.customDialog.getSelectedDBName();
        this._dialect = DialectFactory.getDialect((String)dbName);
        DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(this._info[0].getCatalogName(), this._info[0].getSchemaName());
        try {
            result = DBUtil.getAlterSQLForColumnChange(this.columnToModify, to, this._dialect, qualifier, this._sqlPrefs);
        }
        catch (HibernateException e1) {
            JOptionPane.showMessageDialog((Component)this.customDialog, s_stringMgr.getString("AbstractRefactoringCommand.unsupportedTypeMsg", new Object[]{this._dialect.getDisplayName(), this.customDialog.getSelectedTypeName()}), AbstractRefactoringCommand.i18n.UNSUPPORTED_TYPE_TITLE, 0);
        }
        catch (UnsupportedOperationException e2) {
            this._session.showErrorMessage(e2.getMessage());
        }
        return result;
    }

    @Override
    protected void executeScript(String script) {
        CommandExecHandler handler = new CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ModifyColumnCommand.this.customDialog.setVisible(false);
                        ModifyColumnCommand.this.customDialog.dispose();
                        ModifyColumnCommand.this._session.getSchemaInfo().reload(ModifyColumnCommand.this._info[0]);
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialectExt) {
        return true;
    }

    private void showCustomDialog() {
        this.customDialog = new ColumnDetailDialog(1);
        this.customDialog.setExistingColumnInfo(this.columnToModify);
        this.customDialog.setTableName(this._info[0].getQualifiedName());
        this.customDialog.setSelectedDialect(this._dialect.getDisplayName());
        this.customDialog.addExecuteListener((ActionListener)new AbstractRefactoringCommand.ExecuteListener());
        this.customDialog.addEditSQLListener((ActionListener)new AbstractRefactoringCommand.EditSQLListener((IDisposableDialog)this.customDialog));
        this.customDialog.addShowSQLListener((ActionListener)new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, (IDisposableDialog)this.customDialog));
        this.customDialog.setLocationRelativeTo((Component)SessionUtils.getOwningFrame((ISession)this._session));
        this.customDialog.setVisible(true);
    }

    private class ColumnListSelectionActionListener
    implements ActionListener {
        private ColumnListSelectionActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ModifyColumnCommand.this.listDialog == null) {
                return;
            }
            ModifyColumnCommand.this.listDialog.dispose();
            TableColumnInfo[] colInfos = ModifyColumnCommand.this.listDialog.getSelectedColumnList();
            if (colInfos == null || colInfos.length != 1) {
                ModifyColumnCommand.this._session.showMessage(i18n.MODIFY_ONE_COL_MSG);
                return;
            }
            ModifyColumnCommand.this.columnToModify = colInfos[0];
            ModifyColumnCommand.this.showCustomDialog();
        }
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = s_stringMgr.getString("ModifyColumnCommand.sqlDialogTitle");
        public static final String MODIFY_ONE_COL_MSG = s_stringMgr.getString("ModifyColumnCommand.modifyOneColMsg");
    }
}

