/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.sql.SQLException;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.CommandExecHandler;

class NoAutoCommitCommandExecHandler
extends CommandExecHandler {
    protected boolean _origAutoCommit;
    private ISession _session;

    public NoAutoCommitCommandExecHandler(ISession session) throws SQLException {
        super(session);
        this._session = session;
        this._origAutoCommit = this._session.getSQLConnection().getAutoCommit();
        this._session.getSQLConnection().setAutoCommit(false);
    }

    public void sqlCloseExecutionHandler(ArrayList<String> errMsgs, String lastExecutedStatement) {
        super.sqlCloseExecutionHandler(errMsgs, lastExecutedStatement);
        if (this._origAutoCommit) {
            if (this.exceptionEncountered()) {
                this._session.rollback();
            } else {
                this._session.commit();
            }
            try {
                this._session.getSQLConnection().setAutoCommit(true);
            }
            catch (SQLException e) {
                this._session.showErrorMessage((Throwable)e);
            }
        }
    }
}

