/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.PrimaryKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.databasemetadata.SQLDatabaseMetaData;

public class PrimaryKeyCommandUtility {
    protected ISession _session;
    protected final IDatabaseObjectInfo[] _info;

    public PrimaryKeyCommandUtility(ISession session, IDatabaseObjectInfo[] info) {
        if (session == null) {
            throw new IllegalArgumentException("ISession cannot be null");
        }
        if (info == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo[] cannot be null");
        }
        this._session = session;
        this._info = info;
    }

    protected boolean tableHasPrimaryKey() throws SQLException {
        if (!(this._info[0] instanceof ITableInfo)) {
            return false;
        }
        ITableInfo ti = (ITableInfo)this._info[0];
        SQLDatabaseMetaData md = this._session.getSQLConnection().getSQLMetaData();
        PrimaryKeyInfo[] pks = md.getPrimaryKey(ti);
        return pks != null && pks.length > 0;
    }
}

