/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.commands;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.session.ISQLExecuterHandler;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SQLExecuterTask;
import net.sourceforge.squirrel_sql.client.session.SessionUtils;
import net.sourceforge.squirrel_sql.fw.dialects.DatabaseObjectQualifier;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.UserCancelledOperationException;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.AbstractRefactoringCommand;
import net.sourceforge.squirrel_sql.plugins.refactoring.commands.CommandExecHandler;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.RenameTableDialog;

public class RenameViewCommand
extends AbstractRefactoringCommand {
    private final ILogger s_log = LoggerController.createLogger(RenameViewCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RenameViewCommand.class);
    protected RenameTableDialog customDialog;

    public RenameViewCommand(ISession session, IDatabaseObjectInfo[] dbInfo) {
        super(session, dbInfo);
    }

    @Override
    protected void onExecute() {
        this.showCustomDialog();
    }

    @Override
    protected String[] generateSQLStatements() throws UserCancelledOperationException {
        String[] result = null;
        try {
            DatabaseObjectQualifier qualifier = new DatabaseObjectQualifier(this._info[0].getCatalogName(), this._info[0].getSchemaName());
            String viewName = this._info[0].getSimpleName();
            String newViewName = this.customDialog.getNewSimpleName();
            if (this._dialect.supportsRenameView()) {
                result = this._dialect.getRenameViewSQL(viewName, newViewName, qualifier, this._sqlPrefs);
            } else {
                String viewDefSql = this._dialect.getViewDefinitionSQL(viewName, qualifier, this._sqlPrefs);
                String viewDefinition = this.getViewDef(newViewName, viewDefSql);
                String dropOldViewSql = this._dialect.getDropViewSQL(viewName, false, qualifier, this._sqlPrefs);
                result = new String[]{viewDefinition, dropOldViewSql};
            }
        }
        catch (UnsupportedOperationException e2) {
            this._session.showMessage(s_stringMgr.getString("RenameViewCommand.unsupportedOperationMsg", new Object[]{this._dialect.getDisplayName()}));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getViewDef(String newViewName, String viewDefQuery) {
        Statement stmt;
        ResultSet rs;
        Object result;
        block4: {
            result = null;
            rs = null;
            stmt = null;
            try {
                int asIndex;
                stmt = this._session.getSQLConnection().createStatement();
                rs = stmt.executeQuery(viewDefQuery);
                if (!rs.next() || (asIndex = ((String)(result = rs.getString(1))).toUpperCase().indexOf("AS")) == -1) break block4;
                result = "CREATE VIEW " + newViewName + " AS " + ((String)result).substring(asIndex + 2);
            }
            catch (SQLException e) {
                try {
                    this.s_log.error((Object)("getViewDef: unexpected exception - " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtilities.closeResultSet(rs);
                    SQLUtilities.closeStatement((Statement)stmt);
                    throw throwable;
                }
                SQLUtilities.closeResultSet((ResultSet)rs);
                SQLUtilities.closeStatement((Statement)stmt);
            }
        }
        SQLUtilities.closeResultSet((ResultSet)rs);
        SQLUtilities.closeStatement((Statement)stmt);
        return result;
    }

    @Override
    protected void executeScript(String script) {
        CommandExecHandler handler = new CommandExecHandler(this._session);
        SQLExecuterTask executer = new SQLExecuterTask(this._session, script, (ISQLExecuterHandler)handler);
        executer.run();
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RenameViewCommand.this.customDialog.setVisible(false);
                        RenameViewCommand.this.customDialog.dispose();
                        RenameViewCommand.this._session.getSchemaInfo().reloadAll();
                    }
                });
            }
        });
    }

    @Override
    protected boolean isRefactoringSupportedForDialect(HibernateDialect dialect) {
        return dialect.supportsRenameView() || dialect.supportsViewDefinition();
    }

    private void showCustomDialog() {
        this._session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        RenameViewCommand.this.customDialog = new RenameTableDialog(RenameViewCommand.this._info, 1, SessionUtils.getOwningFrame((ISession)RenameViewCommand.this._session));
                        RenameViewCommand.this.customDialog.addExecuteListener(new AbstractRefactoringCommand.ExecuteListener());
                        RenameViewCommand.this.customDialog.addEditSQLListener(new AbstractRefactoringCommand.EditSQLListener(RenameViewCommand.this.customDialog));
                        RenameViewCommand.this.customDialog.addShowSQLListener(new AbstractRefactoringCommand.ShowSQLListener(i18n.SHOWSQL_DIALOG_TITLE, RenameViewCommand.this.customDialog));
                        RenameViewCommand.this.customDialog.setLocationRelativeTo(SessionUtils.getOwningFrame((ISession)RenameViewCommand.this._session));
                        RenameViewCommand.this.customDialog.setVisible(true);
                    }
                });
            }
        });
    }

    static interface i18n {
        public static final String SHOWSQL_DIALOG_TITLE = s_stringMgr.getString("RenameViewCommand.sqlDialogTitle");
    }
}

