/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.sourceforge.squirrel_sql.client.gui.db.IDisposableDialog;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public abstract class AbstractRefactoringDialog
extends JDialog
implements IDisposableDialog {
    private JTextField tableNameTextField = null;
    protected JButton executeButton = null;
    protected JButton editSQLButton = null;
    protected JButton showSQLButton = null;
    protected JButton cancelButton = null;
    protected GridBagConstraints c = null;
    protected final Dimension mediumField = new Dimension(126, 20);
    protected JPanel pane = null;
    protected final EmptyBorder emptyBorder = new EmptyBorder(new Insets(5, 5, 5, 5));
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AbstractRefactoringDialog.class);

    public AbstractRefactoringDialog(Frame owningFrame) {
        super(owningFrame);
        this.defaultInit();
    }

    public void setTableName(String tableName) {
        this.tableNameTextField.setText(tableName);
    }

    public String getTableName() {
        return this.tableNameTextField.getText();
    }

    public void addShowSQLListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.showSQLButton.addActionListener(listener);
    }

    public void addEditSQLListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.editSQLButton.addActionListener(listener);
    }

    public void addExecuteListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.executeButton.addActionListener(listener);
    }

    public void _setVisible(boolean visible) {
        super.setVisible(visible);
    }

    @Override
    public void setVisible(final boolean visible) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractRefactoringDialog.this._setVisible(visible);
            }
        });
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AbstractRefactoringDialog.this.executeButton.requestFocus();
            }
        });
    }

    protected GridBagConstraints getLabelConstraints(GridBagConstraints c) {
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 12;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        return c;
    }

    protected GridBagConstraints getFieldConstraints(GridBagConstraints c) {
        ++c.gridx;
        c.anchor = 18;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        return c;
    }

    protected JLabel getBorderedLabel(String text, Border border) {
        JLabel result = new JLabel(text);
        result.setBorder(border);
        result.setPreferredSize(new Dimension(115, 20));
        result.setHorizontalAlignment(4);
        return result;
    }

    protected void defaultInit() {
        super.setModal(true);
        this.setSize(425, 250);
        this.pane = new JPanel();
        this.pane.setLayout(new GridBagLayout());
        this.pane.setBorder(new EmptyBorder(10, 0, 0, 30));
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = -1;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.pane, "Center");
        contentPane.add((Component)this.getButtonPanel(), "South");
        GUIUtils.enableCloseByEscape((JDialog)this);
    }

    protected JPanel getButtonPanel() {
        JPanel result = new JPanel();
        this.executeButton = new JButton(i18n.EXECUTE_BUTTON_LABEL);
        result.add(this.executeButton);
        this.editSQLButton = new JButton(i18n.EDIT_BUTTON_LABEL);
        result.add(this.editSQLButton);
        this.showSQLButton = new JButton(i18n.SHOWSQL_BUTTON_LABEL);
        result.add(this.showSQLButton);
        this.cancelButton = new JButton(i18n.CANCEL_BUTTON_LABEL);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractRefactoringDialog.this.setVisible(false);
                AbstractRefactoringDialog.this.dispose();
            }
        });
        result.add(this.cancelButton);
        return result;
    }

    protected void enable(JButton button) {
        if (button != null) {
            button.setEnabled(true);
        }
    }

    protected void disable(JButton button) {
        if (button != null) {
            button.setEnabled(false);
        }
    }

    protected void enableAllButtons(boolean enable) {
        if (enable) {
            this.enable(this.executeButton);
            this.enable(this.editSQLButton);
            this.enable(this.showSQLButton);
        } else {
            this.disable(this.executeButton);
            this.disable(this.editSQLButton);
            this.disable(this.showSQLButton);
        }
    }

    protected static interface i18n {
        public static final String CANCEL_BUTTON_LABEL = s_stringMgr.getString("AbstractRefactoringDialog.cancelButtonLabel");
        public static final String EDIT_BUTTON_LABEL = s_stringMgr.getString("AbstractRefactoringDialog.editButtonLabel");
        public static final String EXECUTE_BUTTON_LABEL = s_stringMgr.getString("AbstractRefactoringDialog.executeButtonLabel");
        public static final String SHOWSQL_BUTTON_LABEL = s_stringMgr.getString("AbstractRefactoringDialog.showButtonLabel");
        public static final String TABLE_NAME_LABEL = s_stringMgr.getString("AbstractRefactoringDialog.tableNameLabel");
    }
}

