/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringDialog;

public class AddAutoIncrementDialog
extends AbstractRefactoringDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddAutoIncrementDialog.class);
    private final TableColumnInfo dbInfo;

    public AddAutoIncrementDialog(TableColumnInfo dbInfo, Frame owningFrame) {
        super(owningFrame);
        this.dbInfo = dbInfo;
        this.setTitle(s_stringMgr.getString("AddAutoIncrementDialog.title", new Object[]{dbInfo.getColumnName()}));
        this.init();
    }

    protected void init() {
        this.setSize(400, 200);
        JLabel catalogLabel = this.getBorderedLabel(i18n.CATALOG_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)catalogLabel, this.getLabelConstraints(this.c));
        JTextField catalogTF = new JTextField();
        catalogTF.setPreferredSize(this.mediumField);
        catalogTF.setEditable(false);
        catalogTF.setText(this.dbInfo.getCatalogName());
        this.pane.add((Component)catalogTF, this.getFieldConstraints(this.c));
        JLabel schemaLabel = this.getBorderedLabel(i18n.SCHEMA_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)schemaLabel, this.getLabelConstraints(this.c));
        JTextField schemaTF = new JTextField();
        schemaTF.setPreferredSize(this.mediumField);
        schemaTF.setEditable(false);
        schemaTF.setText(this.dbInfo.getSchemaName());
        this.pane.add((Component)schemaTF, this.getFieldConstraints(this.c));
        JLabel tableLabel = this.getBorderedLabel(i18n.TABLE_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)tableLabel, this.getLabelConstraints(this.c));
        JTextField tableTF = new JTextField();
        tableTF.setPreferredSize(this.mediumField);
        tableTF.setEditable(false);
        tableTF.setText(this.dbInfo.getTableName());
        this.pane.add((Component)tableTF, this.getFieldConstraints(this.c));
        JLabel columnLabel = this.getBorderedLabel(i18n.COLUMN_LABEL + " ", this.emptyBorder);
        columnLabel.setVerticalAlignment(1);
        this.pane.add((Component)columnLabel, this.getLabelConstraints(this.c));
        JTextField columnTF = new JTextField(this.dbInfo.getColumnName());
        columnTF.setPreferredSize(this.mediumField);
        columnTF.setEditable(false);
        this.pane.add((Component)columnTF, this.getFieldConstraints(this.c));
        this.executeButton.setRequestFocusEnabled(true);
    }

    public static void main(String[] args) {
        String catalog = null;
        String schema = "public";
        String employeIdentifactionTable = "EmployeeIdentification";
        String[] employeeColumns = new String[]{"EmployeeNumber", "Name", "PhoneNumber"};
        TableColumnInfo newColumn = new TableColumnInfo(catalog, schema, employeIdentifactionTable, employeeColumns[0], 12, JDBCTypeMapper.getJdbcTypeName((int)12), 30, 0, 0, 1, null, null, 0, 1, "YES", null, null);
        new AddAutoIncrementDialog(newColumn, null).setVisible(true);
    }

    static interface i18n {
        public static final String CATALOG_LABEL = s_stringMgr.getString("AddAutoIncrementDialog.catalogLabel");
        public static final String SCHEMA_LABEL = s_stringMgr.getString("AddAutoIncrementDialog.schemaLabel");
        public static final String TABLE_LABEL = s_stringMgr.getString("AddAutoIncrementDialog.tableLabel");
        public static final String COLUMN_LABEL = s_stringMgr.getString("AddAutoIncrementDialog.columnLabel");
    }
}

