/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringTabbedDialog;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AddLookupTableColumnTableModel;

public class AddLookupTableDialog
extends AbstractRefactoringTabbedDialog {
    private static final ILogger s_log = LoggerController.createLogger(AddLookupTableDialog.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddLookupTableDialog.class);
    private SourceTab _sourceTab;
    private LookupTab _lookupTab;
    private BehaviourTab _behaviourTab;
    private final String _tableName;
    private final String[] _columnNames;
    public static final int MODE_KEEP = 1;
    public static final int MODE_REPLACE = 2;

    public AddLookupTableDialog(String tableName, String[] columnNames) {
        super(new Dimension(430, 350));
        this._tableName = tableName;
        this._columnNames = columnNames;
        this.init();
    }

    private void init() {
        this._sourceTab = new SourceTab();
        this._lookupTab = new LookupTab();
        this._behaviourTab = new BehaviourTab();
        this.pane.addTab(i18n.SOURCE_LABEL, this._sourceTab);
        this.pane.addTab(i18n.LOOKUP_LABEL, this._lookupTab);
        this.setAllButtonEnabled(false);
        this.setTitle(i18n.DIALOG_TITLE);
    }

    public String getSourceColumn() {
        return this._sourceTab.getColumn();
    }

    public String getForeignKeyName() {
        return this._sourceTab.getForeignKey();
    }

    public int getMode() {
        return this._sourceTab.getMode();
    }

    public String getLookupTableName() {
        return this._lookupTab.getTableName();
    }

    public String getLookupPrimaryKey() {
        return this._lookupTab.getPrimaryKey();
    }

    public String getLookupSecondColumn() {
        return this._lookupTab.getSecondColumn();
    }

    public boolean getDropCascade() {
        return this._behaviourTab.getDropCascade();
    }

    private JPanel emptyBorderPanel(JComponent c) {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setBorder(this.emptyBorder);
        panel.add(c);
        return panel;
    }

    private JTextField getSizedTextField(Dimension mediumField) {
        JTextField result = new JTextField();
        result.setPreferredSize(mediumField);
        return result;
    }

    public static void main(String[] args) {
        final AddLookupTableDialog dialog = new AddLookupTableDialog("City", new String[]{"CityNr", "Name", "State", "Country"});
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog.setVisible(true);
            }
        });
    }

    private class BehaviourTab
    extends JPanel {
        private JCheckBox _dropCascade;

        public BehaviourTab() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this._dropCascade = new JCheckBox(i18n.BEHAVIOUR_DROP_CASCADE_LABEL);
            this._dropCascade.setToolTipText(i18n.BEHAVIOUR_DROP_CASCADE_TOOLIP);
            JPanel dropPanel = new JPanel(new GridLayout(1, 1));
            dropPanel.setBorder(BorderFactory.createTitledBorder(i18n.BEHAVIOUR_DROP_LABEL));
            dropPanel.add(this._dropCascade);
            this.add(dropPanel);
        }

        public boolean getDropCascade() {
            return this._dropCascade.isSelected();
        }
    }

    private class LookupTab
    extends JPanel {
        private JTextField _tableTextField;
        private final JTable _columnTable = new JTable();
        private final AddLookupTableColumnTableModel _columnTableModel = new AddLookupTableColumnTableModel();

        public LookupTab() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(10, 0, 0, 30));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = -1;
            JLabel tableLabel = AddLookupTableDialog.this.getBorderedLabel(i18n.LOOKUP_TABLE_LABEL + " ", AddLookupTableDialog.this.emptyBorder);
            this.add((Component)tableLabel, AddLookupTableDialog.this.getLabelConstraints(gbc));
            this._tableTextField = AddLookupTableDialog.this.getSizedTextField(AddLookupTableDialog.this.mediumField);
            this._tableTextField.setEditable(true);
            this.add((Component)AddLookupTableDialog.this.emptyBorderPanel(this._tableTextField), AddLookupTableDialog.this.getFieldConstraints(gbc));
            JLabel columnLabel = AddLookupTableDialog.this.getBorderedLabel(i18n.LOOKUP_COLUMNS_LABEL + " ", AddLookupTableDialog.this.emptyBorder);
            this.add((Component)columnLabel, AddLookupTableDialog.this.getLabelConstraints(gbc));
            this._columnTable.setModel(this._columnTableModel);
            this._columnTable.setRowSelectionAllowed(true);
            this._columnTable.setColumnSelectionAllowed(false);
            this._columnTable.setCellSelectionEnabled(true);
            this._columnTable.getTableHeader().setReorderingAllowed(false);
            this._columnTable.setSelectionMode(0);
            JScrollPane columnScrollPane = new JScrollPane(this._columnTable);
            gbc = AddLookupTableDialog.this.getFieldConstraints(gbc);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            this.add((Component)AddLookupTableDialog.this.emptyBorderPanel(columnScrollPane), gbc);
        }

        public void onSourceColumnChange(String column) {
            this._tableTextField.setText(column);
            this.onChange(column, AddLookupTableDialog.this._sourceTab.getMode());
        }

        public void onSourceModeChange(int mode) {
            this.onChange(AddLookupTableDialog.this._sourceTab.getColumn(), mode);
        }

        private void onChange(String column, int mode) {
            if (mode == 1) {
                this._columnTableModel.clear();
                this._columnTableModel.addRow(new String[]{column, "Primary Key"});
            } else if (mode == 2) {
                this._columnTableModel.clear();
                this._columnTableModel.addRow(new String[]{column + "Nr", "Primary Key"});
                this._columnTableModel.addRow(new String[]{column, ""});
            }
        }

        public String getTableName() {
            return this._tableTextField.getText();
        }

        public String getPrimaryKey() {
            if (this._columnTableModel.getRowCount() > 0) {
                return String.valueOf(this._columnTableModel.getValueAt(0, 0));
            }
            return null;
        }

        public String getSecondColumn() {
            if (this._columnTableModel.getRowCount() > 1) {
                return String.valueOf(this._columnTableModel.getValueAt(1, 0));
            }
            return null;
        }
    }

    private class SourceTab
    extends JPanel {
        private JList _columnList;
        private JTextField _foreignKeyTextField;
        private ButtonGroup _modeButtonGroup;
        private JRadioButton _keepRadioButton;
        private JRadioButton _replaceRadioButton;

        public SourceTab() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this.setBorder(new EmptyBorder(10, 0, 0, 30));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = -1;
            JLabel tableLabel = AddLookupTableDialog.this.getBorderedLabel(i18n.SOURCE_TABLE_LABEL + " ", AddLookupTableDialog.this.emptyBorder);
            this.add((Component)tableLabel, AddLookupTableDialog.this.getLabelConstraints(gbc));
            JTextField tableTextField = AddLookupTableDialog.this.getSizedTextField(AddLookupTableDialog.this.mediumField);
            tableTextField.setText(AddLookupTableDialog.this._tableName);
            tableTextField.setEditable(false);
            this.add((Component)AddLookupTableDialog.this.emptyBorderPanel(tableTextField), AddLookupTableDialog.this.getFieldConstraints(gbc));
            JLabel columnLabel = AddLookupTableDialog.this.getBorderedLabel(i18n.SOURCE_COLUMN_LABEL + " ", AddLookupTableDialog.this.emptyBorder);
            this.add((Component)columnLabel, AddLookupTableDialog.this.getLabelConstraints(gbc));
            this._columnList = new JList<String>(AddLookupTableDialog.this._columnNames);
            this._columnList.addListSelectionListener(new ColumnListSelectionListener());
            this._columnList.setSelectionMode(0);
            JScrollPane columnScrollPane = new JScrollPane(this._columnList);
            gbc = AddLookupTableDialog.this.getFieldConstraints(gbc);
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            this.add((Component)AddLookupTableDialog.this.emptyBorderPanel(columnScrollPane), gbc);
            JLabel foreignKeyLabel = AddLookupTableDialog.this.getBorderedLabel(i18n.SOURCE_FOREIGNKEY_LABEL + " ", AddLookupTableDialog.this.emptyBorder);
            this.add((Component)foreignKeyLabel, AddLookupTableDialog.this.getLabelConstraints(gbc));
            this._foreignKeyTextField = AddLookupTableDialog.this.getSizedTextField(AddLookupTableDialog.this.mediumField);
            this.add((Component)AddLookupTableDialog.this.emptyBorderPanel(this._foreignKeyTextField), AddLookupTableDialog.this.getFieldConstraints(gbc));
            JLabel modeLabel = AddLookupTableDialog.this.getBorderedLabel(i18n.SOURCE_MODE_LABEL + " ", AddLookupTableDialog.this.emptyBorder);
            this.add((Component)modeLabel, AddLookupTableDialog.this.getLabelConstraints(gbc));
            this._keepRadioButton = new JRadioButton(i18n.SOURCE_MODE_KEEP_LABEL);
            this._keepRadioButton.setToolTipText(i18n.SOURCE_MODE_KEEP_TOOLTIP);
            this._keepRadioButton.setSelected(true);
            this._keepRadioButton.addItemListener(new ModeItemListener());
            this._replaceRadioButton = new JRadioButton(i18n.SOURCE_MODE_REPLACE_LABEL);
            this._replaceRadioButton.setToolTipText(i18n.SOURCE_MODE_REPLACE_TOOLTIP);
            this._replaceRadioButton.addItemListener(new ModeItemListener());
            this._modeButtonGroup = new ButtonGroup();
            this._modeButtonGroup.add(this._keepRadioButton);
            this._modeButtonGroup.add(this._replaceRadioButton);
            JPanel modePanel = new JPanel(new GridLayout(2, 1));
            modePanel.add(this._keepRadioButton);
            modePanel.add(this._replaceRadioButton);
            this.add((Component)modePanel, AddLookupTableDialog.this.getFieldConstraints(gbc));
        }

        public String getColumn() {
            return String.valueOf(this._columnList.getSelectedValue());
        }

        public String getForeignKey() {
            return this._foreignKeyTextField.getText();
        }

        public int getMode() {
            if (this._keepRadioButton.isSelected()) {
                return 1;
            }
            if (this._replaceRadioButton.isSelected()) {
                return 2;
            }
            throw new IllegalStateException("There should always be at least one mode selected!");
        }

        private class ModeItemListener
        implements ItemListener {
            private ModeItemListener() {
            }

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    AddLookupTableDialog.this._lookupTab.onSourceModeChange(SourceTab.this.getMode());
                    if (e.getItem().equals(SourceTab.this._replaceRadioButton)) {
                        AddLookupTableDialog.this.pane.addTab(i18n.BEHAVIOUR_LABEL, AddLookupTableDialog.this._behaviourTab);
                    } else {
                        AddLookupTableDialog.this.pane.remove(AddLookupTableDialog.this._behaviourTab);
                    }
                }
            }
        }

        private class ColumnListSelectionListener
        implements ListSelectionListener {
            private ColumnListSelectionListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (SourceTab.this._columnList.getSelectedValue() == null) {
                    AddLookupTableDialog.this.setAllButtonEnabled(false);
                } else {
                    String selected = String.valueOf(SourceTab.this._columnList.getSelectedValue());
                    AddLookupTableDialog.this._lookupTab.onSourceColumnChange(selected);
                    SourceTab.this._foreignKeyTextField.setText("fk_" + selected);
                    AddLookupTableDialog.this.setAllButtonEnabled(true);
                }
            }
        }
    }

    static interface i18n {
        public static final String DIALOG_TITLE = s_stringMgr.getString("AddLookupTableDialog.dialogTitle");
        public static final String SOURCE_LABEL = s_stringMgr.getString("AddLookupTableDialog.sourceTabLabel");
        public static final String LOOKUP_LABEL = s_stringMgr.getString("AddLookupTableDialog.lookupTabLabel");
        public static final String BEHAVIOUR_LABEL = s_stringMgr.getString("AddLookupTableDialog.behaviourTabLabel");
        public static final String SOURCE_TABLE_LABEL = s_stringMgr.getString("AddLookupTableDialog.sourceTableLabel");
        public static final String SOURCE_COLUMN_LABEL = s_stringMgr.getString("AddLookupTableDialog.sourceColumnsLabel");
        public static final String SOURCE_FOREIGNKEY_LABEL = s_stringMgr.getString("AddLookupTableDialog.sourceForeignKeyLabel");
        public static final String SOURCE_MODE_LABEL = s_stringMgr.getString("AddLookupTableDialog.sourceModeLabel");
        public static final String SOURCE_MODE_KEEP_LABEL = s_stringMgr.getString("AddLookupTableDialog.sourceModeKeepLabel");
        public static final String SOURCE_MODE_KEEP_TOOLTIP = s_stringMgr.getString("AddLookupTableDialog.sourceModeKeepTooltip");
        public static final String SOURCE_MODE_REPLACE_LABEL = s_stringMgr.getString("AddLookupTableDialog.sourceModeReplaceLabel");
        public static final String SOURCE_MODE_REPLACE_TOOLTIP = s_stringMgr.getString("AddLookupTableDialog.sourceModeReplaceTooltip");
        public static final String LOOKUP_TABLE_LABEL = s_stringMgr.getString("AddLookupTableDialog.lookupTableLabel");
        public static final String LOOKUP_COLUMNS_LABEL = s_stringMgr.getString("AddLookupTableDialog.lookupColumnsLabel");
        public static final String LOOKUP_COLUMNSTABLE_HEADER1 = s_stringMgr.getString("AddLookupTableDialog.lookupColumnsTableHeader1");
        public static final String LOOKUP_COLUMNSTABLE_HEADER2 = s_stringMgr.getString("AddLookupTableDialog.lookupColumnsTableHeader2");
        public static final String BEHAVIOUR_DROP_LABEL = s_stringMgr.getString("AddLookupTableDialog.behaviourDropLabel");
        public static final String BEHAVIOUR_DROP_CASCADE_LABEL = s_stringMgr.getString("AddLookupTableDialog.behaviourDropCascadeLabel");
        public static final String BEHAVIOUR_DROP_CASCADE_TOOLIP = s_stringMgr.getString("AddLookupTableDialog.behaviourDropCascadeToolTip");
    }
}

