/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringDialog;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.util.NumberDocument;

public class AddModifySequenceDialog
extends AbstractRefactoringDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AddModifySequenceDialog.class);
    public static final int MODIFY_MODE = 1;
    public static final int ADD_MODE = 2;
    private JTextField _nameField;
    private JTextField _lastValueField;
    private JTextField _incrementField;
    private JTextField _startField;
    private JTextField _minimumField;
    private JTextField _maximumField;
    private JTextField _cacheField;
    private JCheckBox _cycledField;
    private int _dialogMode = -1;

    public AddModifySequenceDialog(int dialogMode, Frame owningFrame) {
        super(owningFrame);
        if (dialogMode == 1) {
            this.setTitle(i18n.TITLEMODIFY);
        } else if (dialogMode == 2) {
            this.setTitle(i18n.TITLEADD);
        }
        this._dialogMode = dialogMode;
        this.init();
    }

    public AddModifySequenceDialog(int dialogMode, String sequenceName, String lastValue, String increment, String minimum, String maximum, String cache, boolean cylced, Frame owningFrame) {
        this(dialogMode, owningFrame);
        this._nameField.setText(sequenceName);
        this._lastValueField.setText(lastValue);
        this._incrementField.setText(increment);
        this._minimumField.setText(minimum);
        this._maximumField.setText(maximum);
        this._cacheField.setText(cache);
        this._cycledField.setSelected(cylced);
    }

    protected void init() {
        JLabel nameLabel = this.getBorderedLabel(i18n.SEQUENCE_NAME_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)nameLabel, this.getLabelConstraints(this.c));
        this._nameField = new JTextField();
        this._nameField.setPreferredSize(this.mediumField);
        if (this._dialogMode == 1) {
            this._nameField.setEnabled(false);
        }
        this.pane.add((Component)this._nameField, this.getFieldConstraints(this.c));
        this._nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (AddModifySequenceDialog.this._nameField.getText().equals("")) {
                    AddModifySequenceDialog.this.enableAllButtons(false);
                    return;
                }
                AddModifySequenceDialog.this.enableAllButtons(true);
            }
        });
        if (this._dialogMode == 1) {
            JLabel lastValueLabel = this.getBorderedLabel(i18n.LAST_VALUE_LABEL + " ", this.emptyBorder);
            this.pane.add((Component)lastValueLabel, this.getLabelConstraints(this.c));
            this._lastValueField = new JTextField();
            this._lastValueField.setEnabled(false);
            this._lastValueField.setPreferredSize(this.mediumField);
            this.pane.add((Component)this._lastValueField, this.getFieldConstraints(this.c));
        }
        JLabel incrementLabel = this.getBorderedLabel(i18n.INCREMENT_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)incrementLabel, this.getLabelConstraints(this.c));
        this._incrementField = new JTextField();
        this._incrementField.setPreferredSize(this.mediumField);
        this._incrementField.setDocument(new NumberDocument());
        this.pane.add((Component)this._incrementField, this.getFieldConstraints(this.c));
        JLabel startLabel = this._dialogMode == 1 ? this.getBorderedLabel(i18n.RESTART_LABEL + " ", this.emptyBorder) : this.getBorderedLabel(i18n.START_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)startLabel, this.getLabelConstraints(this.c));
        this._startField = new JTextField();
        this._startField.setPreferredSize(this.mediumField);
        this._startField.setDocument(new NumberDocument());
        this.pane.add((Component)this._startField, this.getFieldConstraints(this.c));
        JLabel minimumLabel = this.getBorderedLabel(i18n.MINIMUM_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)minimumLabel, this.getLabelConstraints(this.c));
        this._minimumField = new JTextField();
        this._minimumField.setPreferredSize(this.mediumField);
        this._minimumField.setDocument(new NumberDocument());
        this.pane.add((Component)this._minimumField, this.getFieldConstraints(this.c));
        JLabel maximumLabel = this.getBorderedLabel(i18n.MAXIMUM_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)maximumLabel, this.getLabelConstraints(this.c));
        this._maximumField = new JTextField();
        this._maximumField.setPreferredSize(this.mediumField);
        this._maximumField.setDocument(new NumberDocument());
        this.pane.add((Component)this._maximumField, this.getFieldConstraints(this.c));
        JLabel cacheLabel = this.getBorderedLabel(i18n.CACHE_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)cacheLabel, this.getLabelConstraints(this.c));
        this._cacheField = new JTextField();
        this._cacheField.setPreferredSize(this.mediumField);
        this._cacheField.setDocument(new NumberDocument());
        this.pane.add((Component)this._cacheField, this.getFieldConstraints(this.c));
        JLabel cycledLabel = this.getBorderedLabel(i18n.CYCLED_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)cycledLabel, this.getLabelConstraints(this.c));
        this._cycledField = new JCheckBox();
        this.pane.add((Component)this._cycledField, this.getFieldConstraints(this.c));
        this.enableAllButtons(this._dialogMode == 1);
        this.executeButton.setRequestFocusEnabled(true);
    }

    public String getSequenceName() {
        return this._nameField.getText();
    }

    public String getIncrement() {
        return this._incrementField.getText();
    }

    public String getStart() {
        return this._startField.getText();
    }

    public String getMaximum() {
        return this._maximumField.getText();
    }

    public String getMinimum() {
        return this._minimumField.getText();
    }

    public String getCache() {
        return this._cacheField.getText();
    }

    public boolean isCycled() {
        return this._cycledField.isSelected();
    }

    public static void main(String[] args) {
        new AddModifySequenceDialog(2, null).setVisible(true);
    }

    static interface i18n {
        public static final String TITLEADD = s_stringMgr.getString("AddSequenceDialog.titleAdd");
        public static final String TITLEMODIFY = s_stringMgr.getString("AddSequenceDialog.titleModify");
        public static final String SEQUENCE_NAME_LABEL = s_stringMgr.getString("AddSequenceDialog.sequenceNameLabel");
        public static final String LAST_VALUE_LABEL = s_stringMgr.getString("AddSequenceDialog.lastValueLabel");
        public static final String INCREMENT_LABEL = s_stringMgr.getString("AddSequenceDialog.incrementLabel");
        public static final String START_LABEL = s_stringMgr.getString("AddSequenceDialog.startLabel");
        public static final String RESTART_LABEL = s_stringMgr.getString("AddSequenceDialog.reStartLabel");
        public static final String MINIMUM_LABEL = s_stringMgr.getString("AddSequenceDialog.minimumLabel");
        public static final String MAXIMUM_LABEL = s_stringMgr.getString("AddSequenceDialog.maximumLabel");
        public static final String CACHE_LABEL = s_stringMgr.getString("AddSequenceDialog.cacheLabel");
        public static final String CYCLED_LABEL = s_stringMgr.getString("AddSequenceDialog.cycledLabel");
    }
}

