/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Component;
import java.awt.Frame;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringDialog;

public class DefaultDropDialog
extends AbstractRefactoringDialog {
    private JCheckBox _cascadeCB;
    private JLabel _cascadeConstraintsLabel;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DefaultDropDialog.class);
    private String _dropItem = "";
    private final IDatabaseObjectInfo[] _objectInfo;
    public static final int DIALOG_TYPE_VIEW = 1;
    public static final int DIALOG_TYPE_TABLE = 2;
    public static final int DIALOG_TYPE_INDEX = 3;
    public static final int DIALOG_TYPE_SEQUENCE = 4;
    public static final int DIALOG_TYPE_FOREIGN_KEY = 5;
    public static final int DIALOG_TYPE_UNIQUE_CONSTRAINT_KEY = 6;

    public DefaultDropDialog(IDatabaseObjectInfo[] objectInfo, int dialogType, Frame owningFrame) {
        super(owningFrame);
        this._objectInfo = objectInfo;
        this.setTypeByID(dialogType);
        this.init();
    }

    private void setTypeByID(int dialogType) {
        String object = "";
        switch (dialogType) {
            case 1: {
                object = i18n.VIEW_LABEL;
                break;
            }
            case 2: {
                object = i18n.TABLE_LABEL;
                break;
            }
            case 3: {
                object = i18n.INDEX_LABEL;
                break;
            }
            case 4: {
                object = i18n.SEQUENCE_LABEL;
                break;
            }
            case 5: {
                object = i18n.FOREIGN_KEY_LABEL;
                break;
            }
            case 6: {
                object = i18n.UNIQUE_CONSTRAINT_LABEL;
                break;
            }
        }
        this._dropItem = object;
        this.setTitle(s_stringMgr.getString("DefaultDropDialog.title", new Object[]{object}));
    }

    protected void init() {
        JLabel catalogLabel = this.getBorderedLabel(i18n.CATALOG_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)catalogLabel, this.getLabelConstraints(this.c));
        JTextField catalogTF = new JTextField();
        catalogTF.setPreferredSize(this.mediumField);
        catalogTF.setEditable(false);
        catalogTF.setText(this._objectInfo[0].getCatalogName());
        this.pane.add((Component)catalogTF, this.getFieldConstraints(this.c));
        JLabel schemaLabel = this.getBorderedLabel(i18n.SCHEMA_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)schemaLabel, this.getLabelConstraints(this.c));
        JTextField schemaTF = new JTextField();
        schemaTF.setPreferredSize(this.mediumField);
        schemaTF.setEditable(false);
        schemaTF.setText(this._objectInfo[0].getSchemaName());
        this.pane.add((Component)schemaTF, this.getFieldConstraints(this.c));
        JLabel viewListLabel = this.getBorderedLabel(this._dropItem, this.emptyBorder);
        viewListLabel.setVerticalAlignment(1);
        this.pane.add((Component)viewListLabel, this.getLabelConstraints(this.c));
        JList<String> viewList = new JList<String>(this.getSimpleNames(this._objectInfo));
        viewList.setEnabled(false);
        JScrollPane sp = new JScrollPane(viewList);
        this.c = this.getFieldConstraints(this.c);
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.fill = 1;
        this.pane.add((Component)sp, this.c);
        this._cascadeConstraintsLabel = new JLabel(i18n.CASCADE_LABEL + " ");
        this._cascadeConstraintsLabel.setBorder(this.emptyBorder);
        this.pane.add((Component)this._cascadeConstraintsLabel, this.getLabelConstraints(this.c));
        this._cascadeCB = new JCheckBox();
        this._cascadeCB.setPreferredSize(this.mediumField);
        this.pane.add((Component)this._cascadeCB, this.getFieldConstraints(this.c));
        this.executeButton.setRequestFocusEnabled(true);
    }

    private String[] getSimpleNames(IDatabaseObjectInfo[] dbInfo) {
        String[] result = new String[dbInfo.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = dbInfo[i].getSimpleName();
        }
        return result;
    }

    public boolean isCascadeSelected() {
        return this._cascadeCB.isSelected();
    }

    public void setCascadeVisible(boolean visible) {
        this._cascadeConstraintsLabel.setVisible(visible);
        this._cascadeCB.setVisible(visible);
    }

    static interface i18n {
        public static final String CATALOG_LABEL = s_stringMgr.getString("DefaultDropDialog.catalogLabel");
        public static final String SCHEMA_LABEL = s_stringMgr.getString("DefaultDropDialog.schemaLabel");
        public static final String TABLE_LABEL = s_stringMgr.getString("DefaultDropDialog.tableLabel");
        public static final String VIEW_LABEL = s_stringMgr.getString("DefaultDropDialog.viewLabel");
        public static final String INDEX_LABEL = s_stringMgr.getString("DefaultDropDialog.indexLabel");
        public static final String SEQUENCE_LABEL = s_stringMgr.getString("DefaultDropDialog.sequenceLabel");
        public static final String FOREIGN_KEY_LABEL = s_stringMgr.getString("DefaultDropDialog.foreignKeyLabel");
        public static final String UNIQUE_CONSTRAINT_LABEL = s_stringMgr.getString("DefaultDropDialog.uniqueConstraintLabel");
        public static final String CASCADE_LABEL = s_stringMgr.getString("DefaultDropDialog.cascadeLabel");
    }
}

