/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class DefaultListDialog
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DefaultListDialog.class);
    private final IDatabaseObjectInfo[] _objectInfo;
    private String _selectItem = "";
    public static final int DIALOG_TYPE_INDEX = 3;
    public static final int DIALOG_TYPE_UNIQUE_CONSTRAINTS = 4;
    public static final int DIALOG_TYPE_FOREIGN_KEY = 5;
    private JButton _executeButton = null;
    private JList _columnList;

    public DefaultListDialog(IDatabaseObjectInfo[] objectInfo, String tableName, int dialogType) {
        this._objectInfo = objectInfo;
        this.setTypeByID(dialogType);
        this.init(tableName);
    }

    private void setTypeByID(int dialogType) {
        String object = "";
        switch (dialogType) {
            case 3: {
                object = i18n.INDEX_LABEL;
                break;
            }
            case 5: {
                object = i18n.FOREIGN_KEY_LABEL;
                break;
            }
            case 4: {
                object = i18n.UNIQUE_CONSTRAINT_LABEL;
                break;
            }
        }
        this._selectItem = object;
        this.setTitle(s_stringMgr.getString("DefaultDropDialog.title", new Object[]{object}));
    }

    public String getSelectedIndex() {
        return this._columnList.getSelectedValue().toString();
    }

    public ArrayList<IDatabaseObjectInfo> getSelectedItems() {
        ArrayList<IDatabaseObjectInfo> idbo = new ArrayList<IDatabaseObjectInfo>();
        String[] simpleNames = this.getSimpleNames(this._objectInfo);
        block0: for (int index : this._columnList.getSelectedIndices()) {
            for (IDatabaseObjectInfo info : this._objectInfo) {
                if (!info.getSimpleName().equals(simpleNames[index])) continue;
                idbo.add(info);
                continue block0;
            }
        }
        return idbo;
    }

    public void addColumnSelectionListener(ActionListener columnListSelectionActionListener) {
        this._executeButton.addActionListener(columnListSelectionActionListener);
    }

    private void init(String tableName) {
        super.setModal(true);
        this.setSize(425, 250);
        EmptyBorder border = new EmptyBorder(new Insets(5, 5, 5, 5));
        Dimension mediumField = new Dimension(126, 20);
        JPanel pane = new JPanel();
        pane.setLayout(new GridBagLayout());
        pane.setBorder(new EmptyBorder(10, 0, 0, 30));
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = -1;
        JLabel tableNameLabel = this.getBorderedLabel(i18n.TABLE_NAME_LABEL, border);
        pane.add((Component)tableNameLabel, this.getLabelConstraints(c));
        JTextField tableNameTextField = new JTextField(tableName);
        tableNameTextField.setPreferredSize(mediumField);
        tableNameTextField.setEditable(false);
        pane.add((Component)tableNameTextField, this.getFieldConstraints(c));
        JLabel columnListLabel = this.getBorderedLabel(this._selectItem, border);
        columnListLabel.setVerticalAlignment(1);
        pane.add((Component)columnListLabel, this.getLabelConstraints(c));
        this._columnList = new JList<String>(this.getSimpleNames(this._objectInfo));
        this._columnList.addListSelectionListener(new ColumnListSelectionListener());
        this._columnList.setSelectionMode(2);
        JScrollPane sp = new JScrollPane(this._columnList);
        c = this.getFieldConstraints(c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        pane.add((Component)sp, c);
        Container contentPane = super.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)pane, "Center");
        contentPane.add((Component)this.getButtonPanel(), "South");
    }

    private JPanel getButtonPanel() {
        JPanel result = new JPanel();
        this._executeButton = new JButton(i18n.OK_BUTTON_LABEL);
        JButton cancelButton = new JButton(i18n.CANCEL_BUTTON_LABEL);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultListDialog.this.setVisible(false);
                DefaultListDialog.this.dispose();
            }
        });
        result.add(this._executeButton);
        result.add(cancelButton);
        return result;
    }

    private String[] getSimpleNames(IDatabaseObjectInfo[] dbInfo) {
        ArrayList<String> simpleNames = new ArrayList<String>();
        for (IDatabaseObjectInfo info : dbInfo) {
            if (simpleNames.contains(info.getSimpleName())) continue;
            simpleNames.add(info.getSimpleName());
        }
        return simpleNames.toArray(new String[0]);
    }

    private GridBagConstraints getLabelConstraints(GridBagConstraints c) {
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 12;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        return c;
    }

    private GridBagConstraints getFieldConstraints(GridBagConstraints c) {
        ++c.gridx;
        c.anchor = 18;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        return c;
    }

    private JLabel getBorderedLabel(String text, Border border) {
        JLabel result = new JLabel(text);
        result.setBorder(border);
        result.setPreferredSize(new Dimension(115, 20));
        result.setHorizontalAlignment(4);
        return result;
    }

    private void activate(JButton button, boolean enable) {
        if (button != null) {
            button.setEnabled(enable);
        }
    }

    private class ColumnListSelectionListener
    implements ListSelectionListener {
        private ColumnListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] selected = DefaultListDialog.this._columnList.getSelectedIndices();
            if (selected == null || selected.length == 0) {
                DefaultListDialog.this.activate(DefaultListDialog.this._executeButton, false);
                return;
            }
            DefaultListDialog.this.activate(DefaultListDialog.this._executeButton, true);
        }
    }

    private static interface i18n {
        public static final String TABLE_NAME_LABEL = s_stringMgr.getString("DefaultListDialog.tableNameLabel");
        public static final String CANCEL_BUTTON_LABEL = s_stringMgr.getString("AbstractRefactoringDialog.cancelButtonLabel");
        public static final String FOREIGN_KEY_LABEL = s_stringMgr.getString("DefaultListDialog.foreignKeyNameLabel");
        public static final String INDEX_LABEL = s_stringMgr.getString("DefaultListDialog.indexNameLabel");
        public static final String UNIQUE_CONSTRAINT_LABEL = s_stringMgr.getString("DefaultListDialog.uniqueConstraintLabel");
        public static final String OK_BUTTON_LABEL = s_stringMgr.getString("DefaultListDialog.selectButtonLabel");
    }
}

