/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Component;
import java.awt.Frame;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringDialog;

public class DropTableDialog
extends AbstractRefactoringDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropTableDialog.class);
    private JCheckBox cascadeCB = null;
    private ITableInfo[] tableInfos = null;

    public DropTableDialog(ITableInfo[] tables, Frame owningFrame) {
        super(owningFrame);
        this.setTitle(i18n.TITLE);
        this.tableInfos = tables;
        this.init();
    }

    public ITableInfo[] getTableInfos() {
        return this.tableInfos;
    }

    public List<ITableInfo> getTableInfoList() {
        return Arrays.asList(this.tableInfos);
    }

    public boolean getCascadeConstraints() {
        return this.cascadeCB.isSelected();
    }

    protected void init() {
        JLabel catalogLabel = this.getBorderedLabel(i18n.CATALOG_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)catalogLabel, this.getLabelConstraints(this.c));
        JTextField catalogTF = new JTextField();
        catalogTF.setPreferredSize(this.mediumField);
        catalogTF.setEditable(false);
        catalogTF.setText(this.tableInfos[0].getCatalogName());
        this.pane.add((Component)catalogTF, this.getFieldConstraints(this.c));
        JLabel schemaLabel = this.getBorderedLabel(i18n.SCHEMA_LABEL + " ", this.emptyBorder);
        this.pane.add((Component)schemaLabel, this.getLabelConstraints(this.c));
        JTextField schemaTF = new JTextField();
        schemaTF.setPreferredSize(this.mediumField);
        schemaTF.setEditable(false);
        schemaTF.setText(this.tableInfos[0].getSchemaName());
        this.pane.add((Component)schemaTF, this.getFieldConstraints(this.c));
        JLabel tableListLabel = this.getBorderedLabel(i18n.TABLE_LABEL + " ", this.emptyBorder);
        tableListLabel.setVerticalAlignment(1);
        this.pane.add((Component)tableListLabel, this.getLabelConstraints(this.c));
        JList<String> tableList = new JList<String>(this.getSimpleNames(this.tableInfos));
        tableList.setEnabled(false);
        JScrollPane sp = new JScrollPane(tableList);
        this.c = this.getFieldConstraints(this.c);
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.fill = 1;
        this.pane.add((Component)sp, this.c);
        JLabel cascadeConstraintsLabel = new JLabel(i18n.CASCADE_LABEL + " ");
        cascadeConstraintsLabel.setBorder(this.emptyBorder);
        this.pane.add((Component)cascadeConstraintsLabel, this.getLabelConstraints(this.c));
        this.cascadeCB = new JCheckBox();
        this.cascadeCB.setPreferredSize(this.mediumField);
        this.pane.add((Component)this.cascadeCB, this.getFieldConstraints(this.c));
        this.executeButton.setRequestFocusEnabled(true);
    }

    private String[] getSimpleNames(ITableInfo[] tableInfos) {
        String[] result = new String[tableInfos.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = tableInfos[i].getSimpleName();
        }
        return result;
    }

    static interface i18n {
        public static final String CASCADE_LABEL = s_stringMgr.getString("DropTableDialog.cascadeLabel");
        public static final String CATALOG_LABEL = s_stringMgr.getString("DropTableDialog.catalogLabel");
        public static final String SCHEMA_LABEL = s_stringMgr.getString("DropTableDialog.schemaLabel");
        public static final String TABLE_LABEL = s_stringMgr.getString("DropTableDialog.tableLabel");
        public static final String TITLE = s_stringMgr.getString("DropTableDialog.title");
    }
}

