/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringTabbedDialog;

public class MergeColumnDialog
extends AbstractRefactoringTabbedDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MergeColumnDialog.class);
    private final String _localTableName;
    private final String[] _localTableColumns;
    private PropertiesTab _propertiesTab;

    public MergeColumnDialog(String localTable, String[] localTableColumns) {
        super(new Dimension(430, 350));
        this._localTableName = localTable;
        this._localTableColumns = localTableColumns;
        this.init();
    }

    private void init() {
        this._propertiesTab = new PropertiesTab();
        this.pane.addTab(i18n.TABBEDPANE_PROPERTIES_LABEL, this._propertiesTab);
        this.setAllButtonEnabled(false);
        this.setTitle(i18n.DIALOG_TITLE);
    }

    private void checkInputCompletion() {
        if (this.isNewColumn() && this.getNewColumnName().equals("")) {
            this.setAllButtonEnabled(false);
            return;
        }
        this.setAllButtonEnabled(true);
    }

    public boolean isNewColumn() {
        return this._propertiesTab._newColumnRadio.isSelected();
    }

    public String getNewColumnName() {
        return this._propertiesTab._newColumnNameField.getText();
    }

    public String getJoinString() {
        return this._propertiesTab._joinStringField.getText();
    }

    public String getSecondColumn() {
        return (String)this._propertiesTab._columnSecondBox.getSelectedItem();
    }

    public String getFirstColumn() {
        return (String)this._propertiesTab._columnFirstBox.getSelectedItem();
    }

    public String getMergeInExistingColumn() {
        if (this._propertiesTab._mergeInExistingBox.getSelectedItem().equals(i18n.PROPERTIES_COLUMN1_LABEL)) {
            return this.getFirstColumn();
        }
        return this.getSecondColumn();
    }

    public boolean isMergeInExistingColumn() {
        return this._propertiesTab._mergeInExistingColumnRadio.isSelected();
    }

    public static void main(String[] args) {
        String tableName = "Customers";
        String[] columns = new String[]{"Id", "PhoneCountryCode", "PhoneAreaCode", "PhoneLocal"};
        MergeColumnDialog dialog = new MergeColumnDialog(tableName, columns);
        dialog.setVisible(true);
    }

    class ColumnActionListener
    implements ActionListener {
        ColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MergeColumnDialog.this._propertiesTab._columnFirstBox.getSelectedItem() == MergeColumnDialog.this._propertiesTab._columnSecondBox.getSelectedItem()) {
                JComboBox box = (JComboBox)actionEvent.getSource();
                if (box.getItemCount() > box.getSelectedIndex() + 1) {
                    box.setSelectedIndex(box.getSelectedIndex() + 1);
                } else {
                    box.setSelectedIndex(box.getSelectedIndex() - 1);
                }
            }
        }
    }

    class PropertiesTab
    extends JPanel {
        private JComboBox _columnFirstBox;
        private JComboBox _columnSecondBox;
        private JComboBox _mergeInExistingBox;
        private JLabel _mergeNewColumnNameLabel;
        private JRadioButton _newColumnRadio;
        private JTextField _newColumnNameField;
        private JRadioButton _mergeInExistingColumnRadio;
        private JTextField _joinStringField;

        public PropertiesTab() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            JLabel tableNameLabel = MergeColumnDialog.this.getBorderedLabel(i18n.PROPERTIES_TABLENAME_LABEL, MergeColumnDialog.this.emptyBorder);
            JTextField tableNameField = new JTextField();
            tableNameField.setPreferredSize(MergeColumnDialog.this.mediumField);
            tableNameField.setText(MergeColumnDialog.this._localTableName);
            tableNameField.setEnabled(false);
            JLabel column1Label = MergeColumnDialog.this.getBorderedLabel(i18n.PROPERTIES_COLUMN1_LABEL, MergeColumnDialog.this.emptyBorder);
            this._columnFirstBox = new JComboBox<String>(MergeColumnDialog.this._localTableColumns);
            this._columnFirstBox.setPreferredSize(MergeColumnDialog.this.mediumField);
            this._columnFirstBox.setActionCommand("ColumnFirst");
            this._columnFirstBox.addActionListener(new ColumnActionListener());
            JLabel column2Label = MergeColumnDialog.this.getBorderedLabel(i18n.PROPERTIES_COLUMN2_LABEL, MergeColumnDialog.this.emptyBorder);
            this._columnSecondBox = new JComboBox<String>(MergeColumnDialog.this._localTableColumns);
            this._columnSecondBox.setSelectedIndex(1);
            this._columnSecondBox.setActionCommand("ColumnSecond");
            this._columnSecondBox.addActionListener(new ColumnActionListener());
            this._columnSecondBox.setPreferredSize(MergeColumnDialog.this.mediumField);
            JLabel mergeToLabel = MergeColumnDialog.this.getBorderedLabel(i18n.PROPERTIES_MERGE_TO_LABEL, MergeColumnDialog.this.emptyBorder);
            this._newColumnRadio = new JRadioButton();
            this._newColumnRadio.setSelected(true);
            this._newColumnRadio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertiesTab.this.enableNewColumn(true);
                    MergeColumnDialog.this.checkInputCompletion();
                }
            });
            this._newColumnNameField = new JTextField();
            this._newColumnNameField.setPreferredSize(new Dimension(83, 20));
            this._newColumnNameField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    MergeColumnDialog.this.checkInputCompletion();
                }
            });
            this._mergeInExistingBox = new JComboBox<String>(new String[]{i18n.PROPERTIES_COLUMN1_LABEL, i18n.PROPERTIES_COLUMN2_LABEL});
            this._mergeInExistingBox.setPreferredSize(MergeColumnDialog.this.mediumField);
            this._mergeInExistingBox.setEnabled(false);
            JLabel mergeNewColumnLabel = MergeColumnDialog.this.getBorderedLabel(i18n.PROPERTIES_MERGE_IN_NEW_COLUMN_LABEL, MergeColumnDialog.this.emptyBorder);
            mergeNewColumnLabel.setHorizontalAlignment(2);
            this._mergeNewColumnNameLabel = MergeColumnDialog.this.getBorderedLabel(i18n.PROPERTIES_MERGE_IN_NEW_COLUMN_NAME_LABEL, MergeColumnDialog.this.emptyBorder);
            this._mergeNewColumnNameLabel.setHorizontalAlignment(2);
            this._mergeNewColumnNameLabel.setPreferredSize(new Dimension(45, 20));
            JPanel mergeNewColumnNamePanel = new JPanel(new GridBagLayout());
            mergeNewColumnNamePanel.add((Component)this._mergeNewColumnNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            mergeNewColumnNamePanel.add((Component)this._newColumnNameField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            JLabel mergeInExistingColumnLabel = MergeColumnDialog.this.getBorderedLabel(i18n.PROPERTIES_MERGE_IN_EXISTING_COLUMN_LABEL, MergeColumnDialog.this.emptyBorder);
            mergeInExistingColumnLabel.setHorizontalAlignment(2);
            this._mergeInExistingColumnRadio = new JRadioButton();
            this._mergeInExistingColumnRadio.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertiesTab.this.enableNewColumn(false);
                    MergeColumnDialog.this.checkInputCompletion();
                }
            });
            ButtonGroup group = new ButtonGroup();
            group.add(this._newColumnRadio);
            group.add(this._mergeInExistingColumnRadio);
            JPanel mergeNewColumnPanel = new JPanel(new GridBagLayout());
            mergeNewColumnPanel.add((Component)this._newColumnRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            mergeNewColumnPanel.add((Component)mergeNewColumnLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            JPanel mergeinExistingColumnPanel = new JPanel(new GridBagLayout());
            mergeinExistingColumnPanel.add((Component)this._mergeInExistingColumnRadio, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            mergeinExistingColumnPanel.add((Component)mergeInExistingColumnLabel, new GridBagConstraints(1, 0, 1, 1, 4.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            JLabel joinStringLabel = MergeColumnDialog.this.getBorderedLabel(i18n.PROPERTIES_JOIN_STRING_LABEL, MergeColumnDialog.this.emptyBorder);
            this._joinStringField = new JTextField();
            this._joinStringField.setPreferredSize(MergeColumnDialog.this.mediumField);
            Insets insets = new Insets(5, 0, 5, 5);
            this.add((Component)tableNameLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
            this.add((Component)tableNameField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)column1Label, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
            this.add((Component)this._columnFirstBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)column2Label, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
            this.add((Component)this._columnSecondBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)mergeToLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
            this.add((Component)mergeNewColumnPanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)mergeNewColumnNamePanel, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)mergeinExistingColumnPanel, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)this._mergeInExistingBox, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
            this.add((Component)joinStringLabel, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, insets, 0, 0));
            this.add((Component)this._joinStringField, new GridBagConstraints(1, 7, 1, 1, 0.0, 0.0, 17, 0, insets, 0, 0));
        }

        private void enableNewColumn(boolean aFlag) {
            this._newColumnNameField.setEnabled(aFlag);
            this._mergeNewColumnNameLabel.setEnabled(aFlag);
            this._mergeInExistingBox.setEnabled(!aFlag);
        }
    }

    protected static interface i18n {
        public static final String DIALOG_TITLE = s_stringMgr.getString("MergeColumnDialog.title");
        public static final String PROPERTIES_TABLENAME_LABEL = s_stringMgr.getString("MergeColumnDialog.tableNameLabel");
        public static final String PROPERTIES_COLUMN1_LABEL = s_stringMgr.getString("MergeColumnDialog.column1Label");
        public static final String PROPERTIES_MERGE_IN_NEW_COLUMN_LABEL = s_stringMgr.getString("MergeColumnDialog.mergeInNewColumnLabel");
        public static final String PROPERTIES_MERGE_IN_EXISTING_COLUMN_LABEL = s_stringMgr.getString("MergeColumnDialog.mergeInExistingColumnLabel");
        public static final String PROPERTIES_MERGE_IN_NEW_COLUMN_NAME_LABEL = s_stringMgr.getString("MergeColumnDialog.mergeNewColumnNameLabel");
        public static final String TABBEDPANE_PROPERTIES_LABEL = s_stringMgr.getString("MergeColumnDialog.propertiesTabName");
        public static final String PROPERTIES_COLUMN2_LABEL = s_stringMgr.getString("MergeColumnDialog.column2Label");
        public static final String PROPERTIES_MERGE_TO_LABEL = s_stringMgr.getString("MergeColumnDialog.mergeToLabel");
        public static final String PROPERTIES_JOIN_STRING_LABEL = s_stringMgr.getString("MergeColumnDialog.joinStringLabel");
    }
}

