/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.AbstractRefactoringTabbedDialog;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.IMergeTableDialog;
import net.sourceforge.squirrel_sql.plugins.refactoring.gui.MergeTableColumnTableModel;

public class MergeTableDialog
extends AbstractRefactoringTabbedDialog
implements IMergeTableDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(MergeTableDialog.class);
    private final String _localTableName;
    private String _referencedTable = "";
    private final TableColumnInfo[] _localTableColumns;
    private final HashMap<String, TableColumnInfo[]> _tables;
    private ColumnsTab _columnTab;
    private PropertiesTab _propertiesTab;

    public MergeTableDialog(String localTable, TableColumnInfo[] localColumns, HashMap<String, TableColumnInfo[]> tables) {
        super(new Dimension(430, 350));
        this._localTableName = localTable;
        this._localTableColumns = localColumns;
        this._tables = tables;
        this.init();
    }

    private void init() {
        this._columnTab = new ColumnsTab();
        this._propertiesTab = new PropertiesTab();
        this.pane.addTab(i18n.TABBEDPANE_PROPERTIES_LABEL, this._propertiesTab);
        this.pane.addTab(i18n.TABBEDPANE_COLUMNS_LABEL, this._columnTab);
        this.setAllButtonEnabled(false);
        this.setTitle(i18n.DIALOG_TITLE);
    }

    private void checkInputCompletion() {
        if (this._columnTab._columTable.getRowCount() == 0) {
            this.setAllButtonEnabled(false);
            return;
        }
        this.setAllButtonEnabled(true);
    }

    @Override
    public String getReferencedTable() {
        return this._propertiesTab.getReferencesField();
    }

    @Override
    public Vector<String[]> getWhereDataColumns() {
        return this._propertiesTab._columnTableModel.getRowData();
    }

    @Override
    public Vector<String> getMergeColumns() {
        return this._columnTab.getMergeColumns();
    }

    @Override
    public boolean isMergeData() {
        return this._propertiesTab.getMergeData();
    }

    public static void main(String[] args) {
        TableColumnInfo newColumn;
        String catalog = null;
        String schema = "public";
        String employeeTableName = "Employee";
        String employeIdentifactionTable = "EmployeeIdentification";
        String customerTableName = "Customer";
        String[] employeeColumns = new String[]{"EmployeeNumber", "Name", "PhoneNumber"};
        String[] employeeIdentificationColumns = new String[]{"EmployeeNumber", "Picture", "VoicePrint", "RetinalPrint"};
        String[] customerColumns = new String[]{"CustomerNumber", "Name", "PhoneNumber", " Address"};
        HashMap<String, TableColumnInfo[]> tables = new HashMap<String, TableColumnInfo[]>();
        ArrayList<TableColumnInfo> tableColumnInfo = new ArrayList<TableColumnInfo>();
        for (String column : employeeIdentificationColumns) {
            TableColumnInfo newColumn2 = new TableColumnInfo(catalog, schema, employeIdentifactionTable, column, 12, JDBCTypeMapper.getJdbcTypeName((int)12), 30, 0, 0, 1, null, null, 0, 1, "YES", null, null);
            tableColumnInfo.add(newColumn2);
        }
        tables.put(employeIdentifactionTable, tableColumnInfo.toArray(new TableColumnInfo[0]));
        tableColumnInfo.clear();
        ArrayList<TableColumnInfo> employeColumnsInfo = new ArrayList<TableColumnInfo>();
        for (String column : employeeColumns) {
            newColumn = new TableColumnInfo(catalog, schema, employeIdentifactionTable, column, 12, JDBCTypeMapper.getJdbcTypeName((int)12), 30, 0, 0, 1, null, null, 0, 1, "YES", null, null);
            employeColumnsInfo.add(newColumn);
        }
        tableColumnInfo.clear();
        for (String column : customerColumns) {
            newColumn = new TableColumnInfo(catalog, schema, employeIdentifactionTable, column, 12, JDBCTypeMapper.getJdbcTypeName((int)12), 30, 0, 0, 1, null, null, 0, 1, "YES", null, null);
            tableColumnInfo.add(newColumn);
        }
        tables.put(customerTableName, tableColumnInfo.toArray(new TableColumnInfo[0]));
        MergeTableDialog dialog = new MergeTableDialog(employeeTableName, employeColumnsInfo.toArray(new TableColumnInfo[0]), tables);
        dialog.setVisible(true);
    }

    class ReferenceColumnTableModel
    extends AbstractTableModel {
        private final Vector<String[]> rowData = new Vector();
        private final String[] columnNames = new String[]{i18n.COLUMNS_LOCAL_COLUMN_HEADER, i18n.COLUMNS_MERGE_TABLE_HEADER};

        ReferenceColumnTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.rowData.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.rowData.get(row)[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void addColumn(String[] column) {
            this.rowData.add(column);
            this.fireTableDataChanged();
        }

        public String[] deleteRow(int row) {
            String[] removedRow = this.rowData.remove(row);
            this.fireTableDataChanged();
            return removedRow;
        }

        public Vector<String[]> getRowData() {
            return this.rowData;
        }
    }

    class ColumnsTab
    extends JPanel {
        private JTable _columTable;
        private final MergeTableColumnTableModel _columnTableModel = new MergeTableColumnTableModel();
        private JComboBox referencingBox;
        private JButton removeButton;
        private JButton addButton;
        private String _tableName = "";

        public ColumnsTab() {
            this.init();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            this._columTable = new JTable();
            this._columTable.setModel(this._columnTableModel);
            this._columTable.setRowSelectionAllowed(true);
            this._columTable.setColumnSelectionAllowed(false);
            this._columTable.getTableHeader().setReorderingAllowed(false);
            this._columTable.setCellSelectionEnabled(false);
            this._columTable.setSelectionMode(0);
            this._columTable.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    ColumnsTab.this.removeButton.setEnabled(true);
                }
            });
            JScrollPane scrollTablePane = new JScrollPane(this._columTable);
            JLabel referencingLabel = MergeTableDialog.this.getBorderedLabel(i18n.COLUMNS_REFERENCING_LABEL, MergeTableDialog.this.emptyBorder);
            this.referencingBox = new JComboBox();
            this.referencingBox.setPreferredSize(MergeTableDialog.this.mediumField);
            JPanel buttonPanel = new JPanel(new GridLayout(1, 0, 10, 10));
            this.addButton = new JButton(i18n.COLUMNS_ADD_BUTTON_LABEL);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String ref = (String)ColumnsTab.this.referencingBox.getSelectedItem();
                    ColumnsTab.this.referencingBox.removeItem(ref);
                    ColumnsTab.this._columnTableModel.addColumn(ref);
                    MergeTableDialog.this._propertiesTab.enableReferencedComboBox(false);
                    if (ColumnsTab.this.referencingBox.getItemCount() == 0) {
                        ColumnsTab.this.addButton.setEnabled(false);
                    }
                    MergeTableDialog.this.checkInputCompletion();
                }
            });
            this.removeButton = new JButton(i18n.COLUMNS_REMOVE_BUTTON_LABEL);
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = ColumnsTab.this._columTable.getSelectedRow();
                    if (index != -1) {
                        String removed = ColumnsTab.this._columnTableModel.deleteRow(index);
                        ColumnsTab.this.referencingBox.addItem(removed);
                        ColumnsTab.this.addButton.setEnabled(true);
                        if (ColumnsTab.this._columnTableModel.getRowCount() == 0) {
                            ColumnsTab.this.removeButton.setEnabled(false);
                            MergeTableDialog.this._propertiesTab.enableReferencedComboBox(true);
                        } else {
                            int deleteIndex = 0;
                            if (index > 0) {
                                deleteIndex = index - 1;
                            }
                            ColumnsTab.this._columTable.getSelectionModel().setSelectionInterval(0, deleteIndex);
                        }
                    }
                    MergeTableDialog.this.checkInputCompletion();
                }
            });
            buttonPanel.add(this.addButton);
            buttonPanel.add(this.removeButton);
            this.add((Component)scrollTablePane, new GridBagConstraints(0, 0, 2, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)referencingLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.add((Component)this.referencingBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 3, 0), 0, 0));
            this.add((Component)buttonPanel, new GridBagConstraints(0, 5, 2, 0, 1.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void setReferencedColumns(String tableName) {
            if (!tableName.equals(this._tableName)) {
                this._columnTableModel.clear();
            }
            this._tableName = tableName;
            TableColumnInfo[] tableColumns = MergeTableDialog.this._tables.get(tableName);
            Vector<String> columns = new Vector<String>();
            for (TableColumnInfo columnInfo : tableColumns) {
                columns.add(columnInfo.getColumnName());
            }
            this.setReferencedColumns(columns.toArray(new String[0]));
        }

        private void setReferencedColumns(String[] refColums) {
            this.referencingBox.removeAllItems();
            ArrayList<String> localColumnNames = new ArrayList<String>();
            for (TableColumnInfo tableColumnInfo : MergeTableDialog.this._localTableColumns) {
                localColumnNames.add(tableColumnInfo.getColumnName());
            }
            for (String string : refColums) {
                if (localColumnNames.contains(string)) continue;
                this.referencingBox.addItem(string);
            }
        }

        public Vector<String> getMergeColumns() {
            return this._columnTableModel.getRowData();
        }
    }

    class PropertiesTab
    extends JPanel {
        private JComboBox _referencesField;
        private JCheckBox _mergeDataBox;
        private JTable _columTable;
        private final ReferenceColumnTableModel _columnTableModel;
        private JComboBox localColumBox;
        private JComboBox referencingBox;
        private JButton removeButton;
        private JButton addButton;

        public PropertiesTab() {
            this._columnTableModel = new ReferenceColumnTableModel();
            this.init();
            this.initData();
        }

        private void init() {
            this.setLayout(new GridBagLayout());
            JLabel nameLabel = MergeTableDialog.this.getBorderedLabel(i18n.PROPERTIES_TABLENAME_LABEL, MergeTableDialog.this.emptyBorder);
            JTextField tableField = new JTextField(MergeTableDialog.this._localTableName);
            tableField.setPreferredSize(MergeTableDialog.this.mediumField);
            tableField.setEnabled(false);
            JLabel referencesLabel = MergeTableDialog.this.getBorderedLabel(i18n.PROPERTIES_REFERENCES_LABEL, MergeTableDialog.this.emptyBorder);
            this._referencesField = new JComboBox();
            this._referencesField.setPreferredSize(MergeTableDialog.this.mediumField);
            this._referencesField.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MergeTableDialog.this._referencedTable = (String)PropertiesTab.this._referencesField.getSelectedItem();
                    MergeTableDialog.this._columnTab.setReferencedColumns(MergeTableDialog.this._referencedTable);
                    PropertiesTab.this.setReferencedColumnBox(MergeTableDialog.this._referencedTable);
                }
            });
            JLabel mergeDataLabel = MergeTableDialog.this.getBorderedLabel(i18n.PROPERTIES_MERGE_DATA_LABEL, MergeTableDialog.this.emptyBorder);
            this._mergeDataBox = new JCheckBox();
            this._mergeDataBox.setSelected(true);
            JPanel keyPanel = new JPanel(new GridBagLayout());
            this._columTable = new JTable();
            this._columTable.setModel(this._columnTableModel);
            this._columTable.setRowSelectionAllowed(true);
            this._columTable.setColumnSelectionAllowed(false);
            this._columTable.getTableHeader().setReorderingAllowed(false);
            this._columTable.setCellSelectionEnabled(false);
            this._columTable.setSelectionMode(0);
            this._columTable.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    PropertiesTab.this.removeButton.setEnabled(true);
                }
            });
            JScrollPane scrollTablePane = new JScrollPane(this._columTable);
            scrollTablePane.setPreferredSize(new Dimension(240, 50));
            JLabel localColumLabel = MergeTableDialog.this.getBorderedLabel(i18n.COLUMNS_LOCAL_COLUMN_HEADER, MergeTableDialog.this.emptyBorder);
            JLabel referencingLabel = MergeTableDialog.this.getBorderedLabel(i18n.COLUMNS_MERGE_TABLE_HEADER, MergeTableDialog.this.emptyBorder);
            this.localColumBox = new JComboBox();
            this.localColumBox.setPreferredSize(MergeTableDialog.this.mediumField);
            this.referencingBox = new JComboBox();
            this.referencingBox.setPreferredSize(MergeTableDialog.this.mediumField);
            JPanel buttonPanel = new JPanel(new GridLayout(0, 1, 4, 4));
            this.addButton = new JButton(i18n.COLUMNS_ADD_BUTTON_LABEL);
            this.addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String local = (String)PropertiesTab.this.localColumBox.getSelectedItem();
                    String ref = (String)PropertiesTab.this.referencingBox.getSelectedItem();
                    PropertiesTab.this.localColumBox.removeItem(local);
                    PropertiesTab.this.referencingBox.removeItem(ref);
                    PropertiesTab.this._columnTableModel.addColumn(new String[]{local, ref});
                    MergeTableDialog.this._propertiesTab.enableReferencedComboBox(false);
                    if (PropertiesTab.this.localColumBox.getItemCount() == 0 || PropertiesTab.this.referencingBox.getItemCount() == 0) {
                        PropertiesTab.this.addButton.setEnabled(false);
                    }
                    MergeTableDialog.this.checkInputCompletion();
                }
            });
            this.removeButton = new JButton(i18n.COLUMNS_REMOVE_BUTTON_LABEL);
            this.removeButton.setEnabled(false);
            this.removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = PropertiesTab.this._columTable.getSelectedRow();
                    if (index != -1) {
                        String[] removed = PropertiesTab.this._columnTableModel.deleteRow(index);
                        PropertiesTab.this.localColumBox.addItem(removed[0]);
                        PropertiesTab.this.referencingBox.addItem(removed[1]);
                        PropertiesTab.this.addButton.setEnabled(true);
                        if (PropertiesTab.this._columnTableModel.getRowCount() == 0) {
                            PropertiesTab.this.removeButton.setEnabled(false);
                            MergeTableDialog.this._propertiesTab.enableReferencedComboBox(true);
                        } else {
                            int deleteIndex = 0;
                            if (index > 0) {
                                deleteIndex = index - 1;
                            }
                            PropertiesTab.this._columTable.getSelectionModel().setSelectionInterval(0, deleteIndex);
                        }
                    }
                    MergeTableDialog.this.checkInputCompletion();
                }
            });
            Insets left = new Insets(5, 5, 5, 0);
            Insets right = new Insets(5, 0, 5, 5);
            keyPanel.add((Component)scrollTablePane, new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 17, 1, left, 0, 0));
            keyPanel.add((Component)localColumLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, left, 0, 0));
            keyPanel.add((Component)this.localColumBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, right, 0, 0));
            keyPanel.add((Component)buttonPanel, new GridBagConstraints(2, 3, 1, 2, 0.0, 0.0, 11, 0, right, 0, 0));
            keyPanel.add((Component)referencingLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, left, 0, 0));
            keyPanel.add((Component)this.referencingBox, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, right, 0, 0));
            buttonPanel.add(this.addButton);
            buttonPanel.add(this.removeButton);
            this.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.add((Component)tableField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.add((Component)referencesLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this._referencesField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)mergeDataLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)this._mergeDataBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)keyPanel, new GridBagConstraints(0, 3, 2, 2, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void setReferencesTable(String[] tableList) {
            for (String table : tableList) {
                this._referencesField.addItem(table);
            }
        }

        private void setLocalColumnBox() {
            for (TableColumnInfo column : MergeTableDialog.this._localTableColumns) {
                this.localColumBox.addItem(column.getColumnName());
            }
        }

        private void setReferencedColumnBox(String table) {
            this.referencingBox.removeAllItems();
            for (TableColumnInfo info : MergeTableDialog.this._tables.get(table)) {
                this.referencingBox.addItem(info.getColumnName());
            }
        }

        private void enableReferencedComboBox(boolean enable) {
            this._referencesField.setEnabled(enable);
        }

        public String getReferencesField() {
            return (String)this._referencesField.getSelectedItem();
        }

        public boolean getMergeData() {
            return this._mergeDataBox.isSelected();
        }

        private void initData() {
            this.setLocalColumnBox();
            Object[] tables = MergeTableDialog.this._tables.keySet().toArray(new String[0]);
            Arrays.sort(tables);
            this.setReferencesTable((String[])tables);
            this.setReferencedColumnBox((String)tables[0]);
        }
    }

    protected static interface i18n {
        public static final String DIALOG_TITLE = s_stringMgr.getString("MergeTableDialog.title");
        public static final String TABBEDPANE_PROPERTIES_LABEL = s_stringMgr.getString("MergeTableDialog.propertiesTabName");
        public static final String TABBEDPANE_COLUMNS_LABEL = s_stringMgr.getString("MergeTableDialog.columnsTabName");
        public static final String PROPERTIES_TABLENAME_LABEL = s_stringMgr.getString("MergeTableDialog.tableNameLabel");
        public static final String PROPERTIES_REFERENCES_LABEL = s_stringMgr.getString("MergeTableDialog.mergeTableLabel");
        public static final String PROPERTIES_MERGE_DATA_LABEL = s_stringMgr.getString("MergeTableDialog.mergeDataLabel");
        public static final String COLUMNS_REFERENCED_HEADER = s_stringMgr.getString("MergeTableDialog.mergeColumnsHeader");
        public static final String COLUMNS_MERGE_TABLE_HEADER = s_stringMgr.getString("MergeTableDialog.mergeTableHeader");
        public static final String COLUMNS_LOCAL_COLUMN_HEADER = s_stringMgr.getString("MergeTableDialog.localTableHeader");
        public static final String COLUMNS_REFERENCING_LABEL = s_stringMgr.getString("MergeTableDialog.mergeLabel");
        public static final String COLUMNS_ADD_BUTTON_LABEL = s_stringMgr.getString("MergeTableDialog.addButtonLabel");
        public static final String COLUMNS_REMOVE_BUTTON_LABEL = s_stringMgr.getString("MergeTableDialog.removeButtonLabel");
    }
}

